/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AsmTypeJavaClassType;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.CompoundType;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.ErrorTypeInfo;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.JavaType;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.TypeVariableArrayType;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.BlockType;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.expressions.TypeVariableDefinition;
import gw.internal.gosu.parser.expressions.TypeVariableDefinitionImpl;
import gw.lang.parser.AsmTypeVarMatcher;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.RawTypeVarMatcher;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.TypeSystemAwareCache;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.coercers.FunctionToInterfaceCoercer;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.parser.expressions.Variance;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IDynamicType;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.INonLoadableType;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeVariableArrayType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.java.asm.AsmPrimitiveType;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmWildcardType;
import gw.lang.reflect.java.asm.IAsmType;
import gw.lang.reflect.module.IModule;
import gw.util.GosuObjectUtil;
import gw.util.Pair;
import gw.util.concurrent.Cache;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;

public class TypeLord {
    private static final TypeSystemAwareCache<Pair<IType, IType>, Boolean> ASSIGNABILITY_CACHE = TypeSystemAwareCache.make((String)"Assignability Cache", (int)1000, (Cache.MissHandler)new Cache.MissHandler<Pair<IType, IType>, Boolean>(){

        public final Boolean load(Pair<IType, IType> key) {
            return TypeLord.areGenericOrParameterizedTypesAssignableInternal((IType)key.getFirst(), (IType)key.getSecond());
        }
    });

    public static Set<IType> getAllClassesInClassHierarchyAsIntrinsicTypes(IJavaClassInfo cls) {
        HashSet<IJavaClassInfo> classSet = new HashSet<IJavaClassInfo>();
        TypeLord.addAllClassesInClassHierarchy(cls, classSet);
        HashSet<IType> intrinsicTypeSet = new HashSet<IType>();
        intrinsicTypeSet.add((IType)JavaTypes.OBJECT());
        for (IJavaClassInfo classInfo : classSet) {
            intrinsicTypeSet.add(classInfo.getJavaType());
        }
        return intrinsicTypeSet;
    }

    public static Set<IType> getAllClassesInClassHierarchyAsIntrinsicTypes(IType type) {
        HashSet<IType> typeSet = new HashSet<IType>();
        TypeLord.addAllClassesInClassHierarchy(type, typeSet);
        return typeSet;
    }

    public static boolean encloses(IType type, IType inner) {
        return inner != null && (inner.getEnclosingType() == type || TypeLord.encloses(type, inner.getEnclosingType()));
    }

    public static boolean enclosingTypeInstanceInScope(IType type, IGosuClassInternal inner) {
        return inner != null && !inner.isStatic() && (type != null && type.isAssignableFrom((IType)inner.getEnclosingType()) || TypeLord.enclosingTypeInstanceInScope(type, (IGosuClassInternal)inner.getEnclosingType()));
    }

    public static Set<IType> getArrayVersionsOfEachType(Set componentTypes) {
        HashSet<IType> allTypes = new HashSet<IType>();
        allTypes.add((IType)JavaTypes.OBJECT());
        for (IType type : componentTypes) {
            allTypes.add(type.getArrayType());
        }
        return allTypes;
    }

    public static IType getActualType(Type type, TypeVarToTypeMap actualParamByVarName) {
        return TypeLord.getActualType(type, actualParamByVarName, false);
    }

    public static IType getActualType(Type type, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        return TypeLord.getActualType(type, actualParamByVarName, bKeepTypeVars, new LinkedHashSet<Type>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IType getActualType(Type type, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars, LinkedHashSet<Type> recursiveTypes) {
        Object retType;
        if (type instanceof Class) {
            retType = TypeSystem.get((Class)((Class)type));
        } else if (type instanceof TypeVariable) {
            retType = actualParamByVarName.getByMatcher((Object)((TypeVariable)type), (TypeVarToTypeMap.ITypeVarMatcher)RawTypeVarMatcher.instance());
            if (retType == null) {
                return ErrorType.getInstance(((TypeVariable)type).getName());
            }
            if (bKeepTypeVars && retType instanceof ITypeVariableType && ((TypeVariable)type).getName().equals(retType.getName()) && ((ITypeVariableType)retType).getBoundingType() != null) {
                IType boundingType = ((ITypeVariableType)retType).getBoundingType();
                IType actualBoundingType = TypeLord.getActualType(boundingType, actualParamByVarName, bKeepTypeVars);
                if (!actualBoundingType.getName().equals(boundingType.toString())) {
                    ITypeVariableDefinition typeVarDef = ((ITypeVariableType)retType).getTypeVarDef();
                    if (typeVarDef instanceof TypeVariableDefinition) {
                        typeVarDef = ((TypeVariableDefinition)typeVarDef).getTypeVarDef();
                    }
                    TypeVariableDefinitionImpl tvd = ((TypeVariableDefinitionImpl)typeVarDef).clone(actualBoundingType);
                    retType = new TypeVariableType(tvd, ((ITypeVariableType)retType).getTypeVarDef().getEnclosingType() instanceof IFunctionType);
                }
            } else if (!bKeepTypeVars) {
                retType = TypeLord.getDefaultParameterizedTypeWithTypeVars(retType);
            }
        } else if (type instanceof WildcardType) {
            Type bound = ((WildcardType)type).getUpperBounds()[0];
            Type lowerBound = TypeLord.maybeGetLowerBound((WildcardType)type, actualParamByVarName, bKeepTypeVars, recursiveTypes);
            if (lowerBound != null) {
                bound = lowerBound;
            }
            if ((retType = TypeLord.getActualType(bound, actualParamByVarName, bKeepTypeVars, recursiveTypes)) instanceof TypeVariableType) {
                ITypeVariableDefinition tvd = ((ITypeVariableType)retType).getTypeVarDef().clone();
                retType = new TypeVariableType(tvd, ((ITypeVariableType)retType).isFunctionStatement());
                ((TypeVariableType)((Object)retType)).getTypeVarDef().setVariance(((WildcardType)type).getLowerBounds().length == 0 ? Variance.WILD_COVARIANT : Variance.WILD_CONTRAVARIANT);
            }
        } else if (type instanceof ParameterizedType) {
            recursiveTypes.add(type);
            try {
                IType genType = TypeLord.getActualType(((ParameterizedType)type).getRawType(), actualParamByVarName, bKeepTypeVars, recursiveTypes);
                Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
                if (typeArgs == null || typeArgs.length == 0) {
                    retType = genType;
                }
                IType[] types = new IType[typeArgs.length];
                for (int i = 0; i < types.length; ++i) {
                    Type lowerBound;
                    Type typeArg = typeArgs[i];
                    if (!bKeepTypeVars && typeArg instanceof TypeVariable) {
                        Type bound = ((TypeVariable)typeArg).getBounds()[0];
                        if (!recursiveTypes.contains(bound)) {
                            types[i] = TypeLord.getActualType(bound, actualParamByVarName, bKeepTypeVars, recursiveTypes);
                            continue;
                        }
                        if (bound instanceof ParameterizedType) {
                            types[i] = TypeLord.getActualType(((ParameterizedType)bound).getRawType(), actualParamByVarName, bKeepTypeVars, recursiveTypes);
                            continue;
                        }
                        throw new IllegalStateException("Expecting bound to be a ParameterizedType here");
                    }
                    if (typeArg instanceof WildcardType && (((WildcardType)typeArg).getUpperBounds()[0].equals(Object.class) || ((WildcardType)typeArg).getLowerBounds().length > 0) && (lowerBound = TypeLord.maybeGetLowerBound((WildcardType)typeArg, actualParamByVarName, bKeepTypeVars, recursiveTypes)) == null) {
                        Type boundingType;
                        Type[] boundingTypes = ((Class)((ParameterizedType)type).getRawType()).getTypeParameters()[i].getBounds();
                        Type type2 = boundingType = boundingTypes.length == 0 ? null : boundingTypes[0];
                        if (boundingType != null) {
                            typeArg = boundingType;
                        }
                    }
                    types[i] = TypeLord.getActualType(typeArg, actualParamByVarName, bKeepTypeVars, recursiveTypes);
                }
                retType = genType.getParameterizedType(types);
            }
            finally {
                recursiveTypes.remove(type);
            }
        } else if (type instanceof GenericArrayType) {
            retType = TypeLord.getActualType(((GenericArrayType)type).getGenericComponentType(), actualParamByVarName, bKeepTypeVars, recursiveTypes).getArrayType();
        } else {
            throw new IllegalStateException();
        }
        return retType;
    }

    private static Type maybeGetLowerBound(WildcardType type, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars, LinkedHashSet<Type> recursiveTypes) {
        IType genType;
        LinkedList<Type> list;
        Type enclType;
        Type[] lowers = type.getLowerBounds();
        if (lowers != null && lowers.length > 0 && recursiveTypes.size() > 0 && (enclType = (list = new LinkedList<Type>(recursiveTypes)).getLast()) instanceof ParameterizedType && (genType = TypeLord.getActualType(((ParameterizedType)enclType).getRawType(), actualParamByVarName, bKeepTypeVars, recursiveTypes)) instanceof IJavaType && FunctionToInterfaceCoercer.getSingleMethodFromJavaInterface((IJavaType)((IJavaType)genType)) != null) {
            return lowers[0];
        }
        return null;
    }

    public static IType getActualType(IAsmType type, TypeVarToTypeMap actualParamByVarName) {
        return TypeLord.getActualType(type, actualParamByVarName, false, new LinkedHashSet<IAsmType>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IType getActualType(IAsmType type, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars, LinkedHashSet<IAsmType> recursiveTypes) {
        if (type instanceof AsmClass) {
            return TypeSystem.getByFullNameIfValid((String)type.getName());
        }
        if (type instanceof AsmPrimitiveType) {
            return JavaType.getPrimitiveType(type.getName());
        }
        if (type.isArray()) {
            return TypeLord.getActualType(type.getComponentType(), actualParamByVarName, bKeepTypeVars, recursiveTypes).getArrayType();
        }
        if (type.isTypeVariable()) {
            Object retType = actualParamByVarName.getByMatcher((Object)type, (TypeVarToTypeMap.ITypeVarMatcher)AsmTypeVarMatcher.instance());
            if (retType == null) {
                retType = ErrorType.getInstance(type.getName());
            }
            if (bKeepTypeVars && retType instanceof ITypeVariableType && type.getName().equals(retType.getName()) && ((ITypeVariableType)retType).getBoundingType() != null) {
                IType boundingType = ((ITypeVariableType)retType).getBoundingType();
                IType actualBoundingType = TypeLord.getActualType(boundingType, actualParamByVarName, bKeepTypeVars);
                if (actualBoundingType.getName().equals(boundingType.getName())) return retType;
                TypeVariableDefinitionImpl tvd = ((TypeVariableDefinitionImpl)((ITypeVariableType)retType).getTypeVarDef()).clone(actualBoundingType);
                return new TypeVariableType(tvd, type instanceof AsmType && ((AsmType)type).isFunctionTypeVariable());
            }
            if (bKeepTypeVars) return retType;
            return TypeLord.getDefaultParameterizedTypeWithTypeVars(retType);
        }
        if (type instanceof AsmWildcardType) {
            IType genType;
            LinkedList<IAsmType> list;
            IAsmType enclType;
            List typeArgs;
            AsmType bound = ((AsmWildcardType)type).getBound();
            if (bound != null && !((AsmWildcardType)type).isCovariant() && recursiveTypes.size() > 0 && (typeArgs = (enclType = (list = new LinkedList<IAsmType>(recursiveTypes)).getLast()).getTypeParameters()) != null && typeArgs.size() > 0 && (genType = TypeSystem.getByFullNameIfValid((String)enclType.getRawType().getName())) instanceof IJavaType && FunctionToInterfaceCoercer.getSingleMethodFromJavaInterface((IJavaType)((IJavaType)genType)) == null) {
                bound = null;
            }
            if (bound == null) {
                return JavaTypes.OBJECT();
            }
            Object actualType = TypeLord.getActualType((IAsmType)bound, actualParamByVarName, bKeepTypeVars, recursiveTypes);
            if (!(actualType instanceof TypeVariableType)) return actualType;
            ITypeVariableDefinition tvd = ((ITypeVariableType)actualType).getTypeVarDef().clone();
            actualType = new TypeVariableType(tvd, bound.isFunctionTypeVariable());
            ((TypeVariableType)((Object)actualType)).getTypeVarDef().setVariance(((AsmWildcardType)type).isCovariant() ? Variance.WILD_COVARIANT : Variance.WILD_CONTRAVARIANT);
            return actualType;
        }
        if (!(type instanceof AsmType)) throw new IllegalStateException();
        List typeArgs = type.getTypeParameters();
        if (typeArgs == null) return TypeSystem.getByFullNameIfValid((String)type.getName());
        if (typeArgs.size() == 0) {
            return TypeSystem.getByFullNameIfValid((String)type.getName());
        }
        recursiveTypes.add(type);
        try {
            ErrorType errorType;
            ArrayList<IType> types = new ArrayList<IType>(typeArgs.size());
            for (int i = 0; i < typeArgs.size(); ++i) {
                AsmType typeArg = (AsmType)typeArgs.get(i);
                IType typeParam = null;
                if (!bKeepTypeVars && typeArg.isTypeVariable()) {
                    IType t;
                    if (!recursiveTypes.contains(typeArg) && !((t = TypeLord.getActualType((IAsmType)typeArg, actualParamByVarName, bKeepTypeVars, recursiveTypes)) instanceof ErrorType)) {
                        typeParam = t;
                    }
                    if (typeParam == null) {
                        List typeParameters = typeArg.getTypeParameters();
                        if (typeParameters.isEmpty()) {
                            typeParam = JavaTypes.OBJECT();
                        } else {
                            AsmType bound = (AsmType)typeParameters.get(0);
                            if (!recursiveTypes.contains(bound)) {
                                typeParam = TypeLord.getActualType((IAsmType)bound, actualParamByVarName, bKeepTypeVars, recursiveTypes);
                            } else {
                                if (!bound.isParameterized()) throw new IllegalStateException("Expecting bound to be a parameterized here");
                                typeParam = TypeLord.getActualType((IAsmType)bound.getRawType(), actualParamByVarName, bKeepTypeVars, recursiveTypes);
                            }
                        }
                    }
                } else {
                    IJavaClassInfo classInfo;
                    if (!(!(typeArg instanceof AsmWildcardType) || ((AsmWildcardType)typeArg).getBound() != null && ((AsmWildcardType)typeArg).isCovariant() || (classInfo = TypeSystem.getDefaultTypeLoader().getJavaClassInfo(type.getRawType().getName())) == null || TypeLord.isContravariantWildcardOnFunctionalInterface((AsmWildcardType)typeArg, classInfo.getName()))) {
                        AsmType boundingType;
                        List boundingTypes = ((AsmTypeJavaClassType)classInfo.getTypeParameters()[i]).getType().getTypeParameters();
                        AsmType asmType = boundingType = boundingTypes.isEmpty() ? null : (AsmType)boundingTypes.get(0);
                        if (boundingType != null) {
                            typeArg = boundingType;
                        }
                    }
                    typeParam = TypeLord.getActualType((IAsmType)typeArg, actualParamByVarName, bKeepTypeVars, recursiveTypes);
                }
                types.add(typeParam);
            }
            String rawTypeName = type.getRawType().getName();
            IType genType = TypeSystem.getByFullNameIfValid((String)rawTypeName);
            if (genType == null) {
                errorType = ErrorType.getInstance(rawTypeName);
                return errorType;
            }
            errorType = genType.getParameterizedType(types.toArray(new IType[types.size()]));
            return errorType;
        }
        finally {
            recursiveTypes.remove(type);
        }
    }

    private static boolean isContravariantWildcardOnFunctionalInterface(AsmWildcardType typeArg, String fqn) {
        IType genType = TypeSystem.getByFullNameIfValid((String)fqn);
        return !typeArg.isCovariant() && genType instanceof IJavaType && FunctionToInterfaceCoercer.getSingleMethodFromJavaInterface((IJavaType)((IJavaType)genType)) != null;
    }

    public static IType getActualType(IType type, TypeVarToTypeMap actualParamByVarName) {
        return TypeLord.getActualType(type, actualParamByVarName, false);
    }

    public static IType getActualType(IType type, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        return TypeLord.getActualType(type, actualParamByVarName, bKeepTypeVars, new HashSet<IType>());
    }

    public static IType getActualType(IType type, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars, Set<IType> visited) {
        int iArrayDims = 0;
        if (type != null && type.isArray()) {
            iArrayDims = 0;
            while (type.isArray()) {
                type = type.getComponentType();
                ++iArrayDims;
            }
        }
        if (visited.contains(type)) {
            return type;
        }
        visited.add((IType)type);
        if (type instanceof TypeVariableType) {
            TypeVariableType saveType = (TypeVariableType)((Object)type);
            if ((type = actualParamByVarName.get((ITypeVariableType)type)) == null) {
                if (bKeepTypeVars) {
                    type = saveType;
                }
            } else if (bKeepTypeVars && type.equals((Object)saveType) && ((ITypeVariableType)type).getBoundingType() != null) {
                IType boundingType = ((ITypeVariableType)type).getBoundingType();
                IType actualBoundingType = TypeLord.getActualType(boundingType, actualParamByVarName, bKeepTypeVars, visited);
                visited.remove(boundingType);
                if (actualBoundingType != boundingType) {
                    TypeVariableDefinitionImpl tvd = ((TypeVariableDefinitionImpl)((ITypeVariableType)type).getTypeVarDef()).clone(actualBoundingType);
                    type = new TypeVariableType(tvd, ((ITypeVariableType)type).getTypeVarDef().getEnclosingType() instanceof IFunctionType);
                }
            } else if (!bKeepTypeVars && !TypeLord.isParameterizedWith(type, saveType)) {
                type = TypeLord.getActualType(type, actualParamByVarName, bKeepTypeVars, visited);
                visited.remove(type);
            } else if (!bKeepTypeVars) {
                type = TypeLord.getDefaultParameterizedTypeWithTypeVars(type);
            }
        } else if (type instanceof FunctionType) {
            if (!(type instanceof ErrorTypeInfo.UniversalFunctionType)) {
                type = ((FunctionType)type).parameterize((FunctionType)type, actualParamByVarName, bKeepTypeVars);
            }
        } else if (type != null && type.isParameterizedType()) {
            IType[] typeParams = type.getTypeParameters();
            IType[] actualParamTypes = new IType[typeParams.length];
            boolean bDifferent = false;
            for (int i = 0; i < typeParams.length; ++i) {
                boolean bAlreadyVisiting = visited.contains(typeParams[i]);
                IType actualType = TypeLord.getActualType(typeParams[i], actualParamByVarName, bKeepTypeVars, visited);
                if (!bAlreadyVisiting) {
                    visited.remove(typeParams[i]);
                }
                if (actualType == null) {
                    actualType = JavaTypes.OBJECT();
                }
                actualParamTypes[i] = actualType;
                if (actualType == typeParams[i]) continue;
                bDifferent = true;
            }
            visited.remove(type);
            Object object = type = bDifferent ? TypeLord.getPureGenericType(type).getParameterizedType(actualParamTypes) : type;
        }
        if (iArrayDims > 0 && type != null) {
            for (int j = 0; j < iArrayDims; ++j) {
                type = type.getArrayType();
            }
        }
        return type;
    }

    public static boolean isParameterizedWith(IType type, TypeVariableType typeVar) {
        if ((type = TypeLord.getCoreType(type)).equals((Object)typeVar)) {
            return true;
        }
        if (type instanceof FunctionType) {
            IType[] types;
            IFunctionType funType = (IFunctionType)type;
            for (IType param : types = funType.getParameterTypes()) {
                if (!TypeLord.isParameterizedWith(param, typeVar)) continue;
                return true;
            }
            return TypeLord.isParameterizedWith(funType.getReturnType(), typeVar);
        }
        if (type.isParameterizedType()) {
            for (IType typeParam : type.getTypeParameters()) {
                if (!TypeLord.isParameterizedWith(typeParam, typeVar)) continue;
                return true;
            }
        }
        return false;
    }

    public static IType parseType(String strParameterizedTypeName, TypeVarToTypeMap actualParamByVarName) {
        return TypeLord.parseType(strParameterizedTypeName, actualParamByVarName, null);
    }

    public static IType parseType(String strParameterizedTypeName, TypeVarToTypeMap actualParamByVarName, ITypeUsesMap typeUsesMap) {
        try {
            ITypeLiteralExpression expression = TypeLord.parseTypeLiteral(strParameterizedTypeName, actualParamByVarName, typeUsesMap);
            return expression.getType().getType();
        }
        catch (ParseResultsException e) {
            throw new RuntimeException("Unable to parse the type " + strParameterizedTypeName + ".  When attempting to parse this as a type literal, a parse error occured.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITypeLiteralExpression parseTypeLiteral(String strParameterizedTypeName, TypeVarToTypeMap actualParamByVarName, ITypeUsesMap typeUsesMap) throws ParseResultsException {
        StringTokenizer tokenizer = new StringTokenizer(strParameterizedTypeName, " <>[]?:(),", true);
        StringBuilder sbType = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            boolean bFirstToken;
            String resolvedTypeName;
            String strToken = tokenizer.nextToken();
            IType type = actualParamByVarName.getByString(strToken);
            if (type != null) {
                if (type.isParameterizedType()) {
                    type = TypeLord.resolveParameterizedType(type, actualParamByVarName);
                }
                if (type instanceof TypeVariableType) {
                    type = ((TypeVariableType)type).getBoundingType();
                }
                resolvedTypeName = type instanceof TypeVariableType ? type.getRelativeName() : type.getName();
            } else {
                resolvedTypeName = strToken;
            }
            boolean bl = bFirstToken = sbType.length() == 0;
            if (bFirstToken && "?".equals(resolvedTypeName)) {
                resolvedTypeName = JavaTypes.OBJECT().getName();
            }
            sbType.append(resolvedTypeName);
        }
        String strNormalizedType = sbType.toString().replace("$", ".");
        GosuParser parser = (GosuParser)GosuParserFactory.createParser((String)strNormalizedType, (ISymbolTable)new StandardSymbolTable(), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        parser.setAllowWildcards(true);
        if (typeUsesMap != null) {
            parser.setTypeUsesMap(typeUsesMap);
        }
        parser.pushIgnoreTypeDeprecation();
        try {
            TypeLiteral typeLiteral = parser.parseTypeLiteral((IScriptPartId)null);
            return typeLiteral;
        }
        finally {
            parser.popIgnoreTypeDeprecation();
        }
    }

    private static IType resolveParameterizedType(IType parameterizedType, TypeVarToTypeMap actualParamByVarName) {
        ArrayList<IType> resolvedParams = new ArrayList<IType>();
        for (IType paramType : parameterizedType.getTypeParameters()) {
            if (paramType instanceof TypeVariableType && actualParamByVarName.containsKey((ITypeVariableType)paramType)) {
                resolvedParams.add(actualParamByVarName.get((ITypeVariableType)paramType));
                continue;
            }
            if (paramType.isParameterizedType()) {
                resolvedParams.add(TypeLord.resolveParameterizedType(paramType, actualParamByVarName));
                continue;
            }
            resolvedParams.add(paramType);
        }
        return parameterizedType.getGenericType().getParameterizedType(resolvedParams.toArray(new IType[resolvedParams.size()]));
    }

    public static TypeVarToTypeMap mapTypeByVarName(IType ownersType, IType declaringType) {
        TypeVarToTypeMap actualParamByVarName;
        if ((ownersType = TypeLord.findActualDeclaringType(ownersType, declaringType)) != null && ownersType.isParameterizedType()) {
            actualParamByVarName = TypeLord.mapActualTypeByVarName(ownersType);
        } else {
            actualParamByVarName = TypeLord.mapGenericTypeByVarName(ownersType);
            if (ownersType != null) {
                while (ownersType.getEnclosingType() != null) {
                    ownersType = ownersType.getEnclosingType();
                    TypeVarToTypeMap vars = TypeLord.mapGenericTypeByVarName(ownersType);
                    if (actualParamByVarName.isEmpty()) {
                        actualParamByVarName = vars;
                        continue;
                    }
                    actualParamByVarName.putAll(vars);
                }
            }
        }
        return actualParamByVarName;
    }

    public static IType makeParameteredType(IType genType, TypeVarToTypeMap inferenceMap) {
        IGenericTypeVariable[] gtvs = TypeLord.getPureGenericType(genType).getGenericTypeVariables();
        IType[] typeParams = new IType[gtvs.length];
        int i = 0;
        for (IGenericTypeVariable gtv : gtvs) {
            typeParams[i] = inferenceMap.get(gtv.getTypeVariableDefinition().getType());
            if (typeParams[i] == null) {
                if (genType.isParameterizedType()) {
                    typeParams[i] = genType.getTypeParameters()[i];
                } else {
                    return null;
                }
            }
            ++i;
        }
        return genType.getParameterizedType(typeParams);
    }

    private static IType findActualDeclaringType(IType ownersType, IType declaringType) {
        if (ownersType == null) {
            return null;
        }
        if (declaringType.isParameterizedType() && !declaringType.isGenericType()) {
            return declaringType;
        }
        if (ownersType == declaringType) {
            return declaringType;
        }
        if (ownersType.getGenericType() == declaringType) {
            return ownersType;
        }
        IType actualDeclaringType = TypeLord.findActualDeclaringType(ownersType.getSupertype(), declaringType);
        if (actualDeclaringType != null && actualDeclaringType != declaringType) {
            return actualDeclaringType;
        }
        for (IType iface : ownersType.getInterfaces()) {
            actualDeclaringType = TypeLord.findActualDeclaringType(iface, declaringType);
            if (actualDeclaringType == null || actualDeclaringType == declaringType) continue;
            return actualDeclaringType;
        }
        return declaringType;
    }

    private static TypeVarToTypeMap mapActualTypeByVarName(IType ownersType) {
        TypeVarToTypeMap actualParamByVarName = new TypeVarToTypeMap();
        IGenericTypeVariable[] vars = ownersType.getGenericType().getGenericTypeVariables();
        if (vars != null) {
            IType[] paramArgs = ownersType.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                IGenericTypeVariable typeVar = vars[i];
                if (paramArgs.length <= i) continue;
                actualParamByVarName.put(typeVar.getTypeVariableDefinition().getType(), paramArgs[i]);
            }
        }
        return actualParamByVarName;
    }

    private static TypeVarToTypeMap mapGenericTypeByVarName(IType ownersType) {
        TypeVarToTypeMap genericParamByVarName = TypeVarToTypeMap.EMPTY_MAP;
        IType genType = null;
        if (ownersType != null) {
            genType = ownersType.getGenericType();
        }
        if (genType != null) {
            genericParamByVarName = new TypeVarToTypeMap();
            IGenericTypeVariable[] vars = genType.getGenericTypeVariables();
            if (vars != null) {
                for (int i = 0; i < vars.length; ++i) {
                    IGenericTypeVariable typeVar = vars[i];
                    ITypeVariableType type = typeVar.getTypeVariableDefinition().getType();
                    if (genericParamByVarName.containsKey(type)) continue;
                    genericParamByVarName.put(type, (IType)new TypeVariableType(ownersType, typeVar));
                }
            }
        }
        return genericParamByVarName;
    }

    public static String getNameWithQualifiedTypeVariables(IType type, boolean includeModules) {
        if (type.isArray()) {
            return TypeLord.getNameWithQualifiedTypeVariables(type.getComponentType(), includeModules) + "[]";
        }
        if (type.isParameterizedType()) {
            String strParams = TypeLord.getNameOfParams(type.getTypeParameters(), false, true, includeModules);
            return TypeLord.getPureGenericType(type).getName() + strParams;
        }
        if (type instanceof TypeVariableType && type.getEnclosingType() != null) {
            return ((TypeVariableType)type).getNameWithEnclosingType();
        }
        return type.getName();
    }

    public static String getNameWithBoundQualifiedTypeVariables(IType type, boolean includeModules) {
        if (type.isArray()) {
            return TypeLord.getNameWithQualifiedTypeVariables(type.getComponentType(), includeModules) + "[]";
        }
        if (type.isParameterizedType()) {
            String strParams = TypeLord.getNameOfParams(type.getTypeParameters(), false, true, includeModules);
            return TypeLord.getPureGenericType(type).getName() + strParams;
        }
        if (type instanceof TypeVariableType && type.getEnclosingType() != null) {
            return ((TypeVariableType)type).getNameWithBoundingType();
        }
        return type.getName();
    }

    public static String getNameOfParams(IType[] paramTypes, boolean bRelative, boolean bWithEnclosingType) {
        return TypeLord.getNameOfParams(paramTypes, bRelative, bWithEnclosingType, false);
    }

    public static String getNameOfParams(IType[] paramTypes, boolean bRelative, boolean bWithEnclosingType, boolean bIncludeModule) {
        return TypeLord._getNameOfParams(paramTypes, bRelative, bWithEnclosingType, bIncludeModule, new HashSet<IType>());
    }

    private static String _getNameOfParams(IType[] paramTypes, boolean bRelative, boolean bWithEnclosingType, boolean bIncludeModule, Set<IType> visited) {
        StringBuilder sb = new StringBuilder("<");
        for (int i = 0; i < paramTypes.length; ++i) {
            IType paramType = paramTypes[i];
            if (bRelative) {
                sb.append(paramType.getRelativeName());
            } else {
                TypeLord.appendTypeName(bWithEnclosingType, bIncludeModule, sb, paramType, visited);
            }
            if (i >= paramTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append('>');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StringBuilder appendTypeName(boolean bWithEnclosingType, boolean bIncludeModule, StringBuilder sb, IType paramType, Set<IType> visited) {
        if (paramType.isArray()) {
            TypeLord.appendTypeName(bWithEnclosingType, bIncludeModule, sb, paramType.getComponentType(), visited).append("[]");
            return sb;
        } else if (bWithEnclosingType && paramType instanceof TypeVariableType && !visited.contains(paramType)) {
            visited.add(paramType);
            try {
                TypeVariableType type = (TypeVariableType)paramType;
                if (type.getEnclosingType() != null) {
                    if (bIncludeModule && !(type.getEnclosingType() instanceof INonLoadableType)) {
                        sb.append(type.getEnclosingType().getTypeLoader().getModule().getName()).append(".");
                    }
                    sb.append(type.getNameWithEnclosingType());
                    ITypeVariableDefinition typeVarDef = type.getTypeVarDef();
                    if (typeVarDef == null) return sb;
                    sb.append(typeVarDef.getVariance().getSymbol());
                    IType boundingType = typeVarDef.getBoundingType();
                    if (!type.isFunctionStatement() || boundingType == null || boundingType == JavaTypes.OBJECT()) return sb;
                    sb.append('-');
                    TypeLord.appendTypeName(bWithEnclosingType, bIncludeModule, sb, boundingType, visited);
                    return sb;
                }
                sb.append(type.getName());
                return sb;
            }
            finally {
                visited.remove(paramType);
            }
        } else if (bWithEnclosingType && paramType.isParameterizedType()) {
            sb.append(paramType.getGenericType().getName());
            sb.append(TypeLord._getNameOfParams(paramType.getTypeParameters(), false, bWithEnclosingType, bIncludeModule, visited));
            return sb;
        } else {
            IModule oldModule;
            ITypeLoader typeLoader;
            if (bIncludeModule && !(paramType instanceof INonLoadableType) && (typeLoader = paramType.getTypeLoader()) != null && (oldModule = typeLoader.getModule()) != null) {
                sb.append(oldModule.getName()).append(".");
            }
            sb.append(paramType.getName());
        }
        return sb;
    }

    public static boolean isDelegatableInterface(IType declaringType, IType iface) {
        if (iface.isAssignableFrom(declaringType)) {
            return true;
        }
        IType superClass = declaringType.getSupertype();
        if (superClass != null && TypeLord.isDelegatableInterface(superClass, iface)) {
            return true;
        }
        IType[] interfaces = declaringType.getInterfaces();
        if (interfaces != null) {
            for (IType t : interfaces) {
                if (!TypeLord.isDelegatableInterface(t, iface)) continue;
                return true;
            }
        }
        return false;
    }

    public static IType findParameterizedStructureType(IType structureType, IType from) {
        TypeVarToTypeMap inferenceMap = new TypeVarToTypeMap();
        if (!StandardCoercionManager.isStructurallyAssignable_Laxed((IType)structureType, (IType)from, (TypeVarToTypeMap)inferenceMap)) {
            return null;
        }
        return TypeLord.makeParameteredType(structureType, inferenceMap);
    }

    public static IType findParameterizedType(IType sourceType, IType rawGenericType) {
        return TypeLord.findParameterizedType(sourceType, rawGenericType, false);
    }

    public static IType findParameterizedType(IType sourceType, IType rawGenericType, boolean bForAssignability) {
        if (sourceType == null) {
            return null;
        }
        rawGenericType = TypeLord.getPureGenericType(rawGenericType);
        IType srcRawType = sourceType.getGenericType();
        if (srcRawType == rawGenericType || !bForAssignability && srcRawType instanceof IMetaType && rawGenericType == JavaTypes.CLASS()) {
            return sourceType;
        }
        IType parameterizedType = TypeLord.findParameterizedType(sourceType.getSupertype(), rawGenericType, bForAssignability);
        if (parameterizedType != null) {
            return parameterizedType;
        }
        IType[] interfaces = sourceType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            IType iface = interfaces[i];
            parameterizedType = TypeLord.findParameterizedType(iface, rawGenericType, bForAssignability);
            if (parameterizedType == null) continue;
            return parameterizedType;
        }
        return null;
    }

    public static IType findParameterizedType_Reverse(IType sourceType, IType targetType) {
        if (sourceType == null || targetType == null) {
            return null;
        }
        if (!sourceType.isParameterizedType()) {
            return null;
        }
        IType sourceTypeInHier = TypeLord.findParameterizedType(targetType, TypeLord.getPureGenericType(sourceType));
        if (sourceTypeInHier == null || !sourceTypeInHier.isParameterizedType()) {
            return null;
        }
        TypeVarToTypeMap map = new TypeVarToTypeMap();
        IType[] params = sourceTypeInHier.getTypeParameters();
        for (int iPos = 0; iPos < params.length; ++iPos) {
            if (!(params[iPos] instanceof ITypeVariableType)) continue;
            map.put((ITypeVariableType)params[iPos], sourceType.getTypeParameters()[iPos]);
        }
        return TypeLord.getActualType(targetType, map, true);
    }

    public static IType findParameterizedTypeInHierarchy(IType sourceType, IType rawGenericType) {
        if (sourceType == null) {
            return null;
        }
        if (sourceType.isParameterizedType() && sourceType.getGenericType().equals(rawGenericType)) {
            return sourceType;
        }
        IType[] list = sourceType.getInterfaces();
        for (int i = 0; i < list.length; ++i) {
            IType returnType = TypeLord.findParameterizedTypeInHierarchy(list[i], rawGenericType);
            if (returnType == null) continue;
            return returnType;
        }
        return TypeLord.findParameterizedTypeInHierarchy(sourceType.getSupertype(), rawGenericType);
    }

    public static void addAllClassesInClassHierarchy(Class entityClass, Set<Class> set) {
        if (!set.add(entityClass)) {
            return;
        }
        Class<?>[] interfaces = entityClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            TypeLord.addAllClassesInClassHierarchy(interfaces[i], set);
        }
        if (entityClass.getSuperclass() != null) {
            TypeLord.addAllClassesInClassHierarchy(entityClass.getSuperclass(), set);
        }
    }

    private static void addAllClassesInClassHierarchy(IJavaClassInfo entityClass, Set<IJavaClassInfo> set) {
        if (!set.add(entityClass)) {
            return;
        }
        IJavaClassInfo[] interfaces = entityClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            TypeLord.addAllClassesInClassHierarchy(interfaces[i], set);
        }
        if (entityClass.getSuperclass() != null) {
            TypeLord.addAllClassesInClassHierarchy(entityClass.getSuperclass(), set);
        }
    }

    public static void addAllClassesInClassHierarchy(IType type, Set<IType> set) {
        TypeLord.addAllClassesInClassHierarchy(type, set, false);
    }

    public static void addAllClassesInClassHierarchy(IType type, Set<IType> set, boolean bForce) {
        if (!set.add(type) && !bForce) {
            return;
        }
        boolean bFromStructure = type instanceof IGosuClass && ((IGosuClass)type).isStructure();
        for (IType iface : type.getInterfaces()) {
            if (bFromStructure && iface instanceof IGosuClass && !((IGosuClass)iface).isStructure()) continue;
            TypeLord.addAllClassesInClassHierarchy(iface, set);
        }
        if (type.getSupertype() != null) {
            TypeLord.addAllClassesInClassHierarchy(type.getSupertype(), set);
        }
        if (type.isParameterizedType()) {
            set.add(type.getGenericType());
        }
    }

    public static <E extends IType> E getPureGenericType(E type) {
        if (type == null || TypeSystem.isDeleted(type)) {
            return null;
        }
        if (type.isArray()) {
            return (E)TypeLord.getPureGenericType(type.getComponentType()).getArrayType();
        }
        while (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        return type;
    }

    public static IType deriveParameterizedTypeFromContext(IType type, IType contextType) {
        if (!type.isGenericType() || type.isParameterizedType()) {
            return type;
        }
        if (type instanceof MetaType) {
            return (IType)MetaType.DEFAULT_TYPE_TYPE.get();
        }
        if (contextType == null || !contextType.isParameterizedType()) {
            return TypeLord.makeDefaultParameterizedType(type);
        }
        IType genType = TypeLord.getPureGenericType(contextType);
        if (!genType.isGenericType() || !genType.isAssignableFrom(type)) {
            return TypeLord.makeDefaultParameterizedType(type);
        }
        IType parameterizedWithTypeVars = type.getParameterizedType((IType[])Arrays.stream(type.getGenericTypeVariables()).map(gtv -> gtv.getTypeVariableDefinition().getType()).toArray(IType[]::new));
        IType result = TypeLord.findParameterizedType_Reverse(contextType, parameterizedWithTypeVars);
        if (result == null) {
            result = TypeLord.makeDefaultParameterizedType(type);
        }
        return result;
    }

    public static IType makeDefaultParameterizedType(IType type) {
        if (type != null && !(type instanceof IGosuEnhancementInternal) && !type.isParameterizedType() && type.isGenericType()) {
            if (type instanceof MetaType) {
                return (IType)MetaType.DEFAULT_TYPE_TYPE.get();
            }
            IType[] boundingTypes = new IType[type.getGenericTypeVariables().length];
            for (int i = 0; i < boundingTypes.length; ++i) {
                boundingTypes[i] = type.getGenericTypeVariables()[i].getBoundingType();
                IGenericTypeVariable typeVar = type.getGenericTypeVariables()[i];
                if (!TypeLord.isRecursiveType(typeVar.getTypeVariableDefinition().getType(), typeVar.getBoundingType())) continue;
                return type;
            }
            if (boundingTypes.length == 0) {
                return type;
            }
            type = type.getParameterizedType(boundingTypes);
        }
        return type;
    }

    public static IType replaceTypeVariableTypeParametersWithBoundingTypes(IType type) {
        return TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(type, null);
    }

    public static IType replaceTypeVariableTypeParametersWithBoundingTypes(IType type, IType enclType) {
        if (type instanceof ITypeVariableType) {
            if (TypeLord.isRecursiveType((ITypeVariableType)type, ((ITypeVariableType)type).getBoundingType())) {
                return TypeLord.getPureGenericType(((ITypeVariableType)type).getBoundingType());
            }
            if (enclType != null && enclType.isParameterizedType()) {
                TypeVarToTypeMap map = TypeLord.mapTypeByVarName(enclType, enclType);
                return TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(TypeLord.getActualType(((ITypeVariableType)type).getBoundingType(), map, true));
            }
            return TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(((ITypeVariableType)type).getBoundingType(), enclType);
        }
        if (type.isArray()) {
            return TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(type.getComponentType(), enclType).getArrayType();
        }
        if (type instanceof CompoundType) {
            Set<IType> types = ((CompoundType)type).getTypes();
            HashSet<IType> newTypes = new HashSet<IType>();
            for (IType t : types) {
                newTypes.add(TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(t));
            }
            if (newTypes.size() == 1) {
                return (IType)newTypes.iterator().next();
            }
            return CompoundType.get(newTypes);
        }
        if (type.isParameterizedType()) {
            IType[] typeParams = type.getTypeParameters();
            IType[] concreteParams = new IType[typeParams.length];
            for (int i = 0; i < typeParams.length; ++i) {
                concreteParams[i] = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(typeParams[i], enclType);
            }
            type = type.getParameterizedType(concreteParams);
        } else if (type.isGenericType()) {
            int i;
            IType[] boundingTypes = new IType[type.getGenericTypeVariables().length];
            for (i = 0; i < boundingTypes.length; ++i) {
                boundingTypes[i] = type.getGenericTypeVariables()[i].getBoundingType();
                if (!TypeLord.isRecursiveType(type.getGenericTypeVariables()[i].getTypeVariableDefinition().getType(), boundingTypes[i])) continue;
                return type;
            }
            for (i = 0; i < boundingTypes.length; ++i) {
                boundingTypes[i] = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(boundingTypes[i], enclType);
            }
            type = type.getParameterizedType(boundingTypes);
        }
        return type;
    }

    public static IType replaceRawGenericTypesWithDefaultParameterizedTypes(IType type) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            IType compType = TypeLord.replaceRawGenericTypesWithDefaultParameterizedTypes(type.getComponentType());
            if (compType != type.getComponentType()) {
                return compType.getArrayType();
            }
            return type;
        }
        if (type.isParameterizedType()) {
            IType[] typeParameters = type.getTypeParameters();
            IType[] typeParams = new IType[typeParameters.length];
            boolean bReplaced = false;
            for (int i = 0; i < typeParameters.length; ++i) {
                IType typeParam = typeParameters[i];
                typeParams[i] = TypeLord.replaceRawGenericTypesWithDefaultParameterizedTypes(typeParam);
                if (typeParam == typeParams[i]) continue;
                bReplaced = true;
            }
            return bReplaced ? type.getParameterizedType(typeParams) : type;
        }
        if (type.isGenericType()) {
            return TypeLord.getDefaultParameterizedType(type);
        }
        return type;
    }

    public static IType getDefaultParameterizedType(IType type) {
        if (type.isArray()) {
            IType defType = TypeLord.getDefaultParameterizedType(type.getComponentType());
            if (defType != type) {
                return defType.getArrayType();
            }
            return type;
        }
        if (type instanceof CompoundType) {
            return TypeLord.makeDefaultParameterizedTypeForCompoundType(type);
        }
        if (!type.isGenericType() && !type.isParameterizedType()) {
            return type;
        }
        type = TypeLord.getPureGenericType(type);
        return TypeLord.makeDefaultParameterizedType(type);
    }

    private static IType makeDefaultParameterizedTypeForCompoundType(IType type) {
        IType[] defCompTypes = new IType[type.getCompoundTypeComponents().size()];
        int i = 0;
        boolean bDifferent = false;
        for (IType compType : type.getCompoundTypeComponents()) {
            defCompTypes[i++] = TypeLord.getDefaultParameterizedType(compType);
            bDifferent = bDifferent || defCompTypes[i] != compType;
        }
        if (bDifferent) {
            type = CompoundType.get(defCompTypes);
        }
        return type;
    }

    public static IType getDefaultParameterizedTypeWithTypeVars(IType type) {
        return TypeLord.getDefaultParameterizedTypeWithTypeVars(type, null, new HashSet<IType>());
    }

    public static IType getDefaultParameterizedTypeWithTypeVars(IType type, TypeVarToTypeMap map) {
        return TypeLord.getDefaultParameterizedTypeWithTypeVars(type, map, new HashSet<IType>());
    }

    public static IType getDefaultParameterizedTypeWithTypeVars(IType type, TypeVarToTypeMap map, Set<IType> visited) {
        if (type.isArray()) {
            return TypeLord.getDefaultParameterizedTypeWithTypeVars(type.getComponentType(), map, visited).getArrayType();
        }
        if (type instanceof ITypeVariableType) {
            IType assignedType;
            if (map != null && (assignedType = map.get((ITypeVariableType)type)) != null) {
                return assignedType;
            }
            return TypeLord.getDefaultParameterizedTypeWithTypeVars(((ITypeVariableType)type).getBoundingType(), map, visited);
        }
        if (type instanceof ITypeVariableArrayType) {
            return TypeLord.getDefaultParameterizedTypeWithTypeVars(((ITypeVariableType)type.getComponentType()).getBoundingType(), map, visited).getArrayType();
        }
        if (!type.isGenericType() && !type.isParameterizedType()) {
            return type;
        }
        if (!visited.contains(type)) {
            visited.add(type);
            if (TypeLord.isParameterizedType(type) && TypeLord.isRecursiveType(type)) {
                IType[] typeParameters = type.getTypeParameters();
                IType[] typeParams = new IType[typeParameters.length];
                int i = 0;
                for (IType param : typeParameters) {
                    typeParams[i++] = TypeLord.getDefaultParameterizedTypeWithTypeVars(param, map, visited);
                }
                return TypeLord.getPureGenericType(type).getParameterizedType(typeParams);
            }
            if (type.isGenericType() && !type.isParameterizedType() && TypeLord.isRecursiveTypeFromBase(type)) {
                IGenericTypeVariable[] gvs = type.getGenericTypeVariables();
                IType[] typeParams = new IType[gvs.length];
                int i = 0;
                for (IGenericTypeVariable param : gvs) {
                    ITypeVariableDefinition typeDef = param.getTypeVariableDefinition();
                    if (typeDef != null) {
                        ITypeVariableType typeVarType = typeDef.getType();
                        if (TypeLord.isRecursiveType(typeVarType, typeVarType.getBoundingType())) {
                            typeParams[i++] = TypeLord.getPureGenericType(typeVarType.getBoundingType());
                            continue;
                        }
                        typeParams[i++] = TypeLord.getDefaultParameterizedTypeWithTypeVars((IType)typeVarType, map, visited);
                        continue;
                    }
                    typeParams[i++] = TypeLord.getDefaultParameterizedTypeWithTypeVars(typeDef.getBoundingType(), map, visited);
                }
                return TypeLord.getPureGenericType(type).getParameterizedType(typeParams);
            }
        }
        type = TypeLord.getPureGenericType(type);
        return TypeLord.makeDefaultParameterizedType(type);
    }

    public static boolean isRecursiveTypeFromBase(IType rootType) {
        if (!rootType.isGenericType() && !rootType.isParameterizedType()) {
            return false;
        }
        IType genType = TypeLord.getPureGenericType(rootType);
        if (genType != TypeLord.getDefaultParameterizedType(genType)) {
            return false;
        }
        if (rootType.isGenericType() && !rootType.isParameterizedType()) {
            if (rootType == TypeLord.getDefaultParameterizedType(rootType)) {
                return true;
            }
        } else if (rootType.isParameterizedType()) {
            for (IType typeParam : rootType.getTypeParameters()) {
                if (!TypeLord.isRecursiveTypeFromBase(typeParam)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRecursiveType(IType declaringClass) {
        return TypeLord._isRecursiveType(declaringClass, new HashSet<IType>());
    }

    private static boolean _isRecursiveType(IType declaringClass, Set<IType> visited) {
        block10: {
            block9: {
                if (declaringClass instanceof ITypeVariableType) {
                    if (visited.contains(declaringClass)) {
                        return true;
                    }
                    visited.add(declaringClass);
                    try {
                        boolean bl = TypeLord._isRecursiveType(((ITypeVariableType)declaringClass).getBoundingType(), visited);
                        return bl;
                    }
                    finally {
                        visited.remove(declaringClass);
                    }
                }
                if (declaringClass.isArray()) {
                    return TypeLord._isRecursiveType(declaringClass.getComponentType(), visited);
                }
                if (!declaringClass.isGenericType() && !declaringClass.isParameterizedType()) {
                    return false;
                }
                if (!declaringClass.isGenericType() || declaringClass.isParameterizedType()) break block9;
                for (IGenericTypeVariable gtv : declaringClass.getGenericTypeVariables()) {
                    ITypeVariableDefinition tvd = gtv.getTypeVariableDefinition();
                    if (tvd == null || !TypeLord._isRecursiveType((IType)tvd.getType(), visited)) continue;
                    return true;
                }
                break block10;
            }
            if (!declaringClass.isParameterizedType()) break block10;
            for (IType typeParam : declaringClass.getTypeParameters()) {
                if (!TypeLord._isRecursiveType(typeParam, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSubtype(IType subtype, IType supertype) {
        if (subtype == null) {
            return false;
        }
        subtype = TypeLord.getPureGenericType(subtype);
        if ((supertype = TypeLord.getPureGenericType(supertype)) instanceof IGosuClassInternal && ((IGosuClassInternal)supertype).isSubClass(subtype)) {
            return true;
        }
        IType st = TypeLord.getPureGenericType(subtype.getSupertype());
        return st == supertype || TypeLord.isSubtype(st, supertype);
    }

    static String fixSunInnerClassBug(String type) {
        int i = type.indexOf("$", 0);
        if (i < 0) {
            return type;
        }
        int n = 0;
        i = 0;
        StringBuilder sb = new StringBuilder(type);
        while (i >= 0) {
            i = TypeLord.findNthPositionOfString(n, sb, "$");
            TypeLord.removeDuplicateClassName(sb, i);
            ++n;
        }
        return sb.toString();
    }

    private static int findNthPositionOfString(int n, StringBuilder sb, String str) {
        int i = 0;
        for (int count = 0; count <= n; ++count) {
            i = sb.indexOf(str, i + 1);
        }
        return i;
    }

    static void removeDuplicateClassName(StringBuilder sb, int dollarSignPosition) {
        int start;
        StringBuilder foundBuffer = new StringBuilder();
        boolean chopped = false;
        for (start = dollarSignPosition - 1; start >= 0; --start) {
            foundBuffer.append(sb.charAt(start));
            if (!TypeLord.repeatsWithDot(foundBuffer) || chopped) continue;
            foundBuffer.setLength(foundBuffer.length() / 2);
            chopped = true;
            break;
        }
        if (chopped) {
            sb.replace(start, dollarSignPosition, foundBuffer.reverse().toString());
        }
    }

    static boolean repeatsWithDot(StringBuilder sb) {
        if (sb == null || sb.length() % 2 == 0) {
            return false;
        }
        int halfPoint = sb.length() / 2;
        if (sb.charAt(halfPoint) != '.') {
            return false;
        }
        for (int i = 0; i < halfPoint; ++i) {
            if (sb.charAt(i) == sb.charAt(i + halfPoint + 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean areGenericOrParameterizedTypesAssignable(IType to, IType from) {
        return (Boolean)ASSIGNABILITY_CACHE.get((Object)Pair.make((Object)to, (Object)from));
    }

    private static boolean areGenericOrParameterizedTypesAssignableInternal(IType to, IType from) {
        if (from instanceof CompoundType) {
            Set<IType> types = ((CompoundType)from).getTypes();
            for (IType type : types) {
                if (!TypeLord.areGenericOrParameterizedTypesAssignable(to, type)) continue;
                return true;
            }
            return false;
        }
        if (to.isParameterizedType() || to.isGenericType()) {
            if (from.isGenericType() && !from.isParameterizedType() && to.isParameterizedType() && TypeLord.getPureGenericType(to).isAssignableFrom(from)) {
                return true;
            }
            IType relatedParameterizedType = TypeLord.findParameterizedType(from, to.getGenericType(), true);
            if (relatedParameterizedType == null) {
                if (from == to.getGenericType()) {
                    relatedParameterizedType = from;
                } else {
                    return from instanceof TypeVariableType && ((TypeVariableType)from).getBoundingType() == GosuParser.PENDING_BOUNDING_TYPE;
                }
            }
            if (from.isGenericType() && to.isParameterizedType() && TypeLord.sameAsDefaultProxiedType(to, from)) {
                return true;
            }
            IType[] typeParams = to.getTypeParameters();
            if (typeParams != null) {
                IType[] paramTypesFrom = relatedParameterizedType.getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    IType paramType = typeParams[i];
                    Boolean bDeclarationSiteResult = TypeLord.compareWithDeclarationSiteVariance(to, relatedParameterizedType, i);
                    if (!(bDeclarationSiteResult != null ? bDeclarationSiteResult == false : paramType != JavaTypes.OBJECT() && (paramTypesFrom == null || paramTypesFrom.length <= i || !paramType.isAssignableFrom(paramTypesFrom[i]) && !StandardCoercionManager.isStructurallyAssignable((IType)paramType, (IType)paramTypesFrom[i]) && (!JavaTypes.CLASS().isAssignableFrom(to) || !StandardCoercionManager.isStructurallyAssignable((IType)paramType, (IType)MetaType.getLiteral(paramTypesFrom[i])))))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static Boolean compareWithDeclarationSiteVariance(IType to, IType from, int iIndex) {
        IType fromGenType;
        IType toGenType = TypeLord.getPureGenericType(to);
        if (toGenType != (fromGenType = TypeLord.getPureGenericType(from))) {
            return null;
        }
        IGenericTypeVariable[] toGtvs = toGenType.getGenericTypeVariables();
        if (toGtvs == null || iIndex >= toGtvs.length) {
            return null;
        }
        IGenericTypeVariable[] fromGtvs = fromGenType.getGenericTypeVariables();
        if (fromGtvs == null || iIndex >= fromGtvs.length) {
            return null;
        }
        if (toGtvs.length != fromGtvs.length) {
            return null;
        }
        IType[] toTypeParams = to.getTypeParameters();
        if (toTypeParams == null || iIndex >= toTypeParams.length) {
            return null;
        }
        IType[] fromTypeParams = from.getTypeParameters();
        if (fromTypeParams == null || iIndex >= fromTypeParams.length) {
            return null;
        }
        ITypeVariableDefinition typeVarDef = toGtvs[iIndex].getTypeVariableDefinition();
        if (typeVarDef == null) {
            return null;
        }
        IType toTypeParam = toTypeParams[iIndex];
        IType fromTypeParam = fromTypeParams[iIndex];
        switch (typeVarDef.getVariance()) {
            case COVARIANT: {
                return toTypeParam.isAssignableFrom(fromTypeParam);
            }
            case CONTRAVARIANT: {
                return fromTypeParam.isAssignableFrom(toTypeParam);
            }
            case INVARIANT: {
                return toTypeParam.equals(fromTypeParam);
            }
        }
        return null;
    }

    private static boolean sameAsDefaultProxiedType(IType to, IType from) {
        if (to instanceof IJavaTypeInternal && from instanceof IGosuClassInternal && ((IGosuClassInternal)from).isProxy()) {
            IJavaType proxiedType = ((IGosuClassInternal)from).getJavaType();
            return proxiedType != null && (TypeLord.makeDefaultParameterizedType((IType)proxiedType) == to || TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes((IType)proxiedType) == to);
        }
        return false;
    }

    public static Set<String> getNamespacesFromTypeNames(Set<? extends CharSequence> typeNames, Set<String> namespaces) {
        for (CharSequence charSequence : typeNames) {
            String strPossibleEnclosingTypeName;
            String strName = charSequence.toString();
            int iIndex = strName.lastIndexOf(46);
            if (iIndex > 0 && typeNames.contains(strPossibleEnclosingTypeName = strName.substring(0, iIndex))) continue;
            TypeLord.addNamespace(namespaces, strName);
        }
        namespaces.add("_nopackage_");
        return namespaces;
    }

    public static void addNamespace(Set<String> namespaces, String strType) {
        String strPackage;
        int iIndex = strType.lastIndexOf(46);
        if (iIndex > 0 && namespaces.add(strPackage = strType.substring(0, iIndex))) {
            TypeLord.addNamespace(namespaces, strPackage);
        }
    }

    public static IType getRootType(IType type) {
        IType result = type;
        while (result.getSupertype() != null || result.getSupertype() != JavaTypes.OBJECT()) {
            result = result.getSupertype();
        }
        return result;
    }

    public static IType findGreatestLowerBound(IType t1, IType t2) {
        if (t1.equals(t2)) {
            return t1;
        }
        if (t1.isAssignableFrom(t2)) {
            return t2;
        }
        if (t2.isAssignableFrom(t1)) {
            return t1;
        }
        return t1;
    }

    public static IType findLeastUpperBound(List<? extends IType> types) {
        return TypeLord.findLeastUpperBoundImpl(types, new HashSet<IType>());
    }

    /*
     * WARNING - void declaration
     */
    private static IType findLeastUpperBoundImpl(List<? extends IType> types, Set<IType> resolvingTypes) {
        void var6_13;
        boolean bl;
        if (types.size() == 0) {
            return JavaTypes.pVOID();
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        for (IType iType : types) {
            if (!(iType instanceof IPlaceholder) || !((IPlaceholder)iType).isPlaceholder()) continue;
            return iType.getName().equals("dynamic.Dynamic") ? iType : IDynamicType.instance();
        }
        IType lubType = null;
        boolean bl2 = false;
        boolean foundOnlyNullTypes = true;
        for (IType iType : types) {
            if (iType.equals(GosuParserTypes.NULL_TYPE())) continue;
            foundOnlyNullTypes = false;
            if (lubType == null) {
                lubType = iType;
            }
            if (lubType.equals(iType) || BeanAccess.isBoxedTypeFor(lubType, iType) || BeanAccess.isBoxedTypeFor(iType, lubType)) continue;
            bl = true;
            break;
        }
        if (foundOnlyNullTypes) {
            return GosuParserTypes.NULL_TYPE();
        }
        if (!bl) {
            return lubType;
        }
        for (IType iType : types) {
            if (!resolvingTypes.contains(iType)) continue;
            return JavaTypes.OBJECT();
        }
        resolvingTypes.addAll(types);
        IType seedType = types.get(0);
        if (TypeLord.areAllTypesBlocks(types)) {
            Set<IType> set = TypeLord.findLubForBlockTypes(types, resolvingTypes);
        } else {
            HashSet hashSet = new HashSet(seedType.getAllTypesInHierarchy());
            for (int i = 1; i < types.size(); ++i) {
                IType iIntrinsicType = types.get(i);
                hashSet.retainAll(iIntrinsicType.getAllTypesInHierarchy());
            }
        }
        TypeLord.pruneNonLUBs((Set<IType>)var6_13);
        if (var6_13.size() == 0) {
            return JavaTypes.OBJECT();
        }
        Set<IType> set = TypeLord.findParameterizationLUBS(types, (Set<IType>)var6_13, resolvingTypes);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        return CompoundType.get(set);
    }

    private static Set<IType> findLubForBlockTypes(List<? extends IBlockType> types, Set<IType> resolvingTypes) {
        IBlockType lowerBound = types.get(0);
        for (int i = 1; i < types.size(); ++i) {
            IBlockType csr = types.get(i);
            if (lowerBound.isAssignableFrom((IType)csr)) continue;
            IType[] contraTypes = FunctionType.findContravariantParams((IType[])lowerBound.getParameterTypes(), (IType[])csr.getParameterTypes());
            if (contraTypes == null) {
                return Collections.singleton(JavaTypes.IBLOCK());
            }
            IType returnType = TypeLord.findLeastUpperBoundImpl(Arrays.asList(lowerBound.getReturnType(), csr.getReturnType()), resolvingTypes);
            lowerBound = new BlockType(returnType, contraTypes, Arrays.asList(lowerBound.getParameterNames()), Collections.emptyList());
        }
        return Collections.singleton(lowerBound);
    }

    private static boolean areAllTypesBlocks(List<? extends IType> types) {
        for (IType iType : types) {
            if (iType instanceof IBlockType) continue;
            return false;
        }
        return true;
    }

    public static IType getLeastUpperBoundForPrimitiveTypes(IType t0, IType t1) {
        if (t0 == null || t1 == null) {
            return null;
        }
        if (t0 == t1) {
            return t0;
        }
        boolean toT0FromT1 = TypeLord.isAWideningConversion(t0, t1);
        boolean toT1FromT0 = TypeLord.isAWideningConversion(t1, t0);
        if (toT0FromT1) {
            return t0;
        }
        if (toT1FromT0) {
            return t1;
        }
        return null;
    }

    private static int getIndex(IType type) {
        if (type == JavaTypes.pBOOLEAN() || type == JavaTypes.BOOLEAN()) {
            return 0;
        }
        if (type == JavaTypes.pCHAR() || type == JavaTypes.CHARACTER()) {
            return 1;
        }
        if (type == JavaTypes.pBYTE() || type == JavaTypes.BYTE()) {
            return 2;
        }
        if (type == JavaTypes.pSHORT() || type == JavaTypes.SHORT()) {
            return 3;
        }
        if (type == JavaTypes.pINT() || type == JavaTypes.INTEGER()) {
            return 4;
        }
        if (type == JavaTypes.pLONG() || type == JavaTypes.LONG()) {
            return 5;
        }
        if (type == JavaTypes.pFLOAT() || type == JavaTypes.FLOAT()) {
            return 6;
        }
        if (type == JavaTypes.pDOUBLE() || type == JavaTypes.DOUBLE()) {
            return 7;
        }
        if (type == JavaTypes.BIG_INTEGER()) {
            return 8;
        }
        if (type == JavaTypes.BIG_DECIMAL()) {
            return 9;
        }
        return -1;
    }

    private static boolean isAWideningConversion(IType to, IType from) {
        boolean[][] tab = new boolean[][]{{true, false, false, false, false, false, false, false, false, false}, {false, true, false, false, true, true, true, true, true, true}, {false, false, true, true, true, true, true, true, true, true}, {false, false, false, true, true, true, true, true, true, true}, {false, false, false, false, true, true, false, true, true, true}, {false, false, false, false, false, true, false, false, true, true}, {false, false, false, false, false, false, true, true, false, true}, {false, false, false, false, false, false, false, true, false, true}, {false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, true}};
        int i = TypeLord.getIndex(from);
        int j = TypeLord.getIndex(to);
        if (i == -1 || j == -1) {
            return false;
        }
        return tab[i][j];
    }

    private static Set<IType> findParameterizationLUBS(List<? extends IType> currentTypes, Set<IType> lubSet, Set<IType> resolvingTypes) {
        HashSet<IType> returnSet = new HashSet<IType>();
        for (IType lub : lubSet) {
            if (lub.isGenericType() && !lub.isParameterizedType() && currentTypes.size() > 1) {
                ArrayList typeParametersByPosition = new ArrayList(lub.getGenericTypeVariables().length);
                for (int i = 0; i < lub.getGenericTypeVariables().length; ++i) {
                    typeParametersByPosition.add(new ArrayList());
                }
                for (IType iType : currentTypes) {
                    IType parameterizedType = TypeLord.findParameterizedType(iType, lub);
                    if (parameterizedType == null) {
                        System.out.println("*** ERROR: parameteredType is null");
                        System.out.println("*** initialType is " + iType);
                        System.out.println("*** lub is " + lub);
                        for (IType iType2 : currentTypes) {
                            System.out.println("*** currentTypes contains " + iType2);
                        }
                        for (IType iType3 : lubSet) {
                            System.out.println("*** lubSet contains " + iType3);
                        }
                    }
                    if (!parameterizedType.isParameterizedType()) {
                        parameterizedType = TypeLord.getDefaultParameterizedType(iType);
                    }
                    if (!parameterizedType.isParameterizedType()) continue;
                    for (int i = 0; i < parameterizedType.getTypeParameters().length; ++i) {
                        IType iType4 = parameterizedType.getTypeParameters()[i];
                        ((List)typeParametersByPosition.get(i)).add(iType4);
                    }
                }
                ArrayList<IType> paramLubs = new ArrayList<IType>();
                for (List paramterTypesAtPositionI : typeParametersByPosition) {
                    IType leastUpperBound = TypeLord.findLeastUpperBoundImpl(paramterTypesAtPositionI, resolvingTypes);
                    paramLubs.add(leastUpperBound);
                }
                IType iType = lub.getParameterizedType(paramLubs.toArray(new IType[paramLubs.size()]));
                returnSet.add(iType);
                continue;
            }
            returnSet.add(lub);
        }
        return returnSet;
    }

    private static void pruneNonLUBs(Set<IType> typeSet) {
        Iterator<IType> outerIterator = typeSet.iterator();
        block0: while (outerIterator.hasNext()) {
            IType typeToPossiblyRemove = outerIterator.next();
            for (IType otherType : typeSet) {
                if (!otherType.getAllTypesInHierarchy().contains(typeToPossiblyRemove) || typeToPossiblyRemove.getAllTypesInHierarchy().contains(otherType)) continue;
                outerIterator.remove();
                continue block0;
            }
        }
    }

    public static boolean isRecursiveType(IJavaType javaType) {
        return TypeLord.getDefaultParameterizedType((IType)javaType).isGenericType();
    }

    public static boolean isRecursiveType(ITypeVariableType subject, IType ... types) {
        return TypeLord._isRecursiveType(subject, new HashSet<IType>(), types);
    }

    private static boolean _isRecursiveType(ITypeVariableType subject, Set<IType> visited, IType ... types) {
        visited.add((IType)subject);
        for (IType csr : types) {
            for (IType subj : visited) {
                if (!TypeLord.getPureGenericType(csr).equals(TypeLord.getPureGenericType(subj))) continue;
                return true;
            }
            if (csr instanceof CompoundType) {
                Set compoundTypeComponents = csr.getCompoundTypeComponents();
                IType[] typesArr = compoundTypeComponents.toArray(new IType[compoundTypeComponents.size()]);
                if (!TypeLord._isRecursiveType(subject, visited, typesArr)) continue;
                return true;
            }
            if (csr.isParameterizedType()) {
                if (!TypeLord._isRecursiveType(subject, visited, csr.getTypeParameters())) continue;
                return true;
            }
            if (csr.isGenericType()) {
                for (IGenericTypeVariable gtv : csr.getGenericTypeVariables()) {
                    ITypeVariableDefinition tvd = gtv.getTypeVariableDefinition();
                    if (tvd == null || tvd.getType() == null || !TypeLord._isRecursiveType(subject, visited, new IType[]{tvd.getType()})) continue;
                    return true;
                }
                continue;
            }
            if (csr instanceof TypeVariableType) {
                if (!visited.contains(csr) && TypeLord._isRecursiveType((ITypeVariableType)csr, visited, ((TypeVariableType)csr).getBoundingType())) {
                    return true;
                }
                visited.remove(csr);
                if (!TypeLord._isRecursiveType(subject, visited, ((TypeVariableType)csr).getBoundingType())) continue;
                return true;
            }
            if (!csr.isArray() || !TypeLord._isRecursiveType(subject, visited, csr.getComponentType())) continue;
            return true;
        }
        return false;
    }

    public static IJavaClassInfo getOuterMostEnclosingClass(IJavaClassInfo innerClass) {
        IJavaClassInfo outerMost = innerClass;
        while (outerMost.getEnclosingType() != null) {
            outerMost = outerMost.getEnclosingClass();
        }
        return outerMost;
    }

    public static IType getOuterMostEnclosingClass(IType innerClass) {
        IType outerMost = innerClass;
        while (outerMost.getEnclosingType() != null && !TypeLord.isEvalProgram(outerMost)) {
            if (!TypeSystem.isDeleted((IType)(outerMost = outerMost.getEnclosingType()))) continue;
            return null;
        }
        return outerMost;
    }

    public static boolean isParameterizedType(IType type) {
        if (type.isParameterizedType()) {
            return true;
        }
        if (type instanceof CompoundType) {
            for (IType compType : type.getCompoundTypeComponents()) {
                if (!TypeLord.isParameterizedType(compType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEvalProgram(IType type) {
        return type instanceof IGosuProgram && ((IGosuProgram)type).isAnonymous();
    }

    public static void addReferencedTypeVarsThatAreNotInMap(IType type, TypeVarToTypeMap map) {
        if (type instanceof TypeVariableType) {
            IType existingType = map.get((ITypeVariableType)((TypeVariableType)type));
            if (existingType == null) {
                map.put((ITypeVariableType)type, type);
            }
        } else if (type.isParameterizedType()) {
            for (IType typeParam : type.getTypeParameters()) {
                TypeLord.addReferencedTypeVarsThatAreNotInMap(typeParam, map);
            }
        } else if (type.isArray()) {
            TypeLord.addReferencedTypeVarsThatAreNotInMap(type.getComponentType(), map);
        } else if (type instanceof IFunctionType) {
            IType[] types;
            IFunctionType funType = (IFunctionType)type;
            for (IType iType : types = funType.getParameterTypes()) {
                TypeLord.addReferencedTypeVarsThatAreNotInMap(iType, map);
            }
            TypeLord.addReferencedTypeVarsThatAreNotInMap(funType.getReturnType(), map);
        }
    }

    public static boolean hasTypeVariable(IType type) {
        return TypeLord.getTypeVariables(type, tv -> true);
    }

    public static List<ITypeVariableType> getTypeVariables(IType type) {
        ArrayList<ITypeVariableType> tvs = new ArrayList<ITypeVariableType>();
        TypeLord.getTypeVariables(type, tv -> {
            tvs.add((ITypeVariableType)tv);
            return false;
        });
        return tvs;
    }

    public static boolean getTypeVariables(IType type, Predicate<ITypeVariableType> cb) {
        boolean bRet;
        block2: {
            block6: {
                block5: {
                    block4: {
                        block3: {
                            bRet = false;
                            if (type != null) break block3;
                            bRet = false;
                            break block2;
                        }
                        if (!(type instanceof TypeVariableType)) break block4;
                        bRet = cb.test((ITypeVariableType)type);
                        break block2;
                    }
                    if (!(type instanceof TypeVariableArrayType)) break block5;
                    bRet = TypeLord.getTypeVariables(type.getComponentType(), cb);
                    break block2;
                }
                if (!(type instanceof CompoundType)) break block6;
                for (IType t : ((CompoundType)type).getTypes()) {
                    if (!TypeLord.getTypeVariables(t, cb)) continue;
                    bRet = true;
                    break block2;
                }
                break block2;
            }
            if (!type.isParameterizedType()) break block2;
            IType[] compileTimeTypeParams = type.getTypeParameters();
            for (int i = 0; i < compileTimeTypeParams.length; ++i) {
                IType ctTypeParam = compileTimeTypeParams[i];
                if (!TypeLord.getTypeVariables(ctTypeParam, cb)) continue;
                bRet = true;
                break;
            }
        }
        return bRet;
    }

    public static boolean isExpandable(IType type) {
        return TypeLord.getExpandableComponentType(type) != null;
    }

    public static IType getExpandableComponentType(IType type) {
        return TypeLord.getExpandableComponentType(type, true);
    }

    public static IType getExpandableComponentType(IType type, boolean bCore) {
        HashSet<IType> visited = new HashSet<IType>();
        do {
            if (!visited.add(type)) {
                return type;
            }
            if (type.isArray()) {
                type = type.getComponentType();
                continue;
            }
            if (JavaTypes.INTEGER_INTERVAL().isAssignableFrom(type)) {
                return JavaTypes.pINT();
            }
            if (JavaTypes.LONG_INTERVAL().isAssignableFrom(type)) {
                return JavaTypes.pLONG();
            }
            if (type instanceof IPlaceholder && ((IPlaceholder)type).isPlaceholder()) {
                return type.getComponentType();
            }
            IType parameterized = TypeLord.findParameterizedType(type, (IType)JavaTypes.ITERABLE());
            if (parameterized != null && parameterized.isParameterizedType()) {
                type = parameterized.getTypeParameters()[0];
                continue;
            }
            parameterized = TypeLord.findParameterizedType(type, (IType)JavaTypes.ITERATOR());
            if (parameterized != null && parameterized.isParameterizedType()) {
                type = parameterized.getTypeParameters()[0];
                continue;
            }
            return type;
        } while (bCore);
        return type;
    }

    public static void inferTypeVariableTypesFromGenParamTypeAndConcreteType(IType genParamType, IType argType, TypeVarToTypeMap inferenceMap) {
        TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genParamType, argType, inferenceMap, new HashSet<ITypeVariableType>(), false);
    }

    public static void inferTypeVariableTypesFromGenParamTypeAndConcreteType_Reverse(IType genParamType, IType argType, TypeVarToTypeMap inferenceMap) {
        TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genParamType, argType, inferenceMap, new HashSet<ITypeVariableType>(), true);
    }

    public static void inferTypeVariableTypesFromGenParamTypeAndConcreteType(IType genParamType, IType argType, TypeVarToTypeMap inferenceMap, HashSet<ITypeVariableType> inferredInCallStack, boolean bReverse) {
        block22: {
            block24: {
                IType boundingType;
                boolean pairReverse;
                block23: {
                    IType[] concreteTypeParams;
                    IType argTypeInTermsOfParamType;
                    block21: {
                        if (argType == GosuParserTypes.NULL_TYPE() || argType instanceof IErrorType || argType instanceof IMetaType && ((IMetaType)argType).getType() instanceof IErrorType) {
                            return;
                        }
                        if (argType.isPrimitive()) {
                            argType = TypeLord.getBoxedTypeFromPrimitiveType(argType);
                        }
                        if (!genParamType.isArray()) break block21;
                        if (!argType.isArray()) {
                            return;
                        }
                        if (argType.getComponentType() != null && argType.getComponentType().isPrimitive()) break block22;
                        TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genParamType.getComponentType(), argType.getComponentType(), inferenceMap, inferredInCallStack, bReverse);
                        break block22;
                    }
                    if (!genParamType.isParameterizedType()) break block23;
                    if (argType instanceof FunctionType) {
                        IFunctionType funcType = genParamType.getFunctionalInterface();
                        if (funcType != null) {
                            TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType((IType)funcType, argType, inferenceMap, inferredInCallStack, bReverse);
                            return;
                        }
                    } else if (genParamType instanceof IGosuClass && ((IGosuClass)genParamType).isStructure() && StandardCoercionManager.isStructurallyAssignable_Laxed((IType)genParamType, (IType)argType, (TypeVarToTypeMap)inferenceMap)) {
                        return;
                    }
                    IType iType = argTypeInTermsOfParamType = bReverse ? TypeLord.findParameterizedType_Reverse(argType, genParamType) : TypeLord.findParameterizedType(argType, genParamType.getGenericType());
                    if (argTypeInTermsOfParamType == null) {
                        IType iType2 = argTypeInTermsOfParamType = !bReverse ? TypeLord.findParameterizedType_Reverse(argType, genParamType) : TypeLord.findParameterizedType(argType, genParamType.getGenericType());
                        if (argTypeInTermsOfParamType == null) {
                            return;
                        }
                    }
                    if ((concreteTypeParams = argTypeInTermsOfParamType.getTypeParameters()) == null || concreteTypeParams.length <= 0) break block22;
                    int i = 0;
                    IType[] genTypeParams = genParamType.getTypeParameters();
                    if (concreteTypeParams.length >= genTypeParams.length) {
                        for (IType typeArg : genTypeParams) {
                            TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(typeArg, concreteTypeParams[i++], inferenceMap, inferredInCallStack, bReverse);
                        }
                    }
                    break block22;
                }
                if (!(genParamType instanceof ITypeVariableType) || argType == GosuParserTypes.NULL_TYPE()) break block24;
                ITypeVariableType tvType = ((ITypeVariableType)genParamType).getTypeVarDef().getType();
                Pair pair = inferenceMap.getPair(tvType);
                IType type = pair == null ? null : (IType)pair.getFirst();
                boolean bl = pairReverse = pair != null && (Boolean)pair.getSecond() != false;
                if (type == null || type instanceof ITypeVariableType) {
                    inferenceMap.put(tvType, TypeLord.getActualType(argType, inferenceMap, true), bReverse);
                    inferredInCallStack.add(tvType);
                    if (type != null && type.equals(argType)) {
                        return;
                    }
                } else if (type != null) {
                    IType combinedType = TypeLord.solveType(genParamType, argType, inferenceMap, bReverse || pairReverse, tvType, type);
                    inferenceMap.put(tvType, combinedType, bReverse);
                }
                if (TypeLord.isRecursiveType((ITypeVariableType)genParamType, boundingType = ((ITypeVariableType)genParamType).getBoundingType())) break block22;
                TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(boundingType, argType, inferenceMap, inferredInCallStack, bReverse);
                break block22;
            }
            if (genParamType instanceof FunctionType) {
                IType[] argTypeParamTypes;
                FunctionType genBlockType = (FunctionType)genParamType;
                if (!(argType instanceof FunctionType)) {
                    if (argType.isParameterizedType()) {
                        argType = argType.getFunctionalInterface();
                    }
                    if (!(argType instanceof FunctionType)) {
                        return;
                    }
                }
                TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genBlockType.getReturnType(), ((FunctionType)argType).getReturnType(), inferenceMap, inferredInCallStack, bReverse);
                IType[] genBlockParamTypes = genBlockType.getParameterTypes();
                if (genBlockParamTypes != null && (argTypeParamTypes = ((FunctionType)argType).getParameterTypes()).length == genBlockParamTypes.length) {
                    for (int i = 0; i < genBlockParamTypes.length; ++i) {
                        TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genBlockParamTypes[i], ((FunctionType)argType).getParameterTypes()[i], inferenceMap, inferredInCallStack, true);
                    }
                }
            }
        }
    }

    private static IType solveType(IType genParamType, IType argType, TypeVarToTypeMap inferenceMap, boolean bReverse, ITypeVariableType tvType, IType type) {
        IType lubType;
        if (bReverse) {
            lubType = TypeLord.findGreatestLowerBound(type, argType);
        } else {
            lubType = inferenceMap.isInferredForCovariance(tvType) ? (argType.equals(genParamType) ? type : TypeLord.findLeastUpperBound(Arrays.asList(type, argType))) : TypeLord.findGreatestLowerBound(type, argType);
            inferenceMap.setInferredForCovariance(tvType);
        }
        return lubType;
    }

    public static IType getConcreteType(IType type) {
        if (type.isGenericType() && !type.isParameterizedType()) {
            IGenericTypeVariable[] genTypeVars = type.getGenericTypeVariables();
            IType[] typeVarTypes = new IType[genTypeVars.length];
            for (int i = 0; i < typeVarTypes.length; ++i) {
                typeVarTypes[i] = genTypeVars[i].getTypeVariableDefinition().getType();
            }
            type = type.getParameterizedType(typeVarTypes);
        }
        return type;
    }

    public static IType getCoreType(IType type) {
        if (TypeSystem.isDeleted((IType)type)) {
            return null;
        }
        if (type.isArray()) {
            return TypeLord.getCoreType(type.getComponentType());
        }
        return type;
    }

    public static IType getBoxedTypeFromPrimitiveType(IType primitiveType) {
        IJavaType boxedType;
        if (primitiveType == JavaTypes.pBOOLEAN()) {
            boxedType = JavaTypes.BOOLEAN();
        } else if (primitiveType == JavaTypes.pBYTE()) {
            boxedType = JavaTypes.BYTE();
        } else if (primitiveType == JavaTypes.pCHAR()) {
            boxedType = JavaTypes.CHARACTER();
        } else if (primitiveType == JavaTypes.pSHORT()) {
            boxedType = JavaTypes.SHORT();
        } else if (primitiveType == JavaTypes.pINT()) {
            boxedType = JavaTypes.INTEGER();
        } else if (primitiveType == JavaTypes.pLONG()) {
            boxedType = JavaTypes.LONG();
        } else if (primitiveType == JavaTypes.pFLOAT()) {
            boxedType = JavaTypes.FLOAT();
        } else if (primitiveType == JavaTypes.pDOUBLE()) {
            boxedType = JavaTypes.DOUBLE();
        } else if (primitiveType == JavaTypes.pVOID()) {
            boxedType = JavaTypes.VOID();
        } else {
            throw new IllegalArgumentException("Unhandled type " + primitiveType);
        }
        return boxedType;
    }

    public static IType boundTypes(IType type, List<IType> typesToBound) {
        return TypeLord.boundTypes(type, typesToBound, false);
    }

    public static IType boundTypes(IType type, List<IType> typesToBound, boolean bKeepTypeVars) {
        IType inferringType;
        if (type == null) {
            return null;
        }
        if (type instanceof ITypeVariableType && (inferringType = TypeLord.inferringType(type, typesToBound, bKeepTypeVars)) != null) {
            IType boundType = bKeepTypeVars ? inferringType : (TypeLord.isRecursiveType((ITypeVariableType)type, ((ITypeVariableType)type).getBoundingType()) && !(((ITypeVariableType)type).getBoundingType() instanceof ITypeVariableType) ? TypeLord.getPureGenericType(((ITypeVariableType)type).getBoundingType()) : TypeLord.boundTypes(((ITypeVariableType)type).getBoundingType(), typesToBound, bKeepTypeVars));
            typesToBound.add(inferringType);
            return boundType;
        }
        if (type instanceof ITypeVariableArrayType) {
            IType componentType = type.getComponentType();
            return TypeLord.boundTypes(componentType, typesToBound, bKeepTypeVars).getArrayType();
        }
        if (type.isParameterizedType()) {
            IType[] typeParameters = type.getTypeParameters();
            IType[] parameters = new IType[typeParameters.length];
            System.arraycopy(typeParameters, 0, parameters, 0, typeParameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = TypeLord.boundTypes(parameters[i], typesToBound, bKeepTypeVars);
            }
            return type.getGenericType().getParameterizedType(parameters);
        }
        if (type instanceof IFunctionType) {
            IFunctionType funType = (IFunctionType)type;
            IType[] parameterTypes = funType.getParameterTypes();
            IType[] paramTypes = new IType[parameterTypes.length];
            System.arraycopy(parameterTypes, 0, paramTypes, 0, paramTypes.length);
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = TypeLord.boundTypes(paramTypes[i], typesToBound, bKeepTypeVars);
            }
            IType returnType = TypeLord.boundTypes(funType.getReturnType(), typesToBound, bKeepTypeVars);
            return funType.newInstance(paramTypes, returnType);
        }
        return type;
    }

    private static IType inferringType(IType type, List<IType> currentlyInferringTypes, boolean bKeepTypeVars) {
        if (type instanceof TypeVariableType) {
            TypeVariableType typeVarType = (TypeVariableType)type;
            for (IType currentlyInferringType : currentlyInferringTypes) {
                TypeVariableType inferringTypeVarType = (TypeVariableType)currentlyInferringType;
                if (!TypeLord.areTypeVariablesEquivalent(typeVarType, inferringTypeVarType)) continue;
                if (!bKeepTypeVars) {
                    currentlyInferringTypes.remove((Object)inferringTypeVarType);
                }
                return inferringTypeVarType;
            }
        }
        return null;
    }

    private static boolean areTypeVariablesEquivalent(TypeVariableType possible, TypeVariableType inferred) {
        boolean match = false;
        if (GosuObjectUtil.equals((Object)possible.getName(), (Object)inferred.getName())) {
            IType enclosingType1 = possible.getEnclosingType();
            IType enclosingType2 = inferred.getEnclosingType();
            if (enclosingType1 instanceof IFunctionType && enclosingType2 instanceof IFunctionType) {
                String typeName2;
                IFunctionType funType1 = (IFunctionType)enclosingType1;
                IFunctionType funType2 = (IFunctionType)enclosingType2;
                IScriptPartId id1 = funType1.getScriptPart();
                IScriptPartId id2 = funType2.getScriptPart();
                String typeName1 = id1 == null ? null : id1.getContainingTypeName();
                String string = typeName2 = id2 == null ? null : id2.getContainingTypeName();
                if (GosuObjectUtil.equals((Object)typeName1, (Object)typeName2) && GosuObjectUtil.equals((Object)funType1.getParamSignature(), (Object)funType2.getParamSignature())) {
                    match = true;
                }
            } else if (!(enclosingType1 instanceof IFunctionType) && !(enclosingType2 instanceof IFunctionType)) {
                match = enclosingType1 == enclosingType2;
            }
        }
        return match;
    }

    public static IType getTopLevelType(IType type) {
        IType topType = TypeLord.getCoreType(type);
        topType = TypeLord.getPureGenericType(topType);
        topType = TypeLord.getOuterMostEnclosingClass(topType);
        return topType;
    }
}

