/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.compiler;

import com.sun.tools.javac.file.JavacFileManager;
import gw.internal.gosu.parser.java.compiler.GeneratedJavaStubFileObject;
import gw.internal.gosu.parser.java.compiler.JavaStubGenerator;
import gw.lang.ir.SignatureUtil;
import gw.lang.javac.ClassJavaFileObject;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.module.IModule;
import gw.util.cache.FqnCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class GosuJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager>
implements ITypeLoaderListener {
    private FqnCache<ClassJavaFileObject> _classFiles;
    private JavacFileManager _javacMgr;

    GosuJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
        this._javacMgr = (JavacFileManager)fileManager;
        this._classFiles = new FqnCache();
        TypeSystem.addTypeLoaderListenerAsWeakRef((ITypeLoaderListener)this);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        ClassJavaFileObject file = new ClassJavaFileObject(className, kind);
        this._classFiles.add(className, (Object)file);
        className = className.replace('$', '.');
        this._classFiles.add(className, (Object)file);
        return file;
    }

    public ClassJavaFileObject findCompiledFile(String fqn) {
        return (ClassJavaFileObject)this._classFiles.get(fqn);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> list = super.list(location, packageName, kinds, recurse);
        if (kinds.contains((Object)JavaFileObject.Kind.SOURCE) && location == StandardLocation.SOURCE_PATH) {
            INamespaceType namespace = TypeSystem.getNamespace((String)packageName);
            if (namespace == null) {
                return list;
            }
            ArrayList<JavaFileObject> newList = new ArrayList<JavaFileObject>();
            list.forEach(newList::add);
            Set<String> names = this.makeNames(list);
            Set children = namespace.getChildren((IType)namespace);
            for (TypeName tn : children) {
                if (names.contains(SignatureUtil.getSimpleName((String)tn.name))) continue;
                if (tn.kind == TypeName.Kind.NAMESPACE) {
                    if (!recurse) continue;
                    Iterable<JavaFileObject> sublist = this.list(location, tn.name, kinds, recurse);
                    sublist.forEach(newList::add);
                    continue;
                }
                IType type = TypeSystem.getByFullNameIfValid((String)tn.name.replace('$', '.'), (IModule)tn.getModule());
                if (!(type instanceof IGosuClass) || IGosuClass.ProxyUtil.isProxy((IType)type)) continue;
                newList.add(this.makeJavaStub((IGosuClass)type));
            }
            list = newList;
        }
        return list;
    }

    private Set<String> makeNames(Iterable<JavaFileObject> list) {
        HashSet<String> set = new HashSet<String>();
        for (JavaFileObject file : list) {
            String name = file.getName();
            if (!name.endsWith(".java")) continue;
            set.add(name.substring(name.lastIndexOf(File.separatorChar) + 1, name.lastIndexOf(46)));
        }
        return set;
    }

    private JavaFileObject makeJavaStub(IGosuClass gsClass) {
        return new GeneratedJavaStubFileObject(this._javacMgr, gsClass.getName(), () -> JavaStubGenerator.instance().genStub(gsClass));
    }

    public void remove(String fqn) {
        this._classFiles.remove(fqn);
    }

    public void refreshedTypes(RefreshRequest request) {
        switch (request.kind) {
            case MODIFICATION: 
            case DELETION: {
                this._classFiles.remove(request.types);
            }
        }
    }

    public void refreshed() {
        this._classFiles = new FqnCache();
    }

    public Collection<ClassJavaFileObject> getCompiledFiles() {
        HashSet<ClassJavaFileObject> files = new HashSet<ClassJavaFileObject>();
        this._classFiles.visitDepthFirst(o -> {
            if (o != null) {
                files.add((ClassJavaFileObject)o);
            }
            return true;
        });
        return files;
    }
}

