/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.Statement;
import gw.lang.parser.IExpression;
import gw.lang.parser.IStatement;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.IUsingStatement;
import java.util.Collections;
import java.util.List;

public final class UsingStatement
extends Statement
implements IUsingStatement {
    private Expression _expression;
    private List<IVarStatement> _varStmts = Collections.emptyList();
    private Statement _statement;
    private Statement _finallyStatement;

    public Expression getExpression() {
        return this._expression;
    }

    public void setExpression(IExpression expression) {
        this._expression = (Expression)expression;
    }

    public Statement getStatement() {
        return this._statement;
    }

    public void setStatement(IStatement statement) {
        this._statement = (Statement)statement;
    }

    public List<IVarStatement> getVarStatements() {
        return this._varStmts;
    }

    public boolean hasVarStatements() {
        return this._varStmts != null && !this._varStmts.isEmpty();
    }

    public void setVarStatements(List<IVarStatement> varStmts) {
        this._varStmts = varStmts;
    }

    public Statement getFinallyStatement() {
        return this._finallyStatement;
    }

    public void setFinallyStatement(Statement finallyStatement) {
        this._finallyStatement = finallyStatement;
    }

    @Override
    public Object execute() {
        if (!this.isCompileTimeConstant()) {
            return super.execute();
        }
        throw new IllegalStateException("Can't execute this parsed element directly");
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        bAbsolute[0] = false;
        return this.getStatement() == null ? null : this.getStatement().getLeastSignificantTerminalStatement(bAbsolute);
    }

    @Override
    public String toString() {
        return "using( " + (this.getExpression() == null ? this.varStatementsToString() : this.getExpression().toString()) + " )\n" + this.getStatement() == null ? "" : this.getStatement().toString() + (this.getFinallyStatement() == null ? "" : "\nfinally\n" + this.getFinallyStatement().toString());
    }

    private String varStatementsToString() {
        String s = "";
        for (IVarStatement varStmt : this.getVarStatements()) {
            if (s.length() == 0) {
                s = s + varStmt.toString();
                continue;
            }
            s = s + ", ";
        }
        return s;
    }
}

