/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.annotations;

import gw.lang.annotation.Annotations;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationMap {
    private Map<String, List> _annotationsByFeatureName = new HashMap<String, List>();
    private List _currentAnnotationList;
    private Annotations.Builder _currentJavaAnnotationBuilder;
    private IJavaType _currentJavaType;

    public AnnotationMap startAnnotationInfoForFeature(String featureId) {
        this._currentAnnotationList = new ArrayList();
        this._annotationsByFeatureName.put(featureId, this._currentAnnotationList);
        return this;
    }

    public AnnotationMap startJavaAnnotation(IType type) {
        this._currentJavaType = (IJavaType)type;
        Class annotationClass = this._currentJavaType.getBackingClass();
        this._currentJavaAnnotationBuilder = Annotations.builder((Class)annotationClass);
        return this;
    }

    public AnnotationMap withArg(String name, Object arg) {
        this._currentJavaAnnotationBuilder.withElement(name, arg);
        return this;
    }

    public AnnotationMap finishJavaAnnotation() {
        Annotation annotation = this._currentJavaAnnotationBuilder.create();
        this._currentAnnotationList.add(annotation);
        return this;
    }

    public AnnotationMap addGosuAnnotation(Object annotation) {
        this._currentAnnotationList.add(annotation);
        return this;
    }

    public Map<String, List> getAnnotations() {
        return Collections.unmodifiableMap(this._annotationsByFeatureName);
    }
}

