/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.dynamic;

import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.Expando;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorHandler;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IExpando;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.SimpleParameterInfo;
import java.util.Collections;
import java.util.List;

public class DynamicConstructorInfo
extends BaseFeatureInfo
implements IConstructorInfo {
    private IParameterInfo[] _paramInfos;

    public DynamicConstructorInfo(ITypeInfo dynamicTypeInfo, IType ... paramTypes) {
        super((IFeatureInfo)dynamicTypeInfo);
        this.makeParameters(paramTypes);
    }

    private void makeParameters(IType[] paramTypes) {
        this._paramInfos = new IParameterInfo[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            this._paramInfos[i] = new SimpleParameterInfo((IFeatureInfo)this, paramTypes[i], i);
        }
    }

    public boolean isStatic() {
        return false;
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    public String getName() {
        return "Dynamic()";
    }

    public IType getType() {
        return this.getOwnersType();
    }

    public IParameterInfo[] getParameters() {
        return this._paramInfos;
    }

    public IConstructorHandler getConstructor() {
        return new ConstructorHandler();
    }

    public List<IExceptionInfo> getExceptions() {
        return Collections.emptyList();
    }

    public boolean isDefault() {
        return true;
    }

    private class ConstructorHandler
    implements IConstructorHandler {
        private ConstructorHandler() {
        }

        public Object newInstance(Object ... args) {
            if (args == null || args.length == 0) {
                return new Expando();
            }
            if (args.length == 1 && args[0] instanceof IExpando) {
                return args[0];
            }
            throw new IllegalArgumentException();
        }
    }
}

