/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.statement;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRCaseClause;
import gw.lang.ir.statement.IRSwitchStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class IRSwitchStatementCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRSwitchStatement statement, IRBytecodeContext context) {
        if (statement.areLabelsConstant()) {
            IRSwitchStatementCompiler.compileWithTableSwitch(statement, context);
            return;
        }
        MethodVisitor mv = context.getMv();
        context.compile((IRElement)statement.getInit());
        Label endSwitchLabel = new Label();
        int iCaseMatchedIndex = context.makeTempVar(IRTypeConstants.pBOOLEAN()).getIndex();
        mv.visitInsn(3);
        mv.visitVarInsn(54, iCaseMatchedIndex);
        ArrayList<Label> caseBodyLabels = new ArrayList<Label>();
        List cases = statement.getCases();
        for (IRCaseClause caseClause : cases) {
            Label caseBodyLabel = new Label();
            caseBodyLabels.add(caseBodyLabel);
            context.compile((IRElement)caseClause.getCondition());
            mv.visitJumpInsn(154, caseBodyLabel);
        }
        Label defaultLabel = new Label();
        mv.visitJumpInsn(167, defaultLabel);
        for (int i = 0; i < cases.size(); ++i) {
            IRCaseClause caseClause = (IRCaseClause)cases.get(i);
            Label caseBodyLabel = (Label)caseBodyLabels.get(i);
            context.visitLabel(caseBodyLabel);
            IRSwitchStatementCompiler.compileCaseBody(endSwitchLabel, caseClause.getStatements(), context);
        }
        context.visitLabel(defaultLabel);
        IRSwitchStatementCompiler.compileCaseBody(endSwitchLabel, statement.getDefaultStatements(), context);
        context.visitLabel(endSwitchLabel);
    }

    private static ConstantCase[] generateConstantCases(IRSwitchStatement switchStmt) {
        List caseClauses = switchStmt.getCases();
        ConstantCase[] cases = new ConstantCase[caseClauses.size()];
        for (int i = 0; i < caseClauses.size(); ++i) {
            cases[i] = new ConstantCase();
            cases[i].label = i > 0 && ((IRCaseClause)caseClauses.get(i - 1)).getStatements().size() == 0 ? cases[i - 1].label : new Label();
            cases[i].value = ((IRCaseClause)caseClauses.get(i)).getConstValue();
            cases[i].body = ((IRCaseClause)caseClauses.get(i)).getStatements();
        }
        return cases;
    }

    private static void compileWithTableSwitch(IRSwitchStatement switchStmt, IRBytecodeContext context) {
        MethodVisitor mv = context.getMv();
        Label defaultL = new Label();
        Label endSwitch = new Label();
        ConstantCase[] cases = IRSwitchStatementCompiler.generateConstantCases(switchStmt);
        Object[] sortedCases = Arrays.copyOf(cases, cases.length);
        Arrays.sort(sortedCases);
        IRStatement init = switchStmt.getInit();
        context.compile((IRElement)init);
        context.compile((IRElement)new IRIdentifier(((IRAssignmentStatement)init).getSymbol()));
        mv.visitTableSwitchInsn(((ConstantCase)sortedCases[0]).value, ((ConstantCase)sortedCases[cases.length - 1]).value, defaultL, IRSwitchStatementCompiler.collectLabels(defaultL, (ConstantCase[])sortedCases));
        IRSwitchStatementCompiler.emitCaseBodies(endSwitch, cases, context);
        context.visitLabel(defaultL);
        List defaultStmts = switchStmt.getDefaultStatements();
        if (defaultStmts.size() != 0) {
            IRSwitchStatementCompiler.compileCaseBody(endSwitch, defaultStmts, context);
        }
        context.visitLabel(endSwitch);
    }

    private static void emitCaseBodies(Label endSwitch, ConstantCase[] cases, IRBytecodeContext context) {
        HashSet<Label> visited = new HashSet<Label>();
        for (int i = 0; i < cases.length; ++i) {
            if (!visited.contains(cases[i].label)) {
                context.visitLabel(cases[i].label);
                visited.add(cases[i].label);
            }
            if (cases[i].body.size() == 0) continue;
            IRSwitchStatementCompiler.compileCaseBody(endSwitch, cases[i].body, context);
        }
    }

    private static Label[] collectLabels(Label defaultL, ConstantCase[] cases) {
        int min = cases[0].value;
        int max = cases[cases.length - 1].value;
        Label[] all = new Label[max - min + 1];
        int i = 0;
        int lastMin = cases[0].value;
        for (int j = 0; j < cases.length; ++j) {
            while (lastMin < cases[j].value) {
                all[i] = defaultL;
                ++i;
                ++lastMin;
            }
            all[i] = cases[j].label;
            ++i;
            ++lastMin;
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compileCaseBody(Label endSwitchLabel, List<IRStatement> statements, IRBytecodeContext context) {
        context.pushBreakLabel(endSwitchLabel);
        context.pushScope();
        try {
            for (IRStatement caseStatement : statements) {
                context.compile((IRElement)caseStatement);
            }
        }
        finally {
            context.popScope();
            context.popBreakLabel();
        }
    }

    private static final class ConstantCase
    implements Comparable<ConstantCase> {
        int value;
        Label label;
        List<IRStatement> body;

        private ConstantCase() {
        }

        @Override
        public int compareTo(ConstantCase o) {
            return Integer.compare(this.value, o.value);
        }
    }
}

