/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.NewExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.TypeLiteralTransformer;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.expressions.DefaultArgLiteral;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.expression.IRFieldGetExpression;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;

public class DefaultArgLiteralTransformer
extends AbstractExpressionTransformer<DefaultArgLiteral> {
    public static IRExpression compile(TopLevelTransformationContext cc, DefaultArgLiteral expr) {
        DefaultArgLiteralTransformer gen = new DefaultArgLiteralTransformer(cc, expr);
        return gen.compile();
    }

    private DefaultArgLiteralTransformer(TopLevelTransformationContext cc, DefaultArgLiteral expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IRExpression expression;
        Object value = ((DefaultArgLiteral)this._expr()).getValue();
        IType type = ((DefaultArgLiteral)this._expr()).getType();
        if (value == null) {
            expression = this.pushNull();
        } else if (type.isEnum()) {
            expression = new IRFieldGetExpression(null, (String)value, DefaultArgLiteralTransformer.getDescriptor(type), DefaultArgLiteralTransformer.getDescriptor(type));
        } else if (value.getClass().isArray()) {
            expression = NewExpressionTransformer.compile(this._cc(), (NewExpression)((DefaultArgLiteral)this._expr()).getExpression());
        } else if (MetaType.class.isAssignableFrom(type.getClass())) {
            expression = TypeLiteralTransformer.compile(this._cc(), (TypeLiteral)((DefaultArgLiteral)this._expr()).getExpression());
        } else {
            expression = this.pushConstant(value);
            if (!type.isPrimitive()) {
                IType primType = TypeSystem.getPrimitiveType((IType)type);
                if (primType != null && StandardCoercionManager.isBoxed((IType)type)) {
                    expression = this.boxValue(primType, expression);
                } else {
                    if (type == JavaTypes.BIG_DECIMAL()) {
                        IRType bd = DefaultArgLiteralTransformer.getDescriptor(BigDecimal.class);
                        if (BigDecimal.ZERO.compareTo(new BigDecimal((String)value)) == 0) {
                            return this.buildFieldGet(bd, "ZERO", bd, null);
                        }
                        return this.buildNewExpression(bd, Collections.singletonList(IRTypeConstants.STRING()), Collections.singletonList(this.pushConstant(value)));
                    }
                    if (type == JavaTypes.BIG_INTEGER()) {
                        IRType bd = DefaultArgLiteralTransformer.getDescriptor(BigInteger.class);
                        if (BigInteger.ZERO.compareTo(new BigInteger((String)value)) == 0) {
                            return this.buildFieldGet(bd, "ZERO", bd, null);
                        }
                        return this.buildNewExpression(bd, Collections.singletonList(IRTypeConstants.STRING()), Collections.singletonList(this.pushConstant(value)));
                    }
                }
            }
        }
        return expression;
    }
}

