/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.module;

import gw.config.CommonServices;
import gw.config.Registry;
import gw.config.TypeLoaderSpec;
import gw.fs.IDirectory;
import gw.internal.gosu.module.Module;
import gw.internal.gosu.parser.FileSystemGosuClassRepository;
import gw.internal.gosu.parser.ModuleTypeLoader;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IFileSystemGosuClassRepository;
import gw.lang.reflect.gs.IGosuClassRepository;
import gw.lang.reflect.module.Dependency;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IGlobalModule;
import gw.lang.reflect.module.IModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlobalModule
extends Module
implements IGlobalModule {
    public GlobalModule(IExecutionEnvironment execEnv, String moduleName) {
        super(execEnv, moduleName);
    }

    @Override
    protected void createExtensionTypeLoaders() {
    }

    @Override
    protected void createStandardTypeLoaders() {
        FileSystemGosuClassRepository repository = new FileSystemGosuClassRepository(this);
        CommonServices.getTypeSystem().pushTypeLoader((IModule)this, (ITypeLoader)new GosuClassTypeLoader((IModule)this, (IGosuClassRepository)repository));
        this.createGlobalTypeloaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGlobalTypeloaders() {
        ModuleTypeLoader _moduleTypeLoader = this.getModuleTypeLoader();
        List globalLoaderTypes = CommonServices.getGlobalLoaderProvider().getGlobalLoaderTypes();
        if (globalLoaderTypes != null) {
            Collections.reverse(globalLoaderTypes);
        }
        FileSystemGosuClassRepository classRepository = new FileSystemGosuClassRepository(this);
        classRepository.setSourcePath(this.getAllSourcePaths());
        TypeSystem.pushModule((IModule)this);
        try {
            if (globalLoaderTypes != null) {
                for (Object globalLoader : globalLoaderTypes) {
                    try {
                        ITypeLoader typeLoader = GlobalModule.createTypeLoader(classRepository, this, (Class)globalLoader);
                        if (typeLoader != null) {
                            _moduleTypeLoader.pushTypeLoader(typeLoader);
                            continue;
                        }
                        throw new NullPointerException();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Cannot create type loader: " + globalLoader, t);
                    }
                }
            }
            List typeLoaderList = Registry.instance().getAdditionalTypeLoaders();
            for (TypeLoaderSpec typeLoaderSpec : typeLoaderList) {
                ITypeLoader typeLoader = typeLoaderSpec.createTypeLoader(this.getExecutionEnvironment());
                if (typeLoader == null) continue;
                _moduleTypeLoader.pushTypeLoader(typeLoader);
            }
            List<ITypeLoader> loaders = _moduleTypeLoader.getTypeLoaders();
            for (int i = loaders.size() - 1; i >= 0; --i) {
                loaders.get(i).init();
            }
            CommonServices.getGosuInitializationHooks().afterTypeLoaderCreation();
        }
        finally {
            TypeSystem.popModule((IModule)this);
        }
    }

    private IDirectory[] getAllSourcePaths() {
        ArrayList srcs = new ArrayList();
        for (IModule m : this.getModuleTraversalList()) {
            srcs.addAll(m.getSourcePath());
        }
        return srcs.toArray(new IDirectory[srcs.size()]);
    }

    @Override
    protected void traverse(IModule theModule, List<IModule> traversalList) {
        traversalList.add(theModule);
        for (Dependency dependency : theModule.getDependencies()) {
            IModule dependencyModule = dependency.getModule();
            if (traversalList.contains(dependencyModule)) continue;
            this.traverse(dependencyModule, traversalList);
        }
    }

    protected static ITypeLoader createTypeLoader(IFileSystemGosuClassRepository classRepository, IModule module, Class loaderClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        CommonServices.getGosuInitializationHooks().beforeTypeLoaderCreation(loaderClass);
        Constructor<?>[] constructors = loaderClass.getConstructors();
        ITypeLoader typeLoader = null;
        for (Constructor<?> cons : constructors) {
            Class<?>[] parameterTypes = cons.getParameterTypes();
            if (parameterTypes.length == 0) {
                typeLoader = (ITypeLoader)cons.newInstance(new Object[0]);
                continue;
            }
            if (parameterTypes.length == 1 && parameterTypes[0] == IModule.class) {
                typeLoader = (ITypeLoader)cons.newInstance(module);
                continue;
            }
            if (cons.getParameterTypes().length != 1 || cons.getParameterTypes()[0] != IGosuClassRepository.class) continue;
            typeLoader = (ITypeLoader)cons.newInstance(classRepository);
        }
        return typeLoader;
    }
}

