/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.ConstructorJavaClassConstructor;
import gw.internal.gosu.parser.JavaBaseFeatureInfo;
import gw.internal.gosu.parser.JavaTypeInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.lang.GosuShop;
import gw.lang.javadoc.IClassDocNode;
import gw.lang.javadoc.IConstructorNode;
import gw.lang.javadoc.IDocRef;
import gw.lang.javadoc.IExceptionNode;
import gw.lang.javadoc.IParamNode;
import gw.lang.parser.IExpression;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorHandler;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ILocationInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassBytecodeConstructor;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaConstructorInfo;
import gw.lang.reflect.java.JavaExceptionInfo;
import gw.lang.reflect.java.JavaSourceElement;
import gw.util.GosuExceptionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class JavaConstructorInfo
extends JavaBaseFeatureInfo
implements IJavaConstructorInfo {
    private IJavaClassConstructor _ctor;
    private IParameterInfo[] _params;
    private IConstructorHandler _ctorHandler;
    private List<IExceptionInfo> _exceptions;
    private IDocRef<IConstructorNode> _docs = new IDocRef<IConstructorNode>(){

        public IConstructorNode get() {
            IClassDocNode classDocs = (IClassDocNode)((JavaTypeInfo)JavaConstructorInfo.this.getContainer()).getDocNode().get();
            return classDocs == null ? null : classDocs.getConstructor(JavaConstructorInfo.this._ctor);
        }
    };

    public JavaConstructorInfo(IFeatureInfo container, IJavaClassConstructor ctor) {
        super(container);
        this._ctor = ctor;
        if (this._ctor instanceof ConstructorJavaClassConstructor) {
            ((ConstructorJavaClassConstructor)this._ctor).setAccessible(true);
        }
    }

    public IJavaClassConstructor getJavaConstructor() {
        return this._ctor;
    }

    public Constructor getRawConstructor() {
        return ((ConstructorJavaClassConstructor)this._ctor).getJavaConstructor();
    }

    public boolean hasRawConstructor(IConstructorInfo rawCtor) {
        return rawCtor instanceof JavaConstructorInfo && ((JavaConstructorInfo)rawCtor).getJavaConstructor() == this.getJavaConstructor();
    }

    public boolean isDefault() {
        return this._ctor.isDefault();
    }

    public IType getType() {
        return this.getOwnersType();
    }

    public IParameterInfo[] getParameters() {
        if (this._params != null) {
            return this._params;
        }
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(this.getOwnersType(), this.getType());
        IParameterInfo[] params = this._ctor.convertGenericParameterTypes((IFeatureInfo)this, actualParamByVarName);
        this._params = params;
        return params;
    }

    public IConstructorHandler getConstructor() {
        if (this._ctorHandler == null) {
            this._ctorHandler = new ConstructorHandlerAdapter();
        }
        return this._ctorHandler;
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        List<IAnnotationInfo> annotations = super.getDeclaredAnnotations();
        if (this.getConstructorDocs().get() != null && ((IConstructorNode)this.getConstructorDocs().get()).isDeprecated()) {
            annotations.add(GosuShop.getAnnotationInfoFactory().createJavaAnnotation((Annotation)this.makeDeprecated(((IConstructorNode)this.getConstructorDocs().get()).getDeprecated()), (IFeatureInfo)this));
        }
        return annotations;
    }

    private IDocRef<IConstructorNode> getConstructorDocs() {
        return this._docs;
    }

    public List<IExceptionInfo> getExceptions() {
        if (this._exceptions == null) {
            IJavaClassInfo[] classes = this._ctor.getExceptionTypes();
            this._exceptions = new ArrayList<IExceptionInfo>();
            for (final IJavaClassInfo exceptionClass : classes) {
                this._exceptions.add((IExceptionInfo)new JavaExceptionInfo((IFeatureInfo)this, exceptionClass, (IDocRef)new IDocRef<IExceptionNode>(){

                    public IExceptionNode get() {
                        return JavaConstructorInfo.this.getConstructorDocs().get() == null ? null : ((IConstructorNode)JavaConstructorInfo.this.getConstructorDocs().get()).getException(exceptionClass);
                    }
                }));
            }
        }
        return this._exceptions;
    }

    public String getName() {
        return this.makeSignature();
    }

    private String makeSignature() {
        String name = this.getDisplayName();
        name = name + "(";
        IParameterInfo[] parameterInfos = this.getParameters();
        if (parameterInfos.length > 0) {
            name = name + " ";
            for (int i = 0; i < parameterInfos.length; ++i) {
                IParameterInfo iParameterInfo = this.getParameters()[i];
                if (i != 0) {
                    name = name + ", ";
                }
                name = name + iParameterInfo.getFeatureType().getName();
            }
            name = name + " ";
        }
        name = name + ")";
        return name;
    }

    public String getDisplayName() {
        return this.getOwnersType().getRelativeName();
    }

    public String getShortDescription() {
        return this.getConstructorDocs().get() != null ? ((IConstructorNode)this.getConstructorDocs().get()).getDescription() : null;
    }

    public String getDescription() {
        return this.getConstructorDocs().get() != null ? ((IConstructorNode)this.getConstructorDocs().get()).getDescription() : null;
    }

    public boolean isStatic() {
        return true;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this._ctor.getModifiers());
    }

    public boolean isInternal() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public boolean isProtected() {
        return Modifier.isProtected(this._ctor.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this._ctor.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._ctor.getModifiers());
    }

    public IDocRef<IParamNode> getDocsForParam(final int paramIndex) {
        return new IDocRef<IParamNode>(){

            public IParamNode get() {
                return JavaConstructorInfo.this.getConstructorDocs().get() == null ? null : (IParamNode)((IConstructorNode)JavaConstructorInfo.this.getConstructorDocs().get()).getParams().get(paramIndex);
            }
        };
    }

    public boolean isFinal() {
        return Modifier.isFinal(this._ctor.getModifiers());
    }

    public boolean isSynthetic() {
        return this._ctor instanceof IJavaClassBytecodeConstructor && ((IJavaClassBytecodeConstructor)this._ctor).isSynthetic();
    }

    private boolean isVarArgs() {
        return (this.getJavaConstructor().getModifiers() & 0x80) != 0;
    }

    public IExpression[] getDefaultValueExpressions() {
        IParameterInfo[] parameters = this.getParameters();
        IExpression[] defaults = new IExpression[parameters.length];
        if (!this.isVarArgs()) {
            return defaults;
        }
        NewExpression expr = new NewExpression();
        IType type = parameters[parameters.length - 1].getFeatureType();
        type = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(type);
        expr.setType(type);
        defaults[parameters.length - 1] = expr;
        return defaults;
    }

    public String[] getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IParameterInfo pi : this.getParameters()) {
            names.add(pi.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    protected IJavaAnnotatedElement getAnnotatedElement() {
        return this._ctor;
    }

    @Override
    protected boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return true;
    }

    @Override
    protected boolean isHiddenViaFeatureDescriptor() {
        return false;
    }

    @Override
    protected boolean isDefaultEnumFeature() {
        return true;
    }

    public ILocationInfo getLocationInfo() {
        if (this.getJavaConstructor() instanceof JavaSourceElement) {
            return this.getJavaConstructor().getLocationInfo();
        }
        return super.getLocationInfo();
    }

    private final class ConstructorHandlerAdapter
    implements IConstructorHandler {
        private ConstructorHandlerAdapter() {
        }

        public Object newInstance(Object ... args) {
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            if (TypeSystem.getCurrentModule() != null) {
                Thread.currentThread().setContextClassLoader(TypeSystem.getGosuClassLoader().getActualLoader());
            }
            try {
                if (args == null || args.length == 0) {
                    Object object = JavaConstructorInfo.this._ctor.newInstance(null);
                    return object;
                }
                Object object = JavaConstructorInfo.this._ctor.newInstance(args);
                return object;
            }
            catch (IllegalArgumentException e) {
                GosuExceptionUtil.throwArgMismatchException((IllegalArgumentException)e, (String)"a constructor", (Class[])((ConstructorJavaClassConstructor)JavaConstructorInfo.this._ctor).getJavaParameterTypes(), (Object[])args);
                Object var4_8 = null;
                return var4_8;
            }
            catch (InvocationTargetException ex) {
                throw GosuExceptionUtil.forceThrow((Throwable)ex.getTargetException());
            }
            catch (Throwable t) {
                throw GosuExceptionUtil.forceThrow((Throwable)t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
        }
    }
}

