/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.lang.parser.IExpression;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.perf.objectsize.UnmodifiableSizeTwoSet;
import java.util.Arrays;
import java.util.List;

public class BlockType
extends FunctionType
implements IBlockType {
    private String _relativeSignature;
    private String _relativeSignatureSansBlock;
    private String[] _argNames;
    private IExpression[] _defValues;

    public BlockType(IType returnType, IType[] iIntrinsicTypes, List<String> argNames, List<IExpression> defValues) {
        super("block", returnType, iIntrinsicTypes);
        this._allTypesInHierarchy = new UnmodifiableSizeTwoSet((Object)this, (Object)JavaTypes.IBLOCK());
        this._argNames = argNames.toArray(new String[argNames.size()]);
        this._defValues = defValues.toArray(new IExpression[defValues.size()]);
    }

    public BlockType(IType returnType, IType[] iIntrinsicTypes, String[] argNames, IExpression[] defValues) {
        super("block", returnType, iIntrinsicTypes);
        this._allTypesInHierarchy = new UnmodifiableSizeTwoSet((Object)this, (Object)JavaTypes.IBLOCK());
        this._argNames = new String[argNames.length];
        System.arraycopy(argNames, 0, this._argNames, 0, argNames.length);
        this._defValues = new IExpression[defValues.length];
        System.arraycopy(defValues, 0, this._defValues, 0, defValues.length);
    }

    private BlockType(FunctionType source, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars, List<String> argNames, List<IExpression> defValues) {
        super(source, actualParamByVarName, bKeepTypeVars);
        this._argNames = argNames.toArray(new String[argNames.size()]);
        this._defValues = defValues.toArray(new IExpression[defValues.size()]);
    }

    protected void copyFields(FunctionType source) {
        super.copyFields(source);
    }

    public FunctionType parameterize(FunctionType source, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        return new BlockType(source, actualParamByVarName, bKeepTypeVars, Arrays.asList(this._argNames), Arrays.asList(this._defValues));
    }

    public String getName() {
        return this.getParamSignature().toString() + ":" + this.getReturnType().getName();
    }

    public String getRelativeName() {
        return this.getRelativeParamSignature(false).toString() + ":" + this.getReturnType().getRelativeName();
    }

    public String getRelativeNameSansBlock() {
        return this.getRelativeParamSignature(true).toString() + ":" + this.getReturnType().getRelativeName();
    }

    public String getRelativeParamSignature(boolean bSansBlock) {
        if (this._relativeSignature != null) {
            return bSansBlock ? this._relativeSignatureSansBlock : this._relativeSignature;
        }
        if (this.getParameterTypes().length == 0) {
            this._relativeSignature = this.getParamSignature();
            this._relativeSignatureSansBlock = "()";
        } else {
            String strParams = "(";
            IType[] paramTypes = this.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                strParams = strParams + (i == 0 ? "" : ", ");
                String name = i < this._argNames.length ? this._argNames[i] : "arg" + i;
                strParams = strParams + (name.length() == 0 ? "" : name + ":") + (paramTypes[i] == null ? "" : paramTypes[i].getRelativeName());
            }
            strParams = strParams + ")";
            this._relativeSignature = super.getName() + strParams;
            this._relativeSignatureSansBlock = strParams;
        }
        return bSansBlock ? this._relativeSignatureSansBlock : this._relativeSignature;
    }

    public String[] getParameterNames() {
        return this._argNames;
    }

    protected boolean areReturnTypesAssignable(FunctionType that) {
        IType thatType;
        IType thisType = this.getReturnType();
        return thisType == (thatType = that.getReturnType()) || thatType != JavaTypes.pVOID() && thisType.isAssignableFrom(thatType) || StandardCoercionManager.arePrimitiveTypesAssignable((IType)thisType, (IType)thatType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockType)) {
            return false;
        }
        return super.equals(o);
    }

    public IExpression[] getDefaultValueExpressions() {
        return this._defValues;
    }

    public boolean hasOptionalParams() {
        for (IExpression o : this.getDefaultValueExpressions()) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public IType newInstance(IType[] paramTypes, IType returnType) {
        return new BlockType(returnType, paramTypes, Arrays.asList(this._argNames), Arrays.asList(this._defValues));
    }
}

