/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.IRPropertyFactory;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.StatementTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.SyntheticFunctionStatementTransformer;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.IBlockClassInternal;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.ThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.internal.gosu.parser.statements.LoopStatement;
import gw.internal.gosu.parser.statements.MethodCallStatement;
import gw.internal.gosu.parser.statements.SyntheticFunctionStatement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRStringLiteralExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRImplicitReturnStatement;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IReturnStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.IThrowStatement;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class FunctionStatementTransformer
extends AbstractElementTransformer<FunctionStatement> {
    private static final boolean GW_PROFILER_WRAPPING_ENABLED = System.getProperty("gw.enable.profiler.wrapping") != null || System.getProperty("gw.enable.profiler.wrapping.tags") != null;
    private DynamicFunctionSymbol _dfs;
    private static final AtomicInteger _numGeneratedMethods = new AtomicInteger(1);

    FunctionStatementTransformer(DynamicFunctionSymbol dfs, TopLevelTransformationContext cc) {
        super(cc, dfs == null ? null : dfs.getDeclFunctionStmt());
        this._dfs = dfs;
    }

    IRStatement compile() {
        ArrayList<IRStatement> statements = new ArrayList<IRStatement>();
        if (this._cc().isBlockInvoke()) {
            this.checkcastArgs(statements);
        }
        this.assignCapturedParamIndexes(statements);
        this.compileConstructorInitializers(statements);
        Statement statement = (Statement)this._dfs.getValueDirectly();
        if (statement instanceof SyntheticFunctionStatement) {
            statements.add(SyntheticFunctionStatementTransformer.compile(this._dfs, this._cc(), (SyntheticFunctionStatement)statement));
        } else {
            statements.add(StatementTransformer.compile(this._cc(), statement));
        }
        this.handleImplicitReturns(statement, statements);
        IRStatementList functionBody = new IRStatementList(false, statements);
        if (GW_PROFILER_WRAPPING_ENABLED) {
            functionBody = this.wrapFunctionBodyForProfiler(functionBody);
        }
        return functionBody;
    }

    private IRStatementList wrapFunctionBodyForProfiler(IRStatementList functionBody) {
        if (this._dfs.getScriptPart() == null) {
            return functionBody;
        }
        String strippedClassName = TypeLord.getPureGenericType(this._dfs.getScriptPart().getContainingType()).getName();
        String generatedClassName = "_profiler." + strippedClassName + "_" + _numGeneratedMethods.getAndIncrement();
        IRExpression field = this.getField(IRPropertyFactory.createIRProperty(TypeSystem.getByFullName((String)"gw.api.profiler.ProfilerTag", (IModule)TypeSystem.getGlobalModule()).getTypeInfo().getProperty((CharSequence)"GOSU_METHOD_WRAPPER")), null);
        IRMethod m = IRMethodFactory.createIRMethod(TypeSystem.getByFullName((String)"gw.api.profiler.Profiler", (IModule)TypeSystem.getGlobalModule()), "push", TypeSystem.getByFullName((String)"gw.api.profiler.ProfilerFrame", (IModule)TypeSystem.getGlobalModule()), new IType[]{TypeSystem.getByFullName((String)"gw.api.profiler.ProfilerTag", (IModule)TypeSystem.getGlobalModule())}, IRelativeTypeInfo.Accessibility.PUBLIC, true);
        IRExpression push = this.callMethod(m, null, Arrays.asList(field));
        IRSymbol tempSymbol = this._cc().makeAndIndexTempSymbol(push.getType());
        IRAssignmentStatement initAssignment = this.buildAssignment(tempSymbol, push);
        m = IRMethodFactory.createIRMethod(TypeSystem.getByFullName((String)"gw.api.profiler.ProfilerFrame", (IModule)TypeSystem.getGlobalModule()), "setProperty", (IType)JavaTypes.pVOID(), new IType[]{JavaTypes.STRING()}, IRelativeTypeInfo.Accessibility.PUBLIC, false);
        IRStringLiteralExpression info = new IRStringLiteralExpression(generatedClassName + "_" + this.generateMethodName());
        IRExpression setProp = this.callMethod(m, (IRExpression)this.identifier(tempSymbol), Arrays.asList(info));
        IRMethodCallStatement setPropStmt = new IRMethodCallStatement(setProp);
        m = IRMethodFactory.createIRMethod(TypeSystem.getByFullName((String)"gw.api.profiler.Profiler", (IModule)TypeSystem.getGlobalModule()), "pop", (IType)JavaTypes.pVOID(), new IType[]{TypeSystem.getByFullName((String)"gw.api.profiler.ProfilerFrame", (IModule)TypeSystem.getGlobalModule())}, IRelativeTypeInfo.Accessibility.PUBLIC, true);
        IRExpression pop = this.callMethod(m, null, Arrays.asList(this.identifier(tempSymbol)));
        IRMethodCallStatement popStmt = new IRMethodCallStatement(pop);
        IRTryCatchFinallyStatement tryFinally = new IRTryCatchFinallyStatement((IRStatement)functionBody, Collections.emptyList(), (IRStatement)popStmt);
        return new IRStatementList(functionBody.hasScope(), new IRStatement[]{initAssignment, setPropStmt, tryFinally});
    }

    private String generateMethodName() {
        String methodName = this._dfs.getName();
        String simpleMethodName = methodName.substring(0, methodName.indexOf("("));
        if (simpleMethodName.startsWith("@")) {
            simpleMethodName = this._dfs.getArgs().isEmpty() ? "get" + simpleMethodName.substring(1) : "set" + simpleMethodName.substring(1);
        } else if (simpleMethodName.equals("super")) {
            simpleMethodName = "super1";
        }
        FunctionStatement statement = this._dfs.getDeclFunctionStmt();
        if (statement != null) {
            simpleMethodName = simpleMethodName + "_line_" + statement.getLineNum();
        }
        return simpleMethodName;
    }

    private void handleImplicitReturns(Statement statement, List<IRStatement> statements) {
        IType returnType = this._dfs.getReturnType();
        boolean[] bAbsolute = new boolean[]{false};
        ITerminalStatement terminalStmt = statement.getLeastSignificantTerminalStatement(bAbsolute);
        if (this._cc().isBlockInvoke()) {
            if (terminalStmt == null || !bAbsolute[0]) {
                IRReturnStatement returnStatement = new IRReturnStatement(null, returnType != JavaTypes.pVOID() ? this.nullLiteral() : null);
                returnStatement.setLineNumber(statement.getLineNum());
                statements.add((IRStatement)returnStatement);
            } else if (this._dfs.isLoopImplicitReturn()) {
                IRImplicitReturnStatement returnStmt = this.addImplicitReturn(returnType);
                returnStmt.setLineNumber(this.getLastLineOfFunction(statement));
                statements.add((IRStatement)returnStmt);
            }
        } else if (!(returnType != JavaTypes.pVOID() || bAbsolute[0] && (terminalStmt instanceof IReturnStatement || terminalStmt instanceof IThrowStatement || terminalStmt instanceof LoopStatement))) {
            IRReturnStatement returnStmt = new IRReturnStatement();
            returnStmt.setLineNumber(this.getLastLineOfFunction(statement));
            statements.add((IRStatement)returnStmt);
        } else if (this._dfs.isLoopImplicitReturn()) {
            IRImplicitReturnStatement returnStmt = this.addImplicitReturn(returnType);
            returnStmt.setLineNumber(this.getLastLineOfFunction(statement));
            statements.add((IRStatement)returnStmt);
        }
    }

    private IRImplicitReturnStatement addImplicitReturn(IType returnType) {
        return returnType == JavaTypes.pVOID() ? new IRImplicitReturnStatement() : new IRImplicitReturnStatement(null, this.getDefaultConstIns(returnType));
    }

    private void compileConstructorInitializers(List<IRStatement> statements) {
        MethodCallStatement mc = this._dfs.getInitializer();
        if (mc == null) {
            return;
        }
        if (mc.getLineNum() <= 0 && mc.getParent() != null) {
            mc.setLineNum(mc.getParent().getLineNum());
        }
        this._cc().initCapturedSymbolFields(statements);
        this._cc().initTypeVarFields(statements);
        statements.add(StatementTransformer.compile(this._cc(), mc));
        IFunctionSymbol initializerDfs = mc.getMethodCall().getFunctionSymbol();
        if (!(initializerDfs instanceof ThisConstructorFunctionSymbol)) {
            this._cc().initializeInstanceFields(statements);
        }
    }

    private void assignCapturedParamIndexes(List<IRStatement> statements) {
        for (ISymbol paramSym : this.getActualArgSymbols()) {
            if (!paramSym.isValueBoxed()) continue;
            IRSymbol symbol = new IRSymbol(paramSym.getName(), FunctionStatementTransformer.getDescriptor(paramSym.getType().getArrayType()), false);
            this._cc().putSymbol(symbol);
            IRIdentifier expression = this.identifier(this._cc().getSymbol(symbol.getName() + "$$unboxedParam"));
            IRExpression value = this.buildInitializedArray(FunctionStatementTransformer.getDescriptor(paramSym.getType()), FunctionStatementTransformer.exprList(new IRExpression[]{expression}));
            statements.add((IRStatement)this.buildAssignment(symbol, value));
        }
    }

    private List<ISymbol> getActualArgSymbols() {
        List iSymbolList = this._cc().isBlockInvoke() ? ((IBlockClassInternal)this.getGosuClass()).getBlock().getArgs() : this._dfs.getArgs();
        return iSymbolList;
    }

    private void checkcastArgs(List<IRStatement> statements) {
        for (ISymbol paramSym : this.getActualArgSymbols()) {
            IType actualType = paramSym.getType();
            IRSymbol properlyTypedSymbol = new IRSymbol(paramSym.getName() + (paramSym.isValueBoxed() ? "$$unboxedParam" : ""), FunctionStatementTransformer.getDescriptor(actualType), false);
            this._cc().putSymbol(properlyTypedSymbol);
            IRExpression value = actualType.isPrimitive() ? this.unboxValueToType(actualType, (IRExpression)this.identifier(this._cc().getSymbol(paramSym.getName() + "$$blockParam"))) : this.checkCast(actualType, (IRExpression)this.identifier(this._cc().getSymbol(paramSym.getName() + "$$blockParam")));
            statements.add((IRStatement)this.buildAssignment(properlyTypedSymbol, value));
        }
    }

    private int getLastLineOfFunction(IParsedElement stmt) {
        if (stmt == null) {
            return -1;
        }
        IParsedElement temp = stmt;
        while (stmt != null && !(stmt instanceof IFunctionStatement)) {
            stmt = stmt.getParent();
        }
        if (stmt == null) {
            stmt = temp;
        }
        return stmt instanceof IFunctionStatement ? ((IFunctionStatement)stmt).getLastLine() : -1;
    }
}

