/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.util;

import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.parser.AsmClassJavaClassInfo;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.lang.ir.IRType;
import gw.lang.parser.IFileRepositoryBasedType;
import gw.lang.parser.ILanguageLevel;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import gw.util.GosuObjectUtil;

public class RequiresReflectionDeterminer {
    public static boolean shouldUseReflection(IType declaringClass, ICompilableTypeInternal compilingClass, IRelativeTypeInfo.Accessibility accessibility) {
        return RequiresReflectionDeterminer.shouldUseReflection(declaringClass, compilingClass, null, accessibility);
    }

    public static boolean shouldUseReflection(IType declaringClass, ICompilableTypeInternal compilingClass, IRType root, IRelativeTypeInfo.Accessibility accessibility) {
        boolean bRet = RequiresReflectionDeterminer.isIllegalAccess(declaringClass, compilingClass, accessibility) || RequiresReflectionDeterminer.isEnhancementAccessRequiringReflection(declaringClass, compilingClass, accessibility) || RequiresReflectionDeterminer.isEvalProgramBetweenCallingClassAndDeclaringClass(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClassesOfEvalProgram(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isCallingClassEnclosedInDifferentPackageFromDeclaringSuperclass(compilingClass, declaringClass, root, accessibility) || RequiresReflectionDeterminer.isGosuClassAccessingProtectedOrInternalMethodOfClassInDifferentClassloader(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isProgramCompilingDuringDebuggerSuspension((IType)compilingClass, accessibility) || RequiresReflectionDeterminer.isProgramNotEval((IType)compilingClass, declaringClass) && accessibility != IRelativeTypeInfo.Accessibility.PUBLIC;
        return bRet;
    }

    private static boolean isIllegalAccess(IType declaringClass, ICompilableTypeInternal compilingClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC) {
            return false;
        }
        return !FeatureManager.getAccessibilityForClass((IType)declaringClass, (IType)compilingClass).isAccessible(accessibility);
    }

    private static boolean isProgramCompilingDuringDebuggerSuspension(IType compilingClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC) {
            return false;
        }
        return TypeLord.getOuterMostEnclosingClass(compilingClass) instanceof IGosuProgram && TypeSystem.isIncludeAll();
    }

    private static boolean isEnhancementAccessRequiringReflection(IType declaringClass, ICompilableTypeInternal callingClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC || callingClass == null) {
            return false;
        }
        if (callingClass instanceof IGosuEnhancementInternal) {
            IGosuEnhancementInternal enhancement = (IGosuEnhancementInternal)callingClass;
            IType pureEnhancedType = TypeLord.getPureGenericType(enhancement.getEnhancedType());
            IType pureTargetType = TypeLord.getPureGenericType(declaringClass);
            return pureTargetType.isAssignableFrom(pureEnhancedType);
        }
        return RequiresReflectionDeterminer.isEnhancementAccessRequiringReflection(declaringClass, callingClass.getEnclosingType(), accessibility);
    }

    private static boolean isEvalProgramBetweenCallingClassAndDeclaringClass(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC) {
            return false;
        }
        if (TypeLord.encloses(declaringClass, (IType)callingClass)) {
            while (true) {
                if (RequiresReflectionDeterminer.isInSeparateClassLoader(callingClass, declaringClass)) {
                    return true;
                }
                if (callingClass == declaringClass) {
                    return false;
                }
                callingClass = callingClass.getEnclosingType();
            }
        }
        if (declaringClass instanceof IGosuClassInternal && TypeLord.encloses((IType)callingClass, declaringClass) && TypeLord.encloses(declaringClass, (IType)callingClass)) {
            while (true) {
                if (RequiresReflectionDeterminer.isInSeparateClassLoader((IGosuClassInternal)declaringClass, null)) {
                    return true;
                }
                if (callingClass == declaringClass) {
                    return false;
                }
                declaringClass = declaringClass.getEnclosingType();
            }
        }
        return false;
    }

    private static boolean isDeclaringClassInAncestryOfEnclosingClassesOfEvalProgram(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC || callingClass == null) {
            return false;
        }
        if (RequiresReflectionDeterminer.isInSeparateClassLoader(callingClass, declaringClass) && RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClasses(callingClass, declaringClass)) {
            return true;
        }
        return RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClassesOfEvalProgram(callingClass.getEnclosingType(), declaringClass, accessibility);
    }

    public static boolean isCallingClassEnclosedInDifferentPackageFromDeclaringSuperclass(ICompilableTypeInternal callingClass, IType declaringClass, IRType root, IRelativeTypeInfo.Accessibility accessibility) {
        return accessibility == IRelativeTypeInfo.Accessibility.PROTECTED && !RequiresReflectionDeterminer.getTopLevelNamespace((IType)callingClass).equals(RequiresReflectionDeterminer.getTopLevelNamespace(declaringClass)) && (!RequiresReflectionDeterminer.isEnclosedInSubtypeOfClass(callingClass, declaringClass) || !RequiresReflectionDeterminer.isRootSame(root, callingClass));
    }

    private static boolean isRootSame(IRType root, ICompilableTypeInternal callingClass) {
        IType rootType = root == null ? null : root.getType();
        return rootType == null || rootType == callingClass;
    }

    private static boolean isGosuClassAccessingProtectedOrInternalMethodOfClassInDifferentClassloader(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        return !(accessibility == IRelativeTypeInfo.Accessibility.PUBLIC && AccessibilityUtil.forType(declaringClass) != IRelativeTypeInfo.Accessibility.INTERNAL && AccessibilityUtil.forType(declaringClass) != IRelativeTypeInfo.Accessibility.PRIVATE || !RequiresReflectionDeterminer.getTopLevelNamespace((IType)callingClass).equals(RequiresReflectionDeterminer.getTopLevelNamespace(declaringClass)) || !RequiresReflectionDeterminer.isInSeparateClassLoader(callingClass, declaringClass) && !RequiresReflectionDeterminer.classesLoadInSeparateLoader(callingClass, declaringClass));
    }

    private static boolean classesLoadInSeparateLoader(ICompilableTypeInternal callingClass, IType declaringClass) {
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return RequiresReflectionDeterminer.classesLoadInSeparateLoader_Standard(callingClass, declaringClass);
        }
        return RequiresReflectionDeterminer.classesLoadInSeparateLoader_Legacy(callingClass, declaringClass);
    }

    private static boolean classesLoadInSeparateLoader_Legacy(ICompilableTypeInternal callingClass, IType declaringClass) {
        if (declaringClass instanceof IFileRepositoryBasedType) {
            IDirectory declaringSourcePath;
            if (TypeLord.getOuterMostEnclosingClass(declaringClass) == TypeLord.getOuterMostEnclosingClass((IType)callingClass)) {
                return false;
            }
            if (IGosuClass.ProxyUtil.isProxy((IType)callingClass) || callingClass.getName().contains("_structuralproxy_")) {
                return false;
            }
            IDirectory callingSourcePath = RequiresReflectionDeterminer.getSourcePathFor((IFileRepositoryBasedType)callingClass);
            return !GosuObjectUtil.equals((Object)callingSourcePath, (Object)(declaringSourcePath = RequiresReflectionDeterminer.getSourcePathFor((IFileRepositoryBasedType)declaringClass)));
        }
        return false;
    }

    private static boolean classesLoadInSeparateLoader_Standard(ICompilableTypeInternal callingClass, IType declaringClass) {
        if (declaringClass instanceof IJavaType) {
            IJavaType javaClass = (IJavaType)declaringClass;
            IJavaClassInfo classInfo = javaClass.getBackingClassInfo();
            if (classInfo instanceof AsmClassJavaClassInfo) {
                return false;
            }
            if (classInfo instanceof JavaSourceType) {
                return callingClass.getTypeLoader().getModule() != declaringClass.getTypeLoader().getModule();
            }
            return true;
        }
        return false;
    }

    private static IDirectory getSourcePathFor(IFileRepositoryBasedType gsClass) {
        ISourceFileHandle sourceFileHandle = gsClass.getSourceFileHandle();
        if (sourceFileHandle == null) {
            return null;
        }
        IFile filePath = sourceFileHandle.getFile();
        if (filePath == null) {
            return null;
        }
        for (IDirectory dir : gsClass.getTypeLoader().getModule().getSourcePath()) {
            if (!filePath.isDescendantOf(dir)) continue;
            return dir;
        }
        return null;
    }

    private static boolean isGosuClassAccessingProtectedMemberOfClassNotInHierarchy(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (IGosuClass.ProxyUtil.isProxy((IType)declaringClass)) {
            declaringClass = IGosuClass.ProxyUtil.getProxiedType((IType)declaringClass);
        }
        return accessibility == IRelativeTypeInfo.Accessibility.PROTECTED && !declaringClass.isAssignableFrom((IType)callingClass);
    }

    private static String getTopLevelNamespace(IType type) {
        if (type.getEnclosingType() == null) {
            return type.getNamespace();
        }
        return RequiresReflectionDeterminer.getTopLevelNamespace(type.getEnclosingType());
    }

    private static boolean isEnclosedInSubtypeOfClass(ICompilableTypeInternal potentiallyEnclosedClass, IType potentialSuperType) {
        if (potentiallyEnclosedClass == null) {
            return false;
        }
        if (TypeLord.isSubtype((IType)potentiallyEnclosedClass, potentialSuperType)) {
            return true;
        }
        return RequiresReflectionDeterminer.isEnclosedInSubtypeOfClass(potentiallyEnclosedClass.getEnclosingType(), potentialSuperType);
    }

    private static boolean isInSeparateClassLoader(ICompilableTypeInternal callingClass, IType declaringClass) {
        return callingClass != declaringClass && (RequiresReflectionDeterminer.isInEvalProgram((IType)callingClass) || RequiresReflectionDeterminer.isInEvalProgram(declaringClass) || RequiresReflectionDeterminer.isThrowawayProgram((IType)callingClass) || RequiresReflectionDeterminer.isThrowawayProgram(declaringClass) || BytecodeOptions.isSingleServingLoader());
    }

    private static boolean isDeclaringClassInAncestryOfEnclosingClasses(ICompilableTypeInternal callingClass, IType declaringClass) {
        if (callingClass == null) {
            return false;
        }
        if (TypeLord.isSubtype((IType)callingClass, declaringClass)) {
            return true;
        }
        return RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClasses(callingClass.getEnclosingType(), declaringClass);
    }

    private static boolean isInEvalProgram(IType gsClass) {
        if (gsClass == null) {
            return false;
        }
        return gsClass instanceof IGosuProgram && ((IGosuProgram)gsClass).isAnonymous() || RequiresReflectionDeterminer.isInEvalProgram(gsClass.getEnclosingType());
    }

    private static boolean isThrowawayProgram(IType gsClass) {
        return gsClass instanceof IGosuProgram && ((IGosuProgramInternal)gsClass).isThrowaway();
    }

    private static boolean isProgramNotEval(IType callingClass, IType declaringClass) {
        return callingClass != declaringClass && callingClass instanceof IGosuProgram && !((IGosuProgram)callingClass).isAnonymous();
    }
}

