/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.lang.GosuShop;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.ThreadSafeSymbolTable;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.module.IModule;
import gw.util.Stack;
import gw.util.concurrent.LockingLazyVar;
import java.util.HashMap;
import java.util.Map;

public class CompiledGosuClassSymbolTable
extends ThreadSafeSymbolTable {
    private static final LockingLazyVar<CompiledGosuClassSymbolTable> INSTANCE = new LockingLazyVar<CompiledGosuClassSymbolTable>(){

        protected CompiledGosuClassSymbolTable init() {
            return new CompiledGosuClassSymbolTable();
        }
    };
    private static final ThreadLocal<Stack> SYM_TABLE_STACK = new ThreadLocal();
    private static final ThreadLocal<Stack> SYM_TABLE_TRACE_STACK = new ThreadLocal();
    private static final ThreadLocal<Map<ICompilableType, ISymbolTable>> MAP_SYM_TABLE_BY_TYPE = new ThreadLocal();
    private static final boolean DEBUG = false;

    public static CompiledGosuClassSymbolTable instance() {
        return (CompiledGosuClassSymbolTable)((Object)INSTANCE.get());
    }

    CompiledGosuClassSymbolTable() {
        super(true);
    }

    public static ISymbolTable getSymTableCtx() {
        Stack stack = CompiledGosuClassSymbolTable.getSymbolTableStack();
        if (stack.size() > 0) {
            return (ISymbolTable)stack.peek();
        }
        return null;
    }

    public static void pushSymTableCtx(ISymbolTable ctx) {
        Stack stack = CompiledGosuClassSymbolTable.getSymbolTableStack();
        stack.push((Object)ctx);
    }

    public static ISymbolTable popSymTableCtx() {
        Stack stack = CompiledGosuClassSymbolTable.getSymbolTableStack();
        ISymbolTable symTable = (ISymbolTable)stack.pop();
        assert (stack.size() > 0) : "Must always be at least one thread local symbol table";
        return symTable;
    }

    public ISymbolTable getSymbolTableForCompilingClass(ICompilableType gsClass) {
        return CompiledGosuClassSymbolTable.getClassMap().get(gsClass);
    }

    public void pushCompileTimeSymbolTable(ICompilableType gsClass) {
        this.pushCompileTimeSymbolTable(gsClass, (ISymbolTable)CompiledGosuClassSymbolTable.instance());
    }

    public void pushCompileTimeSymbolTable(ICompilableType gsClass, ISymbolTable symTable) {
        TypeSystem.pushModule((IModule)gsClass.getTypeLoader().getModule());
        this.pushCompileTimeSymbolTable(symTable);
        if (CompiledGosuClassSymbolTable.getClassMap().containsKey(gsClass)) {
            throw new IllegalStateException("Already compiling class " + gsClass.getName());
        }
        CompiledGosuClassSymbolTable.getClassMap().put(gsClass, (ISymbolTable)CompiledGosuClassSymbolTable.getSymbolTableStack().peek());
    }

    public void pushCompileTimeSymbolTable() {
        this.pushCompileTimeSymbolTable((ISymbolTable)new StandardSymbolTable(true));
    }

    public void pushCompileTimeSymbolTable(ISymbolTable symTable) {
        CompiledGosuClassSymbolTable.pushSymTableCtx((ISymbolTable)(symTable == this ? new StandardSymbolTable(true) : symTable));
    }

    public void popCompileTimeSymbolTable(ICompilableType gsClass) {
        this.popCompileTimeSymbolTable();
        TypeSystem.popModule((IModule)gsClass.getTypeLoader().getModule());
    }

    public void popCompileTimeSymbolTable() {
        ISymbolTable symTable = CompiledGosuClassSymbolTable.popSymTableCtx();
        Map<ICompilableType, ISymbolTable> map = CompiledGosuClassSymbolTable.getClassMap();
        for (ICompilableType gsClass : map.keySet()) {
            if (map.get(gsClass) != symTable) continue;
            map.remove(gsClass);
            break;
        }
    }

    protected ISymbolTable getThreadLocalSymbolTable() {
        ISymbolTable symTableCtx = CompiledGosuClassSymbolTable.getSymTableCtx();
        if (symTableCtx == this) {
            return null;
        }
        return symTableCtx;
    }

    private static Stack getSymbolTableStack() {
        Stack stack = SYM_TABLE_STACK.get();
        if (stack == null) {
            stack = new Stack();
            stack.push((Object)new StandardSymbolTable(true));
            SYM_TABLE_STACK.set(stack);
        }
        return stack;
    }

    private static Map<ICompilableType, ISymbolTable> getClassMap() {
        Map<ICompilableType, ISymbolTable> map = MAP_SYM_TABLE_BY_TYPE.get();
        if (map == null) {
            map = new HashMap<ICompilableType, ISymbolTable>(8);
            MAP_SYM_TABLE_BY_TYPE.set(map);
        }
        return map;
    }

    public static Stack getSymbolTableTraceStack() {
        Stack stack = SYM_TABLE_TRACE_STACK.get();
        if (stack == null) {
            stack = new Stack();
            SYM_TABLE_TRACE_STACK.set(stack);
        }
        return stack;
    }

    static {
        TypeSystem.addShutdownListener((TypeSystemShutdownListener)new TypeSystemShutdownListener(){

            public void shutdown() {
                INSTANCE.clear();
                GosuShop.clearThreadLocal((ThreadLocal)SYM_TABLE_STACK);
                GosuShop.clearThreadLocal((ThreadLocal)SYM_TABLE_TRACE_STACK);
                GosuShop.clearThreadLocal((ThreadLocal)MAP_SYM_TABLE_BY_TYPE);
            }
        });
    }
}

