/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import gw.internal.gosu.parser.java.classinfo.JavaWildcardType;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaClassParameterizedType;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.module.IModule;

public class JavaParameterizedType
implements IJavaClassParameterizedType {
    private IJavaClassType[] _args;
    private IJavaClassType _rawType;

    public JavaParameterizedType(IJavaClassType[] args, IJavaClassType rawType) {
        if (rawType == null) {
            throw new RuntimeException("Raw type of a parameterized type cannot be null");
        }
        for (IJavaClassType arg : args) {
            if (arg != null) continue;
            throw new RuntimeException("Arg type of a parameterized type cannot be null");
        }
        this._args = args;
        this._rawType = rawType;
        for (IJavaClassType arg : args) {
            if (!(arg instanceof JavaWildcardType)) continue;
            ((JavaWildcardType)arg).setOwnerType(this);
        }
    }

    public IJavaClassType[] getActualTypeArguments() {
        return this._args;
    }

    public IType getActualType(TypeVarToTypeMap typeMap) {
        return this.getActualType(typeMap, false);
    }

    public IType getActualType(TypeVarToTypeMap typeMap, boolean bKeepTypeVars) {
        IType[] args = new IType[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            args[i] = this._args[i] != null ? this._args[i].getActualType(typeMap, bKeepTypeVars) : TypeSystem.getErrorType();
        }
        IType actualType = this._rawType.getActualType(typeMap);
        return actualType instanceof IErrorType ? actualType : actualType.getParameterizedType(args);
    }

    public IJavaClassType getConcreteType() {
        return this._rawType;
    }

    public String getName() {
        String name = this._rawType.getName() + "<";
        for (int i = 0; i < this._args.length; ++i) {
            IJavaClassType type = this._args[i];
            name = name + type.getName();
            if (i >= this._args.length - 1) continue;
            name = name + ",";
        }
        name = name + ">";
        return name;
    }

    public String getSimpleName() {
        return this.getName();
    }

    public boolean isArray() {
        return false;
    }

    public IJavaClassType getComponentType() {
        return null;
    }

    public IModule getModule() {
        return this._rawType.getModule();
    }

    public String getNamespace() {
        return this._rawType.getNamespace();
    }

    public String toString() {
        String s = this._rawType.getName() + "<";
        for (int i = 0; i < this._args.length; ++i) {
            s = s + this._args[i].getName();
            if (i == this._args.length - 1) continue;
            s = s + ", ";
        }
        return s + ">";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaParameterizedType)) {
            return false;
        }
        JavaParameterizedType t1 = this;
        JavaParameterizedType t2 = (JavaParameterizedType)obj;
        if (!t1._rawType.equals(t2._rawType)) {
            return false;
        }
        if (t1._args.length != t2._args.length) {
            return false;
        }
        for (int i = 0; i < t1._args.length; ++i) {
            if (t1._args[i].equals(t2._args[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

