/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.expressions.ClassDeclaration;
import gw.internal.gosu.parser.statements.ClassFileStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.module.IModule;
import java.util.List;

public final class ClassStatement
extends Statement
implements IClassStatement {
    private IGosuClassInternal _gsClass;
    private ClassFileStatement _cfs;
    private ClassDeclaration _classDeclaration;

    public ClassStatement(IGosuClassInternal gsClass) {
        this._gsClass = gsClass;
        if (this._gsClass != null && this._gsClass.getEnclosingType() == null) {
            this._cfs = new ClassFileStatement();
        }
    }

    public ClassFileStatement getClassFileStatement() {
        return this._cfs;
    }

    @Override
    public Object execute() {
        return Statement.VOID_RETURN_VALUE;
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        bAbsolute[0] = false;
        return null;
    }

    @Override
    public boolean isNoOp() {
        return true;
    }

    @Override
    public String toString() {
        return this._gsClass.getClassType().keyword() + " " + this._gsClass.getName() + "{ ... }";
    }

    @Override
    public IGosuClassInternal getGosuClass() {
        return this._gsClass;
    }

    @Override
    public void clearParseTreeInformation() {
        TypeSystem.lock();
        try {
            super.clearParseTreeInformation();
            if (this._cfs != null) {
                this._cfs.setLocation(null);
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    @Override
    public IModule getModule() {
        return this._gsClass.getTypeLoader().getModule();
    }

    private IGosuClassInternal getEnclosingClass() {
        IGosuClassInternal clazz = this._gsClass;
        while (clazz.getEnclosingType() != null) {
            clazz = (IGosuClassInternal)clazz.getEnclosingType();
        }
        return clazz;
    }

    private IFeatureInfo getFeatureInfoIfAnyThatEnclosesItselfAndItsChildren() {
        return this.getGosuClass().getTypeInfo();
    }

    public ClassDeclaration getClassDeclaration() {
        if (this._classDeclaration == null && this._gsClass instanceof IGosuProgram) {
            this._classDeclaration = new ClassDeclaration(this._gsClass.getName());
            ParseTree location = new ParseTree(this._classDeclaration, 0, 0, this.getLocation().getScriptPartId());
            location.setParent(this.getLocation());
            this._classDeclaration.setLocation(location);
            this._classDeclaration.setParent(this);
        }
        return this._classDeclaration;
    }

    public void setClassDeclaration(ClassDeclaration classDeclaration) {
        this._classDeclaration = classDeclaration;
    }

    @Override
    public List<IGosuAnnotation> getAnnotations() {
        return this.getGosuClass().getModifierInfo().getAnnotations();
    }
}

