/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.internal.gosu.parser.FileSystemGosuClassRepository;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.lang.parser.IFileRepositoryBasedType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.gs.IFileSystemGosuClassRepository;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.module.IModule;
import gw.util.StringPool;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.api.type.TypeName;

class PackageToClassPathEntryTreeMap {
    private String _strFullPackageName;
    private String _strRelativePackageName;
    private Map<String, PackageToClassPathEntryTreeMap> _children = new HashMap<String, PackageToClassPathEntryTreeMap>();
    private List<IFileSystemGosuClassRepository.ClassPathEntry> _classPathEntries = new ArrayList<IFileSystemGosuClassRepository.ClassPathEntry>();
    private PackageToClassPathEntryTreeMap _parent;
    private IModule _module;

    PackageToClassPathEntryTreeMap(PackageToClassPathEntryTreeMap parent, String packageName, IModule module) {
        this._parent = parent;
        this._module = module;
        this._strRelativePackageName = packageName;
        this._strFullPackageName = parent != null && !parent._strFullPackageName.isEmpty() ? parent._strFullPackageName + "." + packageName : packageName;
    }

    public void addClassPathEntry(IFileSystemGosuClassRepository.ClassPathEntry entry) {
        if (!this._classPathEntries.contains(entry)) {
            this._classPathEntries.add(entry);
        }
    }

    public PackageToClassPathEntryTreeMap createChildForDir(IFileSystemGosuClassRepository.ClassPathEntry entry, String packageName) {
        PackageToClassPathEntryTreeMap packageTree = this._children.get(packageName);
        if (packageTree == null) {
            packageTree = new PackageToClassPathEntryTreeMap(this, packageName, this._module);
            this._children.put(packageName, packageTree);
        }
        if (entry != null) {
            packageTree.addClassPathEntry(entry);
        }
        return packageTree;
    }

    public PackageToClassPathEntryTreeMap getChild(String relativePackage) {
        return this._children.get(relativePackage);
    }

    public FileSystemGosuClassRepository.ClassFileInfo resolveToClassFileInfo(String strQualifiedClassName, String[] extensions) {
        if (strQualifiedClassName.length() <= this._strFullPackageName.length()) {
            return null;
        }
        String remainingPart = this._strFullPackageName.isEmpty() ? strQualifiedClassName : strQualifiedClassName.substring(this._strFullPackageName.length() + 1);
        int dotIndex = remainingPart.indexOf(46);
        String fileName = remainingPart.substring(0, dotIndex == -1 ? remainingPart.length() : dotIndex);
        for (IFileSystemGosuClassRepository.ClassPathEntry classPathEntry : this._classPathEntries) {
            FileSystemGosuClassRepository.ClassFileInfo info = this.getClassFileInfo(classPathEntry, fileName, dotIndex, remainingPart, extensions);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    public URL resolveToResource(String resourceName) {
        if (resourceName.length() <= this._strFullPackageName.length()) {
            return null;
        }
        String remainingPart = resourceName.substring(this._strFullPackageName.length() + 1);
        for (IFileSystemGosuClassRepository.ClassPathEntry classPathEntry : this._classPathEntries) {
            URL url = this.getResource(classPathEntry, remainingPart);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private FileSystemGosuClassRepository.ClassFileInfo getClassFileInfo(IFileSystemGosuClassRepository.ClassPathEntry classPathEntry, String fileName, int dotIndex, String remainingPart, String[] extensions) {
        FileSystemGosuClassRepository.ClassFileInfo file = this.getFile(classPathEntry, fileName, extensions);
        if (file != null && dotIndex != -1) {
            IType outerMostClass;
            try {
                outerMostClass = TypeLoaderAccess.instance().getIntrinsicTypeByFullName(this._strFullPackageName + "." + fileName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            List<String> innerClassParts = PackageToClassPathEntryTreeMap.splitInnerClassPartsIntoList(dotIndex, remainingPart);
            if (!(outerMostClass instanceof IFileRepositoryBasedType)) {
                throw new RuntimeException("Type not a IFileRepositoryBasedType: " + outerMostClass);
            }
            return new FileSystemGosuClassRepository.ClassFileInfo(((IFileRepositoryBasedType)outerMostClass).getSourceFileHandle(), ((IFileRepositoryBasedType)outerMostClass).getClassType(), this._strFullPackageName + "." + fileName, innerClassParts, classPathEntry.isTestResource());
        }
        return file;
    }

    public static List<String> splitInnerClassPartsIntoList(int dotIndex, String remainingPart) {
        String[] parts = remainingPart.substring(dotIndex + 1).split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringPool.get((String)parts[i]);
        }
        return Arrays.asList(parts);
    }

    private URL getResource(IFileSystemGosuClassRepository.ClassPathEntry root, String strFileName) {
        try {
            IFile possibleFile = this.getFile(root, strFileName);
            return possibleFile == null ? null : possibleFile.toURI().toURL();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private IFile getFile(IFileSystemGosuClassRepository.ClassPathEntry root, String strFileName) {
        IDirectory dir = this.getDir(root);
        return this.getFileMatchCase(dir, strFileName);
    }

    private FileSystemGosuClassRepository.ClassFileInfo getFile(IFileSystemGosuClassRepository.ClassPathEntry root, String strFileName, String[] extensions) {
        IDirectory dir = this.getDir(root);
        for (String ext : extensions) {
            IFile file = this.getFileMatchCase(dir, strFileName + ext);
            if (file == null) continue;
            return new FileSystemGosuClassRepository.ClassFileInfo(root, file, root.isTestResource());
        }
        return null;
    }

    private IFile getFileMatchCase(IDirectory dir, String strFileName) {
        if (dir.hasChildFile(strFileName)) {
            IFile file = dir.file(strFileName);
            try {
                if (this.doesFileMatchCase(strFileName, file)) {
                    return file;
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean doesFileMatchCase(String strFileName, IFile file) throws IOException {
        return !file.isJavaFile() || file.toJavaFile().getCanonicalPath().endsWith(strFileName);
    }

    private IDirectory getDir(IFileSystemGosuClassRepository.ClassPathEntry root) {
        return this._strFullPackageName.isEmpty() ? root.getPath() : root.getPath().dir(this._strFullPackageName.replace('.', File.separatorChar));
    }

    public void delete(IDirectory dir) {
        if (this._classPathEntries.size() == 1) {
            this._parent.removeChild(this);
        } else {
            for (IFileSystemGosuClassRepository.ClassPathEntry entry : this._classPathEntries) {
                if (!dir.equals(entry.getPath()) && !dir.isDescendantOf(entry.getPath())) continue;
                this._classPathEntries.remove(entry);
                break;
            }
        }
    }

    private void removeChild(PackageToClassPathEntryTreeMap pkg) {
        this._children.remove(pkg._strRelativePackageName);
    }

    public PackageToClassPathEntryTreeMap getParent() {
        return this._parent;
    }

    public int getSourceRootCount() {
        return this._classPathEntries.size();
    }

    public String toString() {
        return this._strFullPackageName;
    }

    public Set<TypeName> getTypeNames(Set<String> extensions, ITypeLoader loader) {
        HashSet<TypeName> names = new HashSet<TypeName>();
        for (PackageToClassPathEntryTreeMap child : this._children.values()) {
            String name = child._strFullPackageName;
            name = name.substring(name.lastIndexOf(46) + 1);
            names.add(new TypeName(name, loader, TypeName.Kind.NAMESPACE, TypeName.Visibility.PUBLIC));
        }
        for (IFileSystemGosuClassRepository.ClassPathEntry classPathEntry : this._classPathEntries) {
            IDirectory entryPath = classPathEntry.getPath().dir(this._strFullPackageName.replace('.', '/'));
            List files = entryPath.listFiles();
            for (IFile file : files) {
                String extension = "." + file.getExtension();
                if (!extensions.contains(extension)) continue;
                String fqn = entryPath.relativePath((IResource)file).replace('/', '.');
                fqn = fqn.substring(0, fqn.lastIndexOf(46));
                names.add(new TypeName(this._strFullPackageName + "." + fqn, loader, TypeName.Kind.TYPE, TypeName.Visibility.PUBLIC));
            }
        }
        return names;
    }
}

