/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.module.IModule;
import gw.util.Array;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmClassAnnotationInfo
implements IAnnotationInfo {
    private AsmAnnotation _annotation;
    private IJavaAnnotatedElement _owner;
    private static final Map<String, Class> SUPPORTED_TYPES = new HashMap<String, Class>();

    public AsmClassAnnotationInfo(AsmAnnotation annotation, IJavaAnnotatedElement owner) {
        this._annotation = annotation;
        this._owner = owner;
    }

    public String getName() {
        return this._annotation.getType().getName();
    }

    public IType getOwnersType() {
        return this._owner.getEnclosingClass().getJavaType();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public Annotation getInstance() {
        throw new RuntimeException("Not supported for source types");
    }

    public Object getFieldValue(String fieldName) {
        return this.normalizeValue(fieldName, this._annotation.getFieldValues().get(fieldName));
    }

    private Object normalizeValue(String fieldName, Object value) {
        if (value instanceof List) {
            value = this.makeArray(fieldName, (List)value);
        } else if (value instanceof AsmAnnotation) {
            value = new AsmClassAnnotationInfo((AsmAnnotation)value, this._owner);
        }
        return value;
    }

    private Object makeArray(String fieldName, List l) {
        IJavaClassInfo classInfo = TypeSystem.getJavaClassInfo((String)this._annotation.getType().getName(), (IModule)this.findModule(this._owner));
        try {
            IJavaClassMethod method = classInfo.getDeclaredMethod(fieldName, new IJavaClassInfo[0]);
            IJavaClassInfo ci = method.getReturnClassInfo();
            return AsmClassAnnotationInfo.makeArray(ci, l, this._owner);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IModule findModule(IJavaAnnotatedElement elem) {
        if (elem instanceof IJavaClassType) {
            return ((IJavaClassType)elem).getModule();
        }
        return this.findModule((IJavaAnnotatedElement)elem.getEnclosingClass());
    }

    public IType getType() {
        return TypeSystem.getByFullName((String)this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public static Object makeArray(IJavaClassInfo ci, List l, IJavaAnnotatedElement owner) throws ClassNotFoundException {
        Object array;
        IJavaClassInfo componentType = ci.getComponentType();
        if (!componentType.isArray()) {
            Class compClass = componentType.isEnum() ? String.class : AsmClassAnnotationInfo.getClass(componentType);
            if (compClass == null) {
                throw new IllegalStateException();
            }
            array = Array.newInstance(compClass, (int)l.size());
            for (int i = 0; i < l.size(); ++i) {
                Object elem = l.get(i);
                if (compClass == IAnnotationInfo.class) {
                    elem = new AsmClassAnnotationInfo((AsmAnnotation)elem, owner);
                }
                Array.set((Object)array, (int)i, elem);
                continue;
            }
        } else {
            array = Array.newInstance(AsmClassAnnotationInfo.getClass(componentType), (int)l.size());
            for (int i = 0; i < l.size(); ++i) {
                Object elem = AsmClassAnnotationInfo.makeArray(componentType, (List)l.get(i), owner);
                Array.set((Object)array, (int)i, (Object)elem);
            }
        }
        return array;
    }

    private static Class<?> getClass(IJavaClassInfo ci) {
        if (ci.isArray()) {
            return Array.newInstance(AsmClassAnnotationInfo.getClass(ci.getComponentType()), (int)0).getClass();
        }
        if (ci.isAnnotation()) {
            return IAnnotationInfo.class;
        }
        if (ci.isEnum()) {
            return String.class;
        }
        String componentName = ci.getName();
        Class cls = SUPPORTED_TYPES.get(componentName);
        return cls == null ? String.class : cls;
    }

    static {
        SUPPORTED_TYPES.put(Byte.TYPE.getName(), Byte.TYPE);
        SUPPORTED_TYPES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        SUPPORTED_TYPES.put(Character.TYPE.getName(), Character.TYPE);
        SUPPORTED_TYPES.put(Short.TYPE.getName(), Short.TYPE);
        SUPPORTED_TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        SUPPORTED_TYPES.put(Long.TYPE.getName(), Long.TYPE);
        SUPPORTED_TYPES.put(Float.TYPE.getName(), Float.TYPE);
        SUPPORTED_TYPES.put(Double.TYPE.getName(), Double.TYPE);
        SUPPORTED_TYPES.put(Void.TYPE.getName(), Void.TYPE);
        SUPPORTED_TYPES.put(String.class.getName(), String.class);
        SUPPORTED_TYPES.put(AsmAnnotation.class.getName(), IAnnotationInfo.class);
    }
}

