/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.properties;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.internal.gosu.properties.EmptyPropertySet;
import gw.internal.gosu.properties.PropertiesTypeLoader;
import gw.internal.gosu.properties.PropertyNode;
import gw.internal.gosu.properties.PropertySet;
import gw.internal.gosu.properties.PropertySetSource;
import gw.internal.gosu.util.StringUtil;
import gw.lang.reflect.module.IModule;
import gw.util.Pair;
import gw.util.concurrent.LockingLazyVar;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class PropertiesPropertySet
implements PropertySet {
    private final String _name;
    private final Set<String> _keys;
    private final Properties _properties;

    public PropertiesPropertySet(String name, Properties properties) {
        this._name = name;
        this._properties = properties;
        this._keys = this.getStringPropertyNames(properties);
    }

    @Override
    public Set<String> getKeys() {
        return this._keys;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getValue(String key) {
        return this._properties.getProperty(key);
    }

    private Set<String> getStringPropertyNames(Properties properties) {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            result.add((String)entry.getKey());
        }
        return Collections.unmodifiableSet(result);
    }

    public static class Source
    implements PropertySetSource {
        private static final String EXTENSION = ".properties";
        private final IModule _module;
        private final LockingLazyVar<Map<String, IFile>> _filesByTypeName = LockingLazyVar.make(() -> {
            List<Pair<String, IFile>> propertiesFiles = this.findAllFilesByExtension(EXTENSION);
            int initialCapacity = propertiesFiles.size();
            HashMap<String, IFile> result = new HashMap<String, IFile>(initialCapacity);
            for (Pair<String, IFile> pair : propertiesFiles) {
                String typeName;
                String fileName = (String)pair.getFirst();
                if (PropertiesTypeLoader.isDisplayPropertiesFile(((IFile)pair.getSecond()).getName()) || !Source.isValidTypeName(typeName = fileName.substring(0, fileName.length() - EXTENSION.length()).replace('/', '.'))) continue;
                result.putIfAbsent(typeName, (IFile)pair.getSecond());
            }
            return result;
        });

        public List<Pair<String, IFile>> findAllFilesByExtension(String extension) {
            ArrayList<Pair<String, IFile>> results = new ArrayList<Pair<String, IFile>>();
            for (IDirectory sourceEntry : this._module.getSourcePath()) {
                if (!sourceEntry.exists()) continue;
                String prefix = sourceEntry.getName().equals("config") ? "config" : "";
                this.addAllLocalResourceFilesByExtensionInternal(prefix, sourceEntry, extension, results);
            }
            return results;
        }

        private void addAllLocalResourceFilesByExtensionInternal(String relativePath, IDirectory dir, String extension, List<Pair<String, IFile>> results) {
            List<IDirectory> excludedPath = Arrays.asList(this._module.getFileRepository().getExcludedPath());
            if (excludedPath.contains(dir)) {
                return;
            }
            if (!CommonServices.getPlatformHelper().isPathIgnored(relativePath)) {
                String path;
                for (IFile file : dir.listFiles()) {
                    if (!file.getName().endsWith(extension)) continue;
                    path = Source.appendResourceNameToPath(relativePath, file.getName());
                    results.add((Pair<String, IFile>)new Pair((Object)path, (Object)file));
                }
                for (IDirectory subdir : dir.listDirs()) {
                    path = Source.appendResourceNameToPath(relativePath, subdir.getName());
                    this.addAllLocalResourceFilesByExtensionInternal(path, subdir, extension, results);
                }
            }
        }

        private static String appendResourceNameToPath(String relativePath, String resourceName) {
            Object path = relativePath.length() > 0 ? relativePath + "/" + resourceName : resourceName;
            return path;
        }

        @Override
        public PropertySet getPropertySetForFile(IFile file) {
            for (Map.Entry entry : ((Map)this._filesByTypeName.get()).entrySet()) {
                IFile value = (IFile)entry.getValue();
                if (!value.equals(file)) continue;
                return this.getPropertySet((String)entry.getKey());
            }
            return null;
        }

        @Override
        public IFile getFile(String name) {
            return (IFile)((Map)this._filesByTypeName.get()).get(name);
        }

        public Source(IModule module) {
            this._module = module;
        }

        @Override
        public Set<String> getPropertySetNames() {
            return ((Map)this._filesByTypeName.get()).keySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PropertySet getPropertySet(String name) {
            IFile file = (IFile)((Map)this._filesByTypeName.get()).get(name);
            if (file == null) {
                throw new IllegalArgumentException(name + " is not the name of a properties file property set");
            }
            PropertySet result = new EmptyPropertySet(name);
            if (file.exists()) {
                try {
                    InputStream propertiesStream = file.openInputStream();
                    Properties properties = new Properties();
                    try {
                        properties.load(propertiesStream);
                        result = new PropertiesPropertySet(name, properties);
                    }
                    finally {
                        Source.closeSafely(propertiesStream);
                    }
                }
                catch (IOException e) {
                    CommonServices.getEntityAccess().getLogger().error((Object)String.format("Could not read property file %s", file), (Throwable)e);
                }
            }
            return result;
        }

        private static boolean isValidTypeName(String typeName) {
            List<String> nameParts = StringUtil.tokenizeToList(typeName, '.');
            if (nameParts == null || nameParts.isEmpty()) {
                return false;
            }
            for (String namePart : nameParts) {
                if (PropertyNode.isGosuIdentifier(namePart)) continue;
                return false;
            }
            return true;
        }

        private static void closeSafely(InputStream inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

