/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRNewArrayExpression;

public class IRNewArrayExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRNewArrayExpression expression, IRBytecodeContext context) {
        IRBytecodeCompiler.compileIRExpression(expression.getSizeExpression(), context);
        MethodVisitor mv = context.getMv();
        IRNewArrayExpressionCompiler.createArrayInstruction(expression.getComponentType(), mv);
    }

    public static void createArrayInstruction(IRType expressionType, MethodVisitor mv) {
        if (expressionType.isPrimitive()) {
            mv.visitIntInsn(188, IRNewArrayExpressionCompiler.getPrimitiveTypeForNewArray(expressionType));
        } else {
            mv.visitTypeInsn(189, IRNewArrayExpressionCompiler.getTypeForNewArray(expressionType));
        }
    }

    private static String getTypeForNewArray(IRType atomicType) {
        return atomicType.isArray() ? atomicType.getDescriptor() : atomicType.getSlashName();
    }

    public static int getPrimitiveTypeForNewArray(IRType atomicType) {
        if (atomicType.isByte()) {
            return 8;
        }
        if (atomicType.isChar()) {
            return 5;
        }
        if (atomicType.isBoolean()) {
            return 4;
        }
        if (atomicType.isShort()) {
            return 9;
        }
        if (atomicType.isInt()) {
            return 10;
        }
        if (atomicType.isLong()) {
            return 11;
        }
        if (atomicType.isFloat()) {
            return 6;
        }
        if (atomicType.isDouble()) {
            return 7;
        }
        throw new IllegalStateException("Unhandled primitive type: " + atomicType.getName());
    }
}

