/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.types;

import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.GosuConstructorInfo;
import gw.lang.parser.IExpression;
import gw.lang.parser.IReducedSymbol;
import gw.lang.reflect.AbstractType;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IConstructorType;
import gw.lang.reflect.IOptionalParamCapable;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.Modifier;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class ConstructorType
extends AbstractType
implements IConstructorType {
    protected IType _declaringType;
    protected IType[] _argTypes;
    protected IConstructorInfo _constructor;

    public ConstructorType(IType declaringType, IType[] argTypes) {
        this._declaringType = declaringType;
        this._argTypes = argTypes == null ? IType.EMPTY_ARRAY : argTypes;
        this._constructor = null;
    }

    public ConstructorType(IConstructorInfo constructor) {
        this._constructor = constructor;
        IParameterInfo[] argTypes = constructor.getParameters();
        int iArgs = argTypes.length;
        this._argTypes = iArgs == 0 ? IType.EMPTY_ARRAY : new IType[iArgs];
        for (int i = 0; i < iArgs; ++i) {
            this._argTypes[i] = argTypes[i].getFeatureType();
        }
        this._declaringType = this._constructor.getType();
    }

    public IType getIntrinsicType() {
        return this.getDeclaringType();
    }

    public IType getDeclaringType() {
        return this._declaringType;
    }

    public IType[] getParameterTypes() {
        return this._argTypes;
    }

    public IConstructorInfo getConstructor() {
        return this._constructor;
    }

    public String getArgSignature() {
        Object strParams = "(";
        for (int i = 0; i < this._argTypes.length; ++i) {
            strParams = (String)strParams + (i == 0 ? "" : ", ") + this._argTypes[i].getName();
        }
        strParams = (String)strParams + ")";
        return strParams;
    }

    public String getParamSignature() {
        return this.getArgSignature();
    }

    public String getName() {
        return this.getDeclaringType().getName() + this.getArgSignature();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getRelativeName() {
        return this.getDeclaringType().getRelativeName() + this.getArgSignature();
    }

    public String getNamespace() {
        return this.getDeclaringType().getNamespace();
    }

    public ITypeLoader getTypeLoader() {
        return this.getDeclaringType().getTypeLoader();
    }

    public boolean isInterface() {
        return false;
    }

    public IType[] getInterfaces() {
        return EMPTY_TYPE_ARRAY;
    }

    public boolean isEnum() {
        return false;
    }

    public IType getSupertype() {
        return null;
    }

    public IType getEnclosingType() {
        return null;
    }

    public IType getGenericType() {
        return null;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public GenericTypeVariable[] getGenericTypeVariables() {
        return GenericTypeVariable.EMPTY_TYPEVARS;
    }

    public IType getParameterizedType(IType ... ofType) {
        return null;
    }

    public IType[] getTypeParameters() {
        return IType.EMPTY_ARRAY;
    }

    public Set getAllTypesInHierarchy() {
        return Collections.singleton(this);
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public IType getArrayType() {
        return null;
    }

    public Object makeArrayInstance(int iLength) {
        return null;
    }

    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return null;
    }

    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public int getArrayLength(Object array) throws IllegalArgumentException {
        return 0;
    }

    public IType getComponentType() {
        return null;
    }

    public boolean isAssignableFrom(IType type) {
        return type == this;
    }

    public boolean isMutable() {
        return false;
    }

    public ITypeInfo getTypeInfo() {
        return null;
    }

    public void unloadTypeInfo() {
    }

    public Object readResolve() throws ObjectStreamException {
        return this;
    }

    public boolean isValid() {
        return true;
    }

    public int getModifiers() {
        return this._constructor != null ? Modifier.getModifiersFrom((IAttributedFeatureInfo)this._constructor) : 1;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ConstructorType)) {
            return false;
        }
        ConstructorType ct = (ConstructorType)((Object)obj);
        return this.getDeclaringType().equals(ct.getDeclaringType()) && Arrays.equals(this.getParameterTypes(), ct.getParameterTypes());
    }

    public boolean isDiscarded() {
        return false;
    }

    public void setDiscarded(boolean bDiscarded) {
    }

    public boolean isCompoundType() {
        return false;
    }

    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    public String[] getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this._constructor == null) {
            return new String[0];
        }
        if (this._constructor instanceof GosuConstructorInfo) {
            GosuConstructorInfo ci = (GosuConstructorInfo)this._constructor;
            for (IReducedSymbol s : ci.getArgs()) {
                names.add(s.getName());
            }
        } else {
            IParameterInfo[] parameters;
            for (IParameterInfo parameter : parameters = this._constructor.getParameters()) {
                names.add(parameter.getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public IExpression[] getDefaultValueExpressions() {
        if (this.getConstructor() instanceof IOptionalParamCapable) {
            return ((IOptionalParamCapable)this.getConstructor()).getDefaultValueExpressions();
        }
        return IExpression.EMPTY_ARRAY;
    }

    public boolean hasOptionalParams() {
        for (IExpression o : this.getDefaultValueExpressions()) {
            if (o == null) continue;
            return true;
        }
        return false;
    }
}

