/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.fs.IFile;
import gw.lang.parser.IFileRepositoryBasedType;
import gw.lang.parser.IHasInnerClass;
import gw.lang.parser.ISource;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.util.cache.StringPool;

public class InnerClassFileSystemSourceFileHandle
implements ISourceFileHandle {
    private String _strInnerClass;
    private String _strEnclosingType;
    private String _strNamespace;
    private boolean _bTestClass;
    private int _iOffset;
    private int _iEnd;
    private int _mark;
    private ClassType _classType;

    public InnerClassFileSystemSourceFileHandle(ClassType classType, String strEnclosingType, String strInnerClass, boolean bTestClass) {
        if (classType == null) {
            throw new NullPointerException("ClassType cannot be null");
        }
        this._strInnerClass = strInnerClass;
        this._strEnclosingType = strEnclosingType;
        this._bTestClass = bTestClass;
        int iLastDot = strEnclosingType.lastIndexOf(46);
        this._strNamespace = iLastDot > 0 ? StringPool.get((String)this._strEnclosingType.substring(0, iLastDot)) : "";
        this._strEnclosingType = this._strEnclosingType == null ? null : StringPool.get((String)this._strEnclosingType);
        this._classType = classType;
    }

    public ISource getSource() {
        IType myType;
        IFileRepositoryBasedType enclosingType = (IFileRepositoryBasedType)TypeSystem.getByFullNameIfValid((String)this._strEnclosingType);
        if (enclosingType == null && (myType = TypeSystem.getByFullNameIfValid((String)(this._strEnclosingType + "." + this._strInnerClass))) instanceof IGosuClass) {
            enclosingType = (IFileRepositoryBasedType)myType.getEnclosingType();
        }
        return enclosingType == null ? null : enclosingType.getSourceFileHandle().getSource();
    }

    public String getParentType() {
        return this._strEnclosingType;
    }

    public String getNamespace() {
        return this._strNamespace;
    }

    public String getFilePath() {
        IFileRepositoryBasedType enclosingType = (IFileRepositoryBasedType)TypeSystem.getByFullNameIfValid((String)this._strEnclosingType);
        return enclosingType == null ? null : enclosingType.getSourceFileHandle().getFilePath();
    }

    public IFile getFile() {
        IFileRepositoryBasedType enclosingType = (IFileRepositoryBasedType)TypeSystem.getByFullNameIfValid((String)this._strEnclosingType);
        return enclosingType.getSourceFileHandle().getFile();
    }

    public boolean isTestClass() {
        return this._bTestClass;
    }

    public boolean isValid() {
        IHasInnerClass enclosingType = (IHasInnerClass)TypeSystem.getByFullNameIfValid((String)this._strEnclosingType);
        return enclosingType != null && enclosingType.getInnerClass((CharSequence)this.getRelativeName()) != null;
    }

    public boolean isStandardPath() {
        IFileRepositoryBasedType enclosingType = (IFileRepositoryBasedType)TypeSystem.getByFullNameIfValid((String)this._strEnclosingType);
        return enclosingType.getSourceFileHandle().isStandardPath();
    }

    public boolean isIncludeModulePath() {
        IFileRepositoryBasedType enclosingType = (IFileRepositoryBasedType)TypeSystem.getByFullNameIfValid((String)this._strEnclosingType);
        return enclosingType.getSourceFileHandle().isIncludeModulePath();
    }

    public void cleanAfterCompile() {
    }

    public ClassType getClassType() {
        return this._classType;
    }

    public String getTypeNamespace() {
        return this._strEnclosingType;
    }

    public String getRelativeName() {
        return this._strInnerClass;
    }

    public void setOffset(int iOffset) {
        this._iOffset = iOffset;
    }

    public int getOffset() {
        return this._iOffset;
    }

    public void setEnd(int iEnd) {
        this._iEnd = iEnd;
    }

    public int getEnd() {
        return this._iEnd;
    }

    public String getFileName() {
        return null;
    }

    public int getMark() {
        return this._mark;
    }

    void setMark(int mark) {
        this._mark = mark;
    }
}

