/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.DynamicArray;
import gw.util.GosuClassUtil;
import gw.util.cache.StringPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class TypeUsesMap
implements ITypeUsesMap {
    private boolean _bSupportRelativePackageResolution;
    private HashMap<String, String> _specialTypeUsesByRelativeName = new HashMap();
    private HashMap<String, String> _typeUsesByRelativeName = new HashMap();
    private DynamicArray<String> _defaultNamespaces;
    private DynamicArray<String> _namespaces = new DynamicArray();
    private DynamicArray<String> _specialNamespaces;
    private DynamicArray<String> _featureSpaces = new DynamicArray();
    private DynamicArray<IFeatureInfo> _featureLiterals = new DynamicArray();
    private HashMap<String, IUsesStatement> _usesStmts = new HashMap();
    private boolean _locked = false;

    public TypeUsesMap(List<String> specialTypeUses) {
        this();
        for (String typeUse : specialTypeUses) {
            this.addToSpecialTypeUses(typeUse);
        }
    }

    public TypeUsesMap() {
        this._defaultNamespaces = new DynamicArray();
        this._specialNamespaces = new DynamicArray();
        this._defaultNamespaces.add((Object)"gw.lang.");
        this._defaultNamespaces.add((Object)"java.lang.");
        this._defaultNamespaces.add((Object)"java.util.");
        this._defaultNamespaces.add((Object)"dynamic.");
        this._defaultNamespaces.add((Object)"");
    }

    public ITypeUsesMap copy() {
        TypeUsesMap copy = new TypeUsesMap();
        copy._bSupportRelativePackageResolution = this._bSupportRelativePackageResolution;
        copy._specialTypeUsesByRelativeName = new HashMap<String, String>(this._specialTypeUsesByRelativeName);
        copy._defaultNamespaces = this._defaultNamespaces.copy();
        copy._specialNamespaces = this._specialNamespaces.copy();
        copy._typeUsesByRelativeName = new HashMap<String, String>(this._typeUsesByRelativeName);
        copy._namespaces = this._namespaces.copy();
        copy._featureSpaces = this._featureSpaces.copy();
        copy._featureLiterals = this._featureLiterals.copy();
        return copy;
    }

    public ITypeUsesMap copyLocalScope() {
        TypeUsesMap copy = new TypeUsesMap();
        copy._bSupportRelativePackageResolution = this._bSupportRelativePackageResolution;
        copy._specialTypeUsesByRelativeName = this._specialTypeUsesByRelativeName;
        copy._defaultNamespaces = this._defaultNamespaces.copy();
        copy._specialNamespaces = this._specialNamespaces.copy();
        copy._typeUsesByRelativeName = new HashMap<String, String>(this._typeUsesByRelativeName);
        copy._usesStmts = new HashMap<String, IUsesStatement>(this._usesStmts);
        copy._namespaces = this._namespaces.copy();
        copy._featureSpaces = this._featureSpaces.copy();
        copy._featureLiterals = this._featureLiterals.copy();
        return copy;
    }

    public ITypeUsesMap lock() {
        this._locked = true;
        return this;
    }

    public boolean containsType(String typeName) {
        for (String o : this.getTypeUses()) {
            String used = o;
            if (used.endsWith(".")) {
                if (used.lastIndexOf(46) != typeName.lastIndexOf(46)) continue;
                return typeName.startsWith(used);
            }
            if (!used.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getTypeUses() {
        Set<String> combined = this.getNamespaces();
        combined.addAll(this._specialTypeUsesByRelativeName.values());
        combined.addAll(this._typeUsesByRelativeName.values());
        return combined;
    }

    public Set<String> getNamespaces() {
        LinkedHashSet<String> combined = new LinkedHashSet<String>();
        combined.addAll((Collection<String>)this._namespaces);
        combined.addAll((Collection<String>)this._defaultNamespaces);
        combined.addAll((Collection<String>)this._specialNamespaces);
        return combined;
    }

    public Set<String> getFeatureSpaces() {
        LinkedHashSet<String> combined = new LinkedHashSet<String>();
        combined.addAll((Collection<String>)this._featureSpaces);
        return combined;
    }

    public Set<IFeatureInfo> getFeatureLiterals() {
        LinkedHashSet<IFeatureInfo> combined = new LinkedHashSet<IFeatureInfo>();
        combined.addAll((Collection<IFeatureInfo>)this._featureLiterals);
        return combined;
    }

    public void addToTypeUses(String strType) {
        this.checkLocked();
        if (strType != null) {
            strType = strType.replace('$', '.');
            try {
                this.addToTypeUses(strType, (Map<String, String>)this._typeUsesByRelativeName, (List<String>)this._namespaces);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addToFeatureSpaces(String strType) {
        String ns;
        this.checkLocked();
        if (strType != null && !this._featureSpaces.contains((Object)(ns = StringPool.get((String)(strType = strType.replace('$', '.')))))) {
            this._featureSpaces.add((Object)ns);
        }
    }

    public void addToFeatureLiterals(IFeatureInfo fi) {
        this.checkLocked();
        if (fi != null) {
            this._featureLiterals.add((Object)fi);
        }
    }

    public void addToTypeUses(IUsesStatement usesSmt) {
        String strType = usesSmt.getTypeName();
        if (usesSmt.isFeatureSpace()) {
            this.addToFeatureSpaces(strType);
        } else {
            IFeatureInfo fi = usesSmt.getFeatureInfo();
            if (fi != null) {
                this.addToFeatureLiterals(fi);
            } else {
                this.addToTypeUses(strType);
            }
        }
        this._usesStmts.put(StringPool.get((String)strType), usesSmt);
    }

    public Set<IUsesStatement> getUsesStatements() {
        return new HashSet<IUsesStatement>(this._usesStmts.values());
    }

    public void addToDefaultTypeUses(String strType) {
        this.checkLocked();
        if (strType.endsWith(".*")) {
            this._defaultNamespaces.add((Object)StringPool.get((String)strType.substring(0, strType.length() - 1)));
        } else {
            this._defaultNamespaces.add((Object)StringPool.get((String)strType));
        }
    }

    private void checkLocked() {
        if (this._locked) {
            throw new IllegalStateException("You cannot add to a locked TypeUsesMap.  You must make a copy of this map using the .copy() method in order to mutate it.");
        }
    }

    public void addToSpecialTypeUses(String strType) {
        this.checkLocked();
        strType = strType.replace('$', '.');
        try {
            this.addToTypeUses(strType, (Map<String, String>)this._specialTypeUsesByRelativeName, (List<String>)this._specialNamespaces);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public IType resolveType(String strRelativeName) {
        IType result = null;
        if (strRelativeName.indexOf(46) != -1) {
            result = TypeLoaderAccess.instance().getByFullNameIfValid(strRelativeName);
        }
        if (result == null && (result = this._specialTypeUsesByRelativeName.containsKey(strRelativeName) ? TypeLoaderAccess.instance().getByFullNameIfValid(this._specialTypeUsesByRelativeName.get(strRelativeName)) : (this._typeUsesByRelativeName.containsKey(strRelativeName) ? TypeLoaderAccess.instance().getByFullNameIfValid(this._typeUsesByRelativeName.get(strRelativeName)) : this.resolveTypesInAllNamespaces(strRelativeName))) == null) {
            result = TypeLoaderAccess.instance().getByFullNameIfValid(strRelativeName);
        }
        if (result == null) {
            result = this.resolveSubType(strRelativeName);
        }
        return result;
    }

    private IType resolveSubType(String strRelativeName) {
        int iDot = strRelativeName.lastIndexOf(46);
        if (iDot > 0 && strRelativeName.length() > iDot + 1) {
            String strPrefix = strRelativeName.substring(0, iDot);
            String strRemaining = strRelativeName.substring(iDot);
            IType enclosingType = this.resolveType(strPrefix);
            if (enclosingType != null) {
                return TypeLoaderAccess.instance().getByFullNameIfValid(enclosingType.getName() + strRemaining);
            }
        }
        return null;
    }

    public void clearNonDefaultTypeUses() {
        this._typeUsesByRelativeName.clear();
        this._namespaces.clear();
        this._featureSpaces.clear();
        this._featureLiterals.clear();
        this._usesStmts.clear();
    }

    private IType resolveTypesInAllNamespaces(String strRelativeName) {
        IType type;
        int i;
        if (strRelativeName.indexOf(46) < 0) {
            for (i = 0; i < this._specialNamespaces.size; ++i) {
                type = this.resolveType(strRelativeName, (String)this._specialNamespaces.data[i]);
                if (type == null) continue;
                return type;
            }
        }
        for (i = 0; i < this._namespaces.size; ++i) {
            type = this.resolveType(strRelativeName, (String)this._namespaces.data[i]);
            if (type == null) continue;
            return type;
        }
        for (i = 0; i < this._defaultNamespaces.size; ++i) {
            type = this.resolveType(strRelativeName, (String)this._defaultNamespaces.data[i]);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private IType resolveType(String strRelativeName, String strNs) {
        String strQualifiedName = strNs + strRelativeName;
        IType type = TypeLoaderAccess.instance().getByFullNameIfValid(strQualifiedName);
        if (type != null && !this.isSupportRelativePackageResolution()) {
            type = this.verifyTypeNameDoesNotHaveRelativePackage(type, strNs, strRelativeName);
        }
        return type;
    }

    private IType verifyTypeNameDoesNotHaveRelativePackage(IType type, String strNs, String strRelativeName) {
        StringTokenizer tokenizer;
        String ns = type.getNamespace();
        if (ns != null && ns.contains(strNs) && (tokenizer = new StringTokenizer(ns = ns.substring(strNs.length()), ".")).hasMoreTokens()) {
            String token = tokenizer.nextToken();
            StringTokenizer t2 = new StringTokenizer(strRelativeName, ".");
            while (t2.hasMoreTokens()) {
                String token2 = t2.nextToken();
                if (!token.equals(token2)) continue;
                return null;
            }
            return type;
        }
        return type;
    }

    public INamespaceType resolveRelativeNamespaceInAllNamespaces(String strRelativeName) {
        INamespaceType type;
        String strQualifiedName;
        int i;
        if (!this.isSupportRelativePackageResolution()) {
            return null;
        }
        for (i = 0; i < this._specialNamespaces.size; ++i) {
            strQualifiedName = this._specialNamespaces.data[i] + strRelativeName;
            type = TypeSystem.getNamespace((String)strQualifiedName);
            if (type == null) continue;
            return type;
        }
        for (i = 0; i < this._namespaces.size; ++i) {
            strQualifiedName = this._namespaces.data[i] + strRelativeName;
            type = TypeSystem.getNamespace((String)strQualifiedName);
            if (type == null) continue;
            return type;
        }
        for (i = 0; i < this._defaultNamespaces.size; ++i) {
            strQualifiedName = this._defaultNamespaces.data[i] + strRelativeName;
            type = TypeSystem.getNamespace((String)strQualifiedName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public boolean isSupportRelativePackageResolution() {
        return this._bSupportRelativePackageResolution;
    }

    public void setSupportRelativePackageResolution(boolean bSupportRelativePackageResolution) {
        this._bSupportRelativePackageResolution = bSupportRelativePackageResolution;
    }

    private void addToTypeUses(String strQualifiedType, Map<String, String> mapQualifiedNameByRelativeName, List<String> namespacesSet) throws ClassNotFoundException {
        this.checkLocked();
        if (strQualifiedType.endsWith(".*")) {
            String ns = StringPool.get((String)strQualifiedType.substring(0, strQualifiedType.length() - 1));
            if (!namespacesSet.contains(ns)) {
                namespacesSet.add(ns);
            }
        } else {
            String strRelativeName = GosuClassUtil.getNameNoPackage((String)strQualifiedType);
            strRelativeName = strRelativeName.replace('$', '.');
            mapQualifiedNameByRelativeName.put(StringPool.get((String)strRelativeName), strQualifiedType);
        }
    }
}

