/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuClassProxyFactory;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ReducedParameterizedDynamicFunctionSymbol;
import gw.internal.gosu.parser.expressions.IHasOperatorLineNumber;
import gw.lang.parser.IExpressionRuntime;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.MemberAccessKind;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.cache.StringPool;

public final class BeanMethodCallExpression
extends Expression
implements IBeanMethodCallExpression,
IHasOperatorLineNumber {
    private Expression _rootExpression;
    private IType[] _argTypes;
    private String _accessPath;
    private Expression[] _args;
    private IMethodInfo _md;
    private IFunctionType _funcType;
    private MemberAccessKind _kind;
    private int[] _namedArgOrder;
    private int _iArgPos;
    protected int _startOffset;
    private static final IType[] EMPTY_ARG_TYPES = new IType[0];
    private IExpressionRuntime _expressionRuntime;
    private int _opLineNum;

    public IFunctionType getFunctionType() {
        return this._funcType;
    }

    public void setFunctionType(IFunctionType funcType) {
        this._funcType = funcType;
    }

    public Expression getRootExpression() {
        return this._rootExpression;
    }

    public void setRootExpression(Expression rootExpression) {
        this._rootExpression = rootExpression;
    }

    public IType[] getArgTypes() {
        return this._argTypes;
    }

    public void setArgTypes(IType[] argTypes) {
        this._argTypes = argTypes.length == 0 ? EMPTY_ARG_TYPES : argTypes;
    }

    public String getMemberName() {
        return this._accessPath;
    }

    public void setAccessPath(String accessPath) {
        assert (accessPath != null);
        this._accessPath = StringPool.get((String)accessPath);
    }

    public String getAccessPath() {
        return this._accessPath;
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public void setExpressionRuntime(IExpressionRuntime expressionRuntime) {
        this._expressionRuntime = expressionRuntime;
    }

    public IPropertyInfo getPropertyInfo() {
        return null;
    }

    public IExpressionRuntime getExpressionRuntime() {
        return this._expressionRuntime;
    }

    public void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public Expression[] getArgs() {
        return this._args;
    }

    public void setArgs(Expression[] args) {
        this._args = args == null || args.length == 0 ? null : args;
    }

    public int[] getNamedArgOrder() {
        return this._namedArgOrder;
    }

    public void setNamedArgOrder(int[] namedArgOrder) {
        this._namedArgOrder = namedArgOrder;
    }

    public void setMethodDescriptor(IMethodInfo md) {
        this._md = md;
        if (md != null) {
            IJavaType type = JavaTypes.IGOSU_OBJECT();
            if (this._md.getOwnersType() == IGosuClassInternal.Util.getGosuClassFrom((IType)type)) {
                this._md = type.getTypeInfo().getMethod((CharSequence)this._md.getDisplayName(), ((FunctionType)((IGosuMethodInfo)this._md).getDfs().getType()).getParameterTypes());
            }
        }
    }

    public IMethodInfo getMethodDescriptor() {
        return this._md;
    }

    public IMethodInfo getGenericMethodDescriptor() {
        IReducedDynamicFunctionSymbol dfs;
        if (this._md instanceof GosuMethodInfo && (dfs = ((GosuMethodInfo)this._md).getDfs()) instanceof ReducedParameterizedDynamicFunctionSymbol) {
            return (IMethodInfo)((ReducedParameterizedDynamicFunctionSymbol)dfs).getBackingDfs().getMethodOrConstructorInfo();
        }
        return this._md;
    }

    public IType getRootType() {
        IType rootType = this.getRootExpression().getType();
        rootType = IGosuClass.ProxyUtil.isProxy((IType)rootType) && rootType instanceof IGosuClass ? ((IGosuClass)rootType).getJavaType() : rootType;
        return rootType;
    }

    public MemberAccessKind getMemberAccessKind() {
        return this._kind;
    }

    public void setMemberAccessKind(MemberAccessKind kind) {
        if (kind == MemberAccessKind.NORMAL && this._md != null && GosuClassProxyFactory.isPropertyGetter(this._md)) {
            kind = MemberAccessKind.NULL_SAFE;
        }
        this._kind = kind;
    }

    @Override
    public boolean isNullSafe() {
        return this.getMemberAccessKind() == MemberAccessKind.NULL_SAFE || this.isExpansion();
    }

    public boolean isExpansion() {
        return this._kind == MemberAccessKind.EXPANSION;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    public String toString() {
        Object strOut = this.getRootExpression().toString();
        if (this._accessPath != null) {
            strOut = (String)strOut + "." + this._accessPath;
        }
        strOut = (String)strOut + "(";
        if (this._args != null && this._args.length > 0) {
            strOut = (String)strOut + " ";
            for (int i = 0; i < this._args.length; ++i) {
                if (i != 0) {
                    strOut = (String)strOut + ", ";
                }
                strOut = (String)strOut + this._args[i].toString();
            }
            strOut = (String)strOut + " ";
        }
        strOut = (String)strOut + ")";
        return strOut;
    }

    public int getArgPosition() {
        return this._iArgPos;
    }

    public void setArgPosition(int iArgPos) {
        this._iArgPos = iArgPos;
    }

    @Override
    public int getOperatorLineNumber() {
        return this._opLineNum;
    }

    @Override
    public void setOperatorLineNumber(int operatorLineNumber) {
        this._opLineNum = operatorLineNumber;
    }
}

