/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.lang.IDimension;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;

public final class DimensionOperandResolver {
    private IType _numType;
    private IType _lhsType;
    private IType _rhsType;
    private Object _lhsValue;
    private Object _rhsValue;
    private IDimension _base;

    public static DimensionOperandResolver resolve(IType exprType, IType lhsType, Object lhsValue, IType rhsType, Object rhsValue) {
        return new DimensionOperandResolver(exprType, lhsType, lhsValue, rhsType, rhsValue).resolve();
    }

    private DimensionOperandResolver(IType exprType, IType lhsType, Object lhsValue, IType rhsType, Object rhsValue) {
        this._numType = exprType;
        this._lhsType = lhsType;
        this._lhsValue = lhsValue;
        this._rhsType = rhsType;
        this._rhsValue = rhsValue;
    }

    private DimensionOperandResolver resolve() {
        this.resolveNumberTypeAndValues();
        return this;
    }

    private void resolveNumberTypeAndValues() {
        if (this._lhsType == this._numType && JavaTypes.IDIMENSION().isAssignableFrom(this._lhsType)) {
            this._base = (IDimension)this._lhsValue;
            if (this._rhsType == this._numType) {
                this._rhsValue = ((IDimension)this._rhsValue).toNumber();
            }
            this._lhsValue = this._base.toNumber();
            this._numType = TypeSystem.get((Class)this._base.numberType());
        } else {
            this._base = (IDimension)this._rhsValue;
            this._rhsValue = this._base.toNumber();
            this._numType = TypeSystem.get((Class)this._base.numberType());
        }
    }

    public IDimension getBase() {
        return this._base;
    }

    public IType getRawNumberType() {
        return this._numType;
    }

    public Object getLhsValue() {
        return this._lhsValue;
    }

    public Object getRhsValue() {
        return this._rhsValue;
    }
}

