/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.RuntimeExceptionWithNoStacktrace;
import gw.internal.gosu.parser.expressions.IHasOperatorLineNumber;
import gw.internal.gosu.parser.optimizer.SinglePropertyMemberAccessRuntime;
import gw.lang.parser.IExpressionRuntime;
import gw.lang.parser.MemberAccessKind;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IFieldAccessExpression;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IPropertyInfoDelegate;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IProgramInstance;
import gw.lang.reflect.java.ICompileTimeConstantValue;
import gw.util.cache.StringPool;

public class MemberAccess
extends Expression
implements IFieldAccessExpression,
IHasOperatorLineNumber {
    private Expression _rootExpression;
    private String _strMemberName;
    private int _startOffset;
    private Expression _memberExpression;
    private IExpressionRuntime _expressionRuntime;
    private MemberAccessKind _kind;
    private int _opLineNum;

    public Expression getRootExpression() {
        return this._rootExpression;
    }

    public Object evaluateRootExpr() {
        IProgramInstance instance;
        try {
            instance = (IProgramInstance)this.getGosuProgram().getBackingClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return instance.evaluateRootExpr(null);
    }

    public void setRootExpression(Expression rootExpression) {
        this._rootExpression = rootExpression;
    }

    public String getMemberName() {
        return this._strMemberName;
    }

    public void setMemberName(String strMemberName) {
        assert (strMemberName != null);
        this._strMemberName = StringPool.get((String)strMemberName);
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public Expression getMemberExpression() {
        return this._memberExpression;
    }

    public void setMemberExpression(Expression memberExpression) {
        this._memberExpression = memberExpression;
    }

    public IType getRootType() {
        IType rootType = this.getRootExpression().getType();
        rootType = IGosuClass.ProxyUtil.isProxy((IType)rootType) && rootType instanceof IGosuClass ? ((IGosuClass)rootType).getJavaType() : rootType;
        return rootType;
    }

    public IType getAssignableType() {
        try {
            IPropertyInfo pi = this.getPropertyInfo();
            if (pi != null) {
                return pi.getAssignableFeatureType();
            }
        }
        catch (RuntimeExceptionWithNoStacktrace runtimeExceptionWithNoStacktrace) {
            // empty catch block
        }
        return this.getType();
    }

    public IPropertyInfo getPropertyInfo() {
        if (this._memberExpression != null || this._strMemberName == null) {
            return null;
        }
        try {
            return BeanAccess.getPropertyInfoDirectly(this.getRootType(), this._strMemberName);
        }
        catch (ParseException e) {
            throw new RuntimeExceptionWithNoStacktrace(e);
        }
    }

    public IPropertyInfo getPropertyInfoWithoutThrowing() {
        if (this._memberExpression != null || this._strMemberName == null) {
            return null;
        }
        return BeanAccess.getPropertyInfoDirectly_NoException(this.getRootType(), this._strMemberName);
    }

    @Override
    public boolean isCompileTimeConstant() {
        try {
            if (this.getRootExpression().isCompileTimeConstant()) {
                IPropertyInfo pi = this.getCompileTimePropertyInfo();
                if (pi == null) {
                    return false;
                }
                while (pi instanceof IPropertyInfoDelegate) {
                    pi = ((IPropertyInfoDelegate)pi).getSource();
                }
                if (pi.isStatic() && pi instanceof ICompileTimeConstantValue) {
                    return ((ICompileTimeConstantValue)pi).isCompileTimeConstantValue();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        IPropertyInfo pi = this.getCompileTimePropertyInfo();
        while (pi instanceof IPropertyInfoDelegate) {
            pi = ((IPropertyInfoDelegate)pi).getSource();
        }
        return ((ICompileTimeConstantValue)pi).doCompileTimeEvaluation();
    }

    public IPropertyInfo getCompileTimePropertyInfo() {
        if (this._memberExpression != null || this._strMemberName == null) {
            return null;
        }
        try {
            IType rootType = this.getRootType();
            if (rootType instanceof IMetaType) {
                rootType = ((IMetaType)rootType).getType();
            }
            return BeanAccess.getPropertyInfoDirectly(rootType, this._strMemberName);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setExpressionRuntime(IExpressionRuntime expressionRuntime) {
        this._expressionRuntime = expressionRuntime;
    }

    public IExpressionRuntime getExpressionRuntime() {
        if (this._expressionRuntime == null && SinglePropertyMemberAccessRuntime.isConvertible(this)) {
            this._expressionRuntime = new SinglePropertyMemberAccessRuntime(this);
        }
        return this._expressionRuntime;
    }

    public MemberAccessKind getMemberAccessKind() {
        return this._kind;
    }

    public void setMemberAccessKind(MemberAccessKind kind) {
        this._kind = kind;
    }

    @Override
    public boolean isNullSafe() {
        return this.getMemberAccessKind() == MemberAccessKind.NULL_SAFE;
    }

    @Override
    public String toString() {
        return this.getRootExpression().toString() + "." + this._strMemberName;
    }

    @Override
    public int getOperatorLineNumber() {
        return this._opLineNum;
    }

    @Override
    public void setOperatorLineNumber(int operatorLineNumber) {
        this._opLineNum = operatorLineNumber;
    }
}

