/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.internal.gosu.parser.expressions.DimensionOperandResolver;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.IDimension;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.expressions.IMultiplicativeExpression;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.math.MathContext;

public final class MultiplicativeExpression
extends ArithmeticExpression
implements IMultiplicativeExpression {
    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        return MultiplicativeExpression.evaluate(this.getType(), this.getLHS().evaluate(), this.getRHS().evaluate(), this.getLHS().getType(), this.getRHS().getType(), this.getOperator().charAt(0), false);
    }

    public static Object evaluate(IType type, Object lhsValue, Object rhsValue, IType lhsType, IType rhsType, int iOperator, boolean bNullSafe, Object ctx, int startLhs, int endLhs, int startRhs, int endRhs) {
        return MultiplicativeExpression.evaluate(type, lhsValue, rhsValue, lhsType, rhsType, iOperator, bNullSafe);
    }

    public static Object evaluate(IType type, Object lhsValue, Object rhsValue, IType lhsType, IType rhsType, int iOperator, boolean bNullSafe) {
        Object retValue;
        boolean bDynamic = false;
        if (lhsType instanceof IPlaceholder && ((IPlaceholder)lhsType).isPlaceholder()) {
            lhsType = TypeSystem.getFromObject((Object)lhsValue);
            bDynamic = true;
        }
        if (rhsType instanceof IPlaceholder && ((IPlaceholder)rhsType).isPlaceholder()) {
            rhsType = TypeSystem.getFromObject((Object)rhsValue);
            bDynamic = true;
        }
        if (bDynamic) {
            MultiplicativeExpression overrideMethod = new MultiplicativeExpression();
            type = ParserBase.resolveRuntimeType(overrideMethod, lhsType, iOperator, rhsType);
            IMethodInfo mi = overrideMethod.getOverride();
            if (mi != null) {
                return mi.getCallHandler().handleCall(lhsValue, ReflectUtil.coerceArgsIfNecessary((IParameterInfo[])mi.getParameters(), (Object[])new Object[]{rhsValue}));
            }
        }
        if (lhsValue == null) {
            if (bNullSafe) {
                return null;
            }
            throw new NullPointerException("left-hand operand was null");
        }
        if (rhsValue == null) {
            if (bNullSafe) {
                return null;
            }
            throw new NullPointerException("right-hand operand was null");
        }
        IDimension customNumberBase = null;
        if (JavaTypes.IDIMENSION().isAssignableFrom(type)) {
            DimensionOperandResolver customNumberResolver = DimensionOperandResolver.resolve(type, lhsType, lhsValue, rhsType, rhsValue);
            type = customNumberResolver.getRawNumberType();
            lhsValue = customNumberResolver.getLhsValue();
            rhsValue = customNumberResolver.getRhsValue();
            customNumberBase = customNumberResolver.getBase();
        }
        ICoercionManager cm = CommonServices.getCoercionManager();
        switch (iOperator) {
            case 42: {
                if (type == JavaTypes.RATIONAL()) {
                    retValue = cm.makeRationalFrom(lhsValue).multiply(cm.makeRationalFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.BIG_DECIMAL()) {
                    retValue = cm.makeBigDecimalFrom(lhsValue).multiply(cm.makeBigDecimalFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.BIG_INTEGER()) {
                    retValue = cm.makeBigIntegerFrom(lhsValue).multiply(cm.makeBigIntegerFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                    retValue = cm.makeIntegerFrom(lhsValue) * cm.makeIntegerFrom(rhsValue);
                    break;
                }
                if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                    retValue = MultiplicativeExpression.makeLong(cm.makeLongFrom(lhsValue) * cm.makeLongFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                    retValue = MultiplicativeExpression.makeDoubleValue(MultiplicativeExpression.makeDoubleValue(lhsValue) * MultiplicativeExpression.makeDoubleValue(rhsValue));
                    break;
                }
                if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                    retValue = Float.valueOf(MultiplicativeExpression.makeFloatValue(Float.valueOf(MultiplicativeExpression.makeFloatValue(lhsValue) * MultiplicativeExpression.makeFloatValue(rhsValue))));
                    break;
                }
                if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                    retValue = Integer.valueOf(cm.makeIntegerFrom(lhsValue) * cm.makeIntegerFrom(rhsValue)).shortValue();
                    break;
                }
                if (type == JavaTypes.BYTE() || type == JavaTypes.pBYTE()) {
                    retValue = (byte)(cm.makeIntegerFrom(lhsValue) * cm.makeIntegerFrom(rhsValue));
                    break;
                }
                throw new UnsupportedNumberTypeException(type);
            }
            case 47: {
                if (type == JavaTypes.RATIONAL()) {
                    retValue = cm.makeRationalFrom(lhsValue).divide(cm.makeRationalFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.BIG_DECIMAL()) {
                    retValue = cm.makeBigDecimalFrom(lhsValue).divide(cm.makeBigDecimalFrom(rhsValue), MathContext.DECIMAL128);
                    break;
                }
                if (type == JavaTypes.BIG_INTEGER()) {
                    retValue = cm.makeBigIntegerFrom(lhsValue).divide(cm.makeBigIntegerFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                    retValue = cm.makeIntegerFrom(lhsValue) / cm.makeIntegerFrom(rhsValue);
                    break;
                }
                if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                    retValue = MultiplicativeExpression.makeLong(cm.makeLongFrom(lhsValue) / cm.makeLongFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                    retValue = MultiplicativeExpression.makeDoubleValue(MultiplicativeExpression.makeDoubleValue(lhsValue) / MultiplicativeExpression.makeDoubleValue(rhsValue));
                    break;
                }
                if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                    retValue = Float.valueOf(MultiplicativeExpression.makeFloatValue(Float.valueOf(MultiplicativeExpression.makeFloatValue(lhsValue) / MultiplicativeExpression.makeFloatValue(rhsValue))));
                    break;
                }
                if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                    retValue = Integer.valueOf(cm.makeIntegerFrom(lhsValue) / cm.makeIntegerFrom(rhsValue)).shortValue();
                    break;
                }
                if (type == JavaTypes.BYTE() || type == JavaTypes.pBYTE()) {
                    retValue = (byte)(cm.makeIntegerFrom(lhsValue) / cm.makeIntegerFrom(rhsValue));
                    break;
                }
                throw new UnsupportedNumberTypeException(type);
            }
            case 37: {
                if (type == JavaTypes.RATIONAL()) {
                    retValue = cm.makeRationalFrom(lhsValue).modulo(cm.makeRationalFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.BIG_DECIMAL()) {
                    retValue = cm.makeBigDecimalFrom(lhsValue).remainder(cm.makeBigDecimalFrom(rhsValue), MathContext.DECIMAL128).abs();
                    break;
                }
                if (type == JavaTypes.BIG_INTEGER()) {
                    retValue = cm.makeBigIntegerFrom(lhsValue).mod(cm.makeBigIntegerFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                    retValue = cm.makeIntegerFrom(lhsValue) % cm.makeIntegerFrom(rhsValue);
                    break;
                }
                if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                    retValue = MultiplicativeExpression.makeLong(cm.makeLongFrom(lhsValue) % cm.makeLongFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                    retValue = MultiplicativeExpression.makeDoubleValue(MultiplicativeExpression.makeDoubleValue(lhsValue) % MultiplicativeExpression.makeDoubleValue(rhsValue));
                    break;
                }
                if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                    retValue = Float.valueOf(MultiplicativeExpression.makeFloatValue(Float.valueOf(MultiplicativeExpression.makeFloatValue(lhsValue) % MultiplicativeExpression.makeFloatValue(rhsValue))));
                    break;
                }
                if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                    retValue = Integer.valueOf(cm.makeIntegerFrom(lhsValue) % cm.makeIntegerFrom(rhsValue)).shortValue();
                    break;
                }
                if (type == JavaTypes.BYTE() || type == JavaTypes.pBYTE()) {
                    retValue = (byte)(cm.makeIntegerFrom(lhsValue) % cm.makeIntegerFrom(rhsValue));
                    break;
                }
                throw new UnsupportedNumberTypeException(type);
            }
            default: {
                retValue = null;
            }
        }
        if (retValue != null && customNumberBase != null) {
            retValue = customNumberBase.fromNumber((Number)retValue);
        }
        return retValue;
    }
}

