/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.ext.org.objectweb.asm.Type;
import gw.lang.ir.ConditionContext;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRConditionalAndExpression;
import gw.lang.ir.expression.IRConditionalOrExpression;
import gw.lang.ir.expression.IRNotExpression;
import gw.lang.ir.expression.IRTernaryExpression;
import gw.lang.ir.statement.IRForEachStatement;
import gw.lang.ir.statement.IRIfStatement;
import gw.lang.ir.statement.IRWhileStatement;

public class AbstractBytecodeCompiler {
    public static final Type OBJECT_TYPE = Type.getType(Object.class);

    public static int getIns(int opcode, IRType type) {
        if (opcode == 89) {
            return AbstractBytecodeCompiler.isWide(type) ? 92 : opcode;
        }
        if (opcode == 87) {
            return AbstractBytecodeCompiler.isWide(type) ? 88 : opcode;
        }
        switch (opcode) {
            case 21: 
            case 46: 
            case 54: 
            case 79: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 172: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Opcode: " + Integer.toHexString(opcode) + " is not handled");
            }
        }
        if (type.isByte()) {
            return Type.BYTE_TYPE.getOpcode(opcode);
        }
        if (type.isChar()) {
            return Type.CHAR_TYPE.getOpcode(opcode);
        }
        if (type.isShort()) {
            return Type.SHORT_TYPE.getOpcode(opcode);
        }
        if (type.isBoolean()) {
            return Type.BOOLEAN_TYPE.getOpcode(opcode);
        }
        if (type.isInt()) {
            return Type.INT_TYPE.getOpcode(opcode);
        }
        if (type.isLong()) {
            return Type.LONG_TYPE.getOpcode(opcode);
        }
        if (type.isFloat()) {
            return Type.FLOAT_TYPE.getOpcode(opcode);
        }
        if (type.isDouble()) {
            return Type.DOUBLE_TYPE.getOpcode(opcode);
        }
        return OBJECT_TYPE.getOpcode(opcode);
    }

    public static boolean isWide(IRType type) {
        return type.getName().equals("long") || type.getName().equals("double");
    }

    public static void compileConditionAssignment(IRExpression expression, MethodVisitor mv) {
        Label end = new Label();
        ConditionContext conditionContext = expression.getConditionContext();
        mv.visitJumpInsn(AbstractBytecodeCompiler.negateOpcode(conditionContext.getOperator()), conditionContext.generateFalseLabel());
        conditionContext.fixLabels(true, mv);
        mv.visitInsn(4);
        mv.visitJumpInsn(167, end);
        conditionContext.fixLabels(false, mv);
        mv.visitInsn(3);
        mv.visitLabel(end);
        conditionContext.clear();
    }

    public static boolean isNotPartOfBooleanExpr(IRExpression expression) {
        IRElement parent = expression.getParent();
        return !(parent instanceof IRConditionalAndExpression) && !(parent instanceof IRConditionalOrExpression) && (!(parent instanceof IRTernaryExpression) || ((IRTernaryExpression)parent).getTest() != expression) && !(parent instanceof IRIfStatement) && !(parent instanceof IRWhileStatement) && !(parent instanceof IRForEachStatement) && !(parent instanceof IRNotExpression);
    }

    protected static int negateOpcode(int op) {
        int ret = 0;
        switch (op) {
            case 165: {
                ret = 166;
                break;
            }
            case 166: {
                ret = 165;
                break;
            }
            case 153: {
                ret = 154;
                break;
            }
            case 154: {
                ret = 153;
                break;
            }
            case 159: {
                ret = 160;
                break;
            }
            case 160: {
                ret = 159;
                break;
            }
            case 198: {
                ret = 199;
                break;
            }
            case 199: {
                ret = 198;
                break;
            }
            case 155: {
                ret = 156;
                break;
            }
            case 156: {
                ret = 155;
                break;
            }
            case 158: {
                ret = 157;
                break;
            }
            case 157: {
                ret = 158;
                break;
            }
            case 164: {
                ret = 163;
                break;
            }
            case 163: {
                ret = 164;
                break;
            }
            case 161: {
                ret = 162;
                break;
            }
            case 162: {
                ret = 161;
            }
        }
        return ret;
    }
}

