/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.nodes;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IHasInnerClass;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IRMethodForConstructorSymbol
implements IRMethod {
    private IType _gosuClass;
    private DynamicFunctionSymbol _dfs;
    private int _numberOfTypeParameters;

    public IRMethodForConstructorSymbol(IType gosuClass, DynamicFunctionSymbol dfs, int numberOfTypeParameters) {
        this._gosuClass = gosuClass;
        this._dfs = dfs;
        this._numberOfTypeParameters = numberOfTypeParameters;
    }

    @Override
    public IRType getReturnType() {
        return IRTypeConstants.pVOID();
    }

    @Override
    public List<IRType> getExplicitParameterTypes() {
        ArrayList<IRType> explicitParameterTypes = new ArrayList<IRType>();
        for (IType declaredParam : this._dfs.getArgTypes()) {
            explicitParameterTypes.add(IRTypeResolver.getDescriptor(declaredParam));
        }
        return explicitParameterTypes;
    }

    @Override
    public List<IRType> getAllParameterTypes() {
        return this.getConstructorParamTypes(this._dfs.getArgTypes(), this._numberOfTypeParameters, this._gosuClass);
    }

    @Override
    public String getName() {
        return "<init>";
    }

    @Override
    public IRType getOwningIRType() {
        return IRTypeResolver.getDescriptor(this._gosuClass);
    }

    @Override
    public IType getOwningIType() {
        return this._gosuClass;
    }

    @Override
    public IRelativeTypeInfo.Accessibility getAccessibility() {
        return AccessibilityUtil.forSymbol(this._dfs);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public IRType getTargetRootIRType() {
        return this.getOwningIRType();
    }

    @Override
    public IGenericTypeVariable[] getTypeVariables() {
        return null;
    }

    @Override
    public IFunctionType getFunctionType() {
        return (IFunctionType)this._dfs.getType();
    }

    @Override
    public boolean isGeneratedEnumMethod() {
        return false;
    }

    @Override
    public boolean isBytecodeMethod() {
        return true;
    }

    protected List<IRType> getConstructorParamTypes(IType[] declaredParams, int iTypeParams, IType type) {
        Map<String, ICapturedSymbol> capturedSymbols;
        ArrayList<IRType> params = new ArrayList<IRType>();
        if (this.isNonStaticInnerClass(type)) {
            params.add(IRTypeResolver.getDescriptor(this.getRuntimeEnclosingType(type)));
        }
        if (type instanceof IGosuClassInternal && type.isValid() && (capturedSymbols = ((IGosuClassInternal)type).getCapturedSymbols()) != null) {
            for (ICapturedSymbol sym : capturedSymbols.values()) {
                params.add(IRTypeResolver.getDescriptor(sym.getType().getArrayType()));
            }
        }
        if (AbstractElementTransformer.requiresExternalSymbolCapture(type)) {
            params.add(IRTypeResolver.getDescriptor(IExternalSymbolMap.class));
        }
        if (iTypeParams > 0) {
            for (int i = 0; i < iTypeParams; ++i) {
                params.add(IRTypeResolver.getDescriptor(LazyTypeResolver.class));
            }
        }
        if (type.isEnum()) {
            params.add(IRTypeConstants.STRING());
            params.add(IRTypeConstants.pINT());
        }
        for (IType declaredParam : declaredParams) {
            params.add(IRTypeResolver.getDescriptor(declaredParam));
        }
        return params;
    }

    public IType getRuntimeEnclosingType(IType type) {
        IType enclosingType = this.maybeUnwrapProxy(type.getEnclosingType());
        if (enclosingType instanceof IGosuEnhancement) {
            IGosuEnhancement enhancement = (IGosuEnhancement)enclosingType;
            enclosingType = enhancement.getEnhancedType();
        }
        return enclosingType;
    }

    private IType maybeUnwrapProxy(IType type) {
        if (type != null && type.isParameterizedType()) {
            type = type.getGenericType();
        }
        return type == null ? null : IGosuClass.ProxyUtil.getProxiedType((IType)type);
    }

    public boolean isNonStaticInnerClass(IType type) {
        return type instanceof IHasInnerClass && type.getEnclosingType() != null && !Modifier.isStatic((int)type.getModifiers());
    }

    @Override
    public boolean couldHaveTypeVariables() {
        return true;
    }
}

