/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.IRMethodFromMethodInfo;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.IdentifierTransformer;
import gw.internal.gosu.ir.transform.expression.TemplateStringLiteralTransformer;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.InitConstructorFunctionSymbol;
import gw.internal.gosu.parser.SuperConstructorFunctionSymbol;
import gw.internal.gosu.parser.ThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.MethodCallExpression;
import gw.internal.gosu.parser.statements.BeanMethodCallStatement;
import gw.internal.gosu.template.TemplateGenerator;
import gw.lang.function.IBlock;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.ILockedDownSymbol;
import gw.lang.parser.ISymbol;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.java.JavaTypes;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodCallExpressionTransformer
extends AbstractExpressionTransformer<MethodCallExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, MethodCallExpression expr) {
        MethodCallExpressionTransformer compiler = new MethodCallExpressionTransformer(cc, expr);
        return compiler.compile();
    }

    private MethodCallExpressionTransformer(TopLevelTransformationContext cc, MethodCallExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IFunctionSymbol symbol = ((MethodCallExpression)this._expr()).getFunctionSymbol();
        if (symbol instanceof ILockedDownSymbol) {
            return this.callGlobalStaticFunction(symbol);
        }
        if (this._cc().isExternalSymbol(symbol.getName())) {
            return this.callExternalProgramSymbol(symbol);
        }
        if (symbol instanceof DynamicFunctionSymbol) {
            return this.callDynamicFunctionSymbol(symbol);
        }
        if (symbol.getType() instanceof IPlaceholder && ((IPlaceholder)symbol.getType()).isPlaceholder()) {
            return this.callBlockViaDynamicType(symbol);
        }
        throw new UnsupportedOperationException("Don't know how to compile symbol: " + symbol.getType());
    }

    private IRExpression callBlockViaDynamicType(IFunctionSymbol symbol) {
        if (!(symbol.getType() instanceof IPlaceholder)) {
            throw new IllegalArgumentException("Expecting symbol to have dynamic type");
        }
        Identifier identifier = new Identifier();
        identifier.setSymbol((ISymbol)symbol, symbol.getDynamicSymbolTable());
        IRExpression idExpr = IdentifierTransformer.compile(this._cc(), identifier);
        idExpr = this.buildCast(JavaClassIRType.get(IBlock.class), idExpr);
        ArrayList<IRExpression> irArgs = new ArrayList<IRExpression>();
        this.pushArgumentsNoCasting(null, ((MethodCallExpression)this._expr()).getArgs(), irArgs);
        IRExpression objArray = this.collectArgsIntoObjArray(irArgs);
        return this.callMethod(IBlock.class, "invokeWithArgs", new Class[]{Object[].class}, idExpr, Collections.singletonList(objArray));
    }

    private IRExpression callExternalProgramSymbol(IFunctionSymbol symbol) {
        ArrayList<IRExpression> argValues = new ArrayList<IRExpression>();
        Expression[] args = ((MethodCallExpression)this._expr()).getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Expression arg = args[i];
                IRExpression irArg = ExpressionTransformer.compile(arg, this._cc());
                if (arg.getType().isPrimitive()) {
                    irArg = this.boxValue(arg.getType(), irArg);
                }
                argValues.add(irArg);
            }
        }
        IRExpression methodCall = this.callMethod(IExternalSymbolMap.class, "invoke", new Class[]{String.class, Object[].class}, this.pushExternalSymbolsMap(), MethodCallExpressionTransformer.exprList(this.pushConstant(symbol.getName()), this.buildInitializedArray(IRTypeConstants.OBJECT(), argValues)));
        IType returnType = ((IFunctionType)symbol.getType()).getReturnType();
        if (returnType != JavaTypes.pVOID()) {
            return this.unboxValueToType(returnType, methodCall);
        }
        return methodCall;
    }

    private IRExpression callDynamicFunctionSymbol(IFunctionSymbol symbol) {
        IRExpression result;
        DynamicFunctionSymbol dfs = (DynamicFunctionSymbol)symbol;
        if (dfs instanceof ThisConstructorFunctionSymbol || dfs instanceof SuperConstructorFunctionSymbol || dfs instanceof InitConstructorFunctionSymbol) {
            result = this.callSuperOrThisConstructorSymbol(dfs, dfs instanceof SuperConstructorFunctionSymbol || dfs instanceof InitConstructorFunctionSymbol, dfs instanceof ThisConstructorFunctionSymbol && ((ThisConstructorFunctionSymbol)dfs).isGenericJavaInterop());
        } else {
            IRExpression root;
            boolean isOnThis = false;
            if (dfs.isStatic()) {
                root = null;
            } else if (this.isMemberOnEnhancementOfEnclosingType(dfs)) {
                root = this.pushOuter(((IGosuEnhancement)dfs.getGosuClass()).getEnhancedType());
            } else if (this.isMemberOnEnclosingType(dfs) != null) {
                root = this.pushOuter((IType)dfs.getGosuClass());
            } else {
                root = this.pushThis();
                isOnThis = true;
            }
            IAttributedFeatureInfo methodOrConstructorInfo = dfs.getMethodOrConstructorInfo();
            if (methodOrConstructorInfo instanceof IMethodInfo) {
                IRMethodFromMethodInfo mi = IRMethodFactory.createIRMethod((IMethodInfo)methodOrConstructorInfo, ((MethodCallExpression)this._expr()).getFunctionType());
                result = isOnThis && mi.getAccessibility() == IRelativeTypeInfo.Accessibility.PRIVATE ? this.callMethod(mi, root, this.pushArguments(mi), ((MethodCallExpression)this._expr()).getNamedArgOrder(), true) : this.callMethod(mi, root, this.pushArguments(mi), ((MethodCallExpression)this._expr()).getNamedArgOrder());
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.castIfReturnTypeDerivedFromTypeVariable(dfs, result);
    }

    private IRExpression callSuperOrThisConstructorSymbol(DynamicFunctionSymbol dfs, boolean bSuper, boolean genericJavaInterop) {
        ICompilableTypeInternal targetType;
        ArrayList<IRStatement> bonusStatements = new ArrayList<IRStatement>();
        this._cc().maybeAssignOuterRef(bonusStatements);
        ArrayList<IRExpression> implicitArgs = new ArrayList<IRExpression>();
        this._cc().markInvokingSuper();
        if (bSuper) {
            this._cc().maybePushSupersEnclosingThisRef(implicitArgs);
            targetType = this._cc().getSuperType();
        } else {
            if (this._cc().isNonStaticInnerClass()) {
                implicitArgs.add((IRExpression)this.identifier(this._cc().getSymbol(this._cc().getOuterThisParamName())));
            }
            targetType = this.getGosuClass();
        }
        this.pushCapturedSymbols(this._cc().getSuperType(), implicitArgs, true);
        if (bSuper && MethodCallExpressionTransformer.requiresExternalSymbolCapture(this._cc().getSuperType()) || !bSuper && MethodCallExpressionTransformer.requiresExternalSymbolCapture((IType)this.getGosuClass())) {
            implicitArgs.add((IRExpression)this.identifier(this._cc().getSymbol("$symbols$arg")));
        }
        int iTypeParams = this.pushTypeParametersForConstructor((IExpression)this._expr(), (IType)targetType, (List<IRExpression>)implicitArgs, bSuper, genericJavaInterop);
        this.pushEnumSuperConstructorArguments(implicitArgs);
        IRMethod irMethod = IRMethodFactory.createConstructorIRMethod((IType)targetType, dfs, iTypeParams);
        List<IRExpression> explicitArgs = this.pushArguments(irMethod);
        IRExpression methodCall = this.callSpecialMethod(MethodCallExpressionTransformer.getDescriptor((IType)targetType), irMethod, this.pushThis(), implicitArgs, explicitArgs, ((MethodCallExpression)this._expr()).getNamedArgOrder());
        this._cc().markSuperInvoked();
        Object result = bonusStatements.isEmpty() ? methodCall : this.buildComposite(new IRElement[]{(IRElement)bonusStatements.get(0), methodCall});
        return result;
    }

    private IRExpression callGlobalStaticFunction(IFunctionSymbol symbol) {
        IRSymbol currentTemplate = TemplateStringLiteralTransformer.getCurrentTemplateSymbol();
        if (currentTemplate != null && symbol == TemplateGenerator.PRINT_CONTENT_SYMBOL.get()) {
            return this.callMethod(StringBuilder.class, "append", new Class[]{Object.class}, (IRExpression)this.identifier(currentTemplate), MethodCallExpressionTransformer.exprList(ExpressionTransformer.compile(((MethodCallExpression)this._expr()).getArgs()[0], this._cc())));
        }
        IRMethod method = IRMethodFactory.createIRMethod((Method)symbol.getValue());
        return this.callMethod(method, null, this.pushArguments(method));
    }

    private IRExpression castIfReturnTypeDerivedFromTypeVariable(DynamicFunctionSymbol dfs, IRExpression root) {
        IAttributedFeatureInfo methodOrConstructorInfo;
        IType retType;
        if (!(((MethodCallExpression)this._expr()).getParent() instanceof BeanMethodCallStatement) && (retType = ((MethodCallExpression)this._expr()).getReturnType()) != JavaTypes.pVOID() && !retType.isPrimitive() && (methodOrConstructorInfo = dfs.getMethodOrConstructorInfo()) instanceof IMethodInfo) {
            IMethodInfo mi = (IMethodInfo)methodOrConstructorInfo;
            IRMethodFromMethodInfo irMethod = IRMethodFactory.createIRMethod(mi, null);
            if (!MethodCallExpressionTransformer.getDescriptor(retType).isAssignableFrom(irMethod.getReturnType())) {
                return this.checkCast(retType, root);
            }
        }
        return root;
    }

    private List<IRExpression> pushArguments(IRMethod irMethod) {
        ArrayList<IRExpression> irArgs = new ArrayList<IRExpression>();
        Expression[] args = ((MethodCallExpression)this._expr()).getArgs();
        if (args != null) {
            List<IRType> explicitParamTypes = irMethod.getExplicitParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                Expression arg = args[i];
                IRExpression irArg = ExpressionTransformer.compile(arg, this._cc());
                IRType paramClass = explicitParamTypes.get(i);
                if (!paramClass.isAssignableFrom(irArg.getType())) {
                    irArg = this.buildCast(paramClass, irArg);
                }
                irArgs.add(irArg);
            }
        }
        return irArgs;
    }
}

