/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.parser.DynamicSymbol;
import gw.internal.gosu.parser.Symbol;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.parser.IExpression;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IType;
import java.util.Collections;

public class VarStatementTransformer
extends AbstractStatementTransformer<IVarStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, IVarStatement stmt) {
        VarStatementTransformer compiler = new VarStatementTransformer(cc, stmt);
        return compiler.compile();
    }

    private VarStatementTransformer(TopLevelTransformationContext cc, IVarStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        IRType symbolType;
        IExpression asExp = ((IVarStatement)this._stmt()).getAsExpression();
        Symbol symbol = (Symbol)((IVarStatement)this._stmt()).getSymbol();
        IType type = symbol.getType();
        if (type instanceof IBlockType && symbol.isValueBoxed() && !this.isProgramVar(symbol) && ((IVarStatement)this._stmt()).getAsExpression() != null) {
            return this.compilePossibleForwardRefBlockLocalVar();
        }
        IRExpression value = null;
        if (asExp != null) {
            value = ExpressionTransformer.compile(asExp, this._cc());
            symbolType = VarStatementTransformer.getDescriptor(type);
            if (!(value instanceof IRNullLiteral || symbolType.isAssignableFrom(value.getType()) || symbolType == JavaClassIRType.get(Character.TYPE) && value.getType() == JavaClassIRType.get(Integer.TYPE))) {
                value = this.buildCast(symbolType, value);
            }
        } else {
            value = this.getDefaultConstIns(type);
        }
        if (symbol.isValueBoxed() && value != null) {
            value = this.buildInitializedArray(VarStatementTransformer.getDescriptor(type), Collections.singletonList(value));
            symbolType = VarStatementTransformer.getDescriptor(symbol.getType()).getArrayType();
        } else {
            symbolType = VarStatementTransformer.getDescriptor(symbol.getType());
        }
        Object assignmentStmt = this.isProgramVar(symbol) ? this.setInstanceField((IType)this.getGosuClass(), symbol.getName(), VarStatementTransformer.getDescriptor(symbol.getType()), AccessibilityUtil.forSymbol((IReducedSymbol)symbol), this.pushThis(), value) : this.buildAssignment(this._cc().createSymbol(symbol.getName(), symbolType), value);
        assignmentStmt.setImplicit(asExp == null);
        return assignmentStmt;
    }

    private IRStatement compilePossibleForwardRefBlockLocalVar() {
        Symbol symbol = (Symbol)((IVarStatement)this._stmt()).getSymbol();
        IType type = symbol.getType();
        IRType symbolType = VarStatementTransformer.getDescriptor(symbol.getType()).getArrayType();
        IRSymbol irSymbol = this._cc().createSymbol(symbol.getName(), symbolType);
        IRAssignmentStatement initializer = this.buildAssignment(irSymbol, this.buildInitializedArray(VarStatementTransformer.getDescriptor(type), Collections.singletonList(this.pushNull())));
        IExpression asExp = ((IVarStatement)this._stmt()).getAsExpression();
        IRExpression value = ExpressionTransformer.compile(asExp, this._cc());
        IRType irSymbolType = VarStatementTransformer.getDescriptor(type);
        if (!(value instanceof IRNullLiteral || irSymbolType.isAssignableFrom(value.getType()) || irSymbolType == JavaClassIRType.get(Character.TYPE) && value.getType() == JavaClassIRType.get(Integer.TYPE))) {
            value = this.buildCast(irSymbolType, value);
        }
        return new IRStatementList(false, new IRStatement[]{initializer, this.buildArrayStore((IRExpression)this.identifier(irSymbol), this.pushConstant(0), value, symbolType.getComponentType())});
    }

    private boolean isProgramVar(Symbol symbol) {
        return this._cc().compilingProgram() && symbol instanceof DynamicSymbol;
    }
}

