/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.util.concurrent.LockingLazyVar;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import manifold.util.ReflectUtil;

public class JavaMethodCache {
    private static final Map<Class, Method[]> DECLARED_METHOD_CACHE = new ConcurrentHashMap<Class, Method[]>(100);
    private static LockingLazyVar<DeclaredMethodsAccessor> _declaredMethodsAccessor = new LockingLazyVar<DeclaredMethodsAccessor>(){

        protected DeclaredMethodsAccessor init() {
            try {
                Method method = Class.class.getDeclaredMethod("privateGetDeclaredMethods", Boolean.TYPE);
                return new PrivateGetDeclaredMethodsAccessor(method);
            }
            catch (Exception e) {
                return new PublicGetDeclaredMethodsAccessor();
            }
        }
    };

    public static void flushCaches() {
        DECLARED_METHOD_CACHE.clear();
    }

    public static Method[] getDeclaredMethods(Class clz) {
        Method[] result = DECLARED_METHOD_CACHE.get(clz);
        if (result != null) {
            return result;
        }
        result = ((DeclaredMethodsAccessor)_declaredMethodsAccessor.get()).getDeclaredMethods(clz);
        Arrays.sort(result, (o1, o2) -> {
            boolean b2;
            boolean b1;
            int res = o1.getName().compareTo(o2.getName());
            if (res == 0 && (b1 = o1.isBridge()) != (b2 = o2.isBridge())) {
                res = b1 ? 1 : -1;
            }
            return res;
        });
        DECLARED_METHOD_CACHE.put(clz, result);
        return result;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static class PublicGetDeclaredMethodsAccessor
    implements DeclaredMethodsAccessor {
        @Override
        public Method[] getDeclaredMethods(Class clz) {
            return clz.getDeclaredMethods();
        }
    }

    private static class PrivateGetDeclaredMethodsAccessor
    implements DeclaredMethodsAccessor {
        private final Method _method;

        public PrivateGetDeclaredMethodsAccessor(Method method) {
            this._method = method;
            ReflectUtil.setAccessible((Method)this._method);
        }

        @Override
        public Method[] getDeclaredMethods(Class clz) {
            try {
                Method[] result = (Method[])this._method.invoke((Object)clz, false);
                Method[] copy = new Method[result.length];
                System.arraycopy(result, 0, copy, 0, copy.length);
                return copy;
            }
            catch (Exception e) {
                System.err.println("WARNING Cannot load methods of " + clz.getName() + ": " + JavaMethodCache.getRootCause(e).toString());
                return new Method[0];
            }
        }
    }

    private static interface DeclaredMethodsAccessor {
        public Method[] getDeclaredMethods(Class var1);
    }
}

