/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.CapturedSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.DynamicSymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.java.classinfo.CompileTimeExpressionParser;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IPropertyInfoDelegate;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.java.ICompileTimeConstantValue;
import java.lang.reflect.Method;

public class Identifier
extends Expression
implements IIdentifierExpression {
    private ISymbol _symbol;

    public ISymbol getSymbol() {
        return this._symbol;
    }

    public void setSymbol(ISymbol symbol, ISymbolTable symTable) {
        this._symbol = symbol.getLightWeightReference();
        if (this._symbol.hasDynamicSymbolTable()) {
            this._symbol.setDynamicSymbolTable(symTable);
        }
    }

    public IType getAssignableType() {
        ISymbol symbol = this.getSymbol();
        return symbol instanceof DynamicPropertySymbol ? ((DynamicPropertySymbol)symbol).getAssignableType() : this.getType();
    }

    @Override
    public boolean isCompileTimeConstant() {
        ISymbol symbol = this.getSymbol();
        return !(symbol instanceof DynamicSymbol) && !(symbol instanceof DynamicPropertySymbol) && !symbol.isLocal() || this.isStaticFinalInitializedCompileTimeConstant();
    }

    public boolean isStaticFinalInitializedCompileTimeConstant() {
        ISymbol symbol = this.getSymbol();
        if (symbol instanceof DynamicSymbol && symbol.isStatic() && symbol.isFinal()) {
            IGosuClassInternal gsClass = (IGosuClassInternal)symbol.getGosuClass();
            if (!gsClass.isValid()) {
                return false;
            }
            VarStatement varStmt = gsClass.getStaticField(symbol.getName());
            if (varStmt != null && varStmt.getAsExpression() != null) {
                return varStmt.getAsExpression().isCompileTimeConstant() || Modifier.isEnum((int)varStmt.getModifiers());
            }
        }
        return false;
    }

    @Override
    public Object evaluate() {
        ISymbol symbol = this.getSymbol();
        if (this.isCompileTimeConstant() && symbol instanceof DynamicSymbol) {
            IGosuClassInternal gsClass = (IGosuClassInternal)symbol.getGosuClass();
            gsClass.isValid();
            VarStatement varStmt = gsClass.getStaticField(symbol.getName());
            if (varStmt != null) {
                if (Modifier.isEnum((int)varStmt.getModifiers())) {
                    return varStmt.getIdentifierName();
                }
                return varStmt.getAsExpression().evaluate();
            }
            throw new IllegalStateException("Should have found field for: " + symbol.getName());
        }
        IType type = symbol.getType();
        Object value = symbol.getValue();
        if (type instanceof IFunctionType) {
            if (value instanceof Symbol) {
                return value;
            }
            if (value instanceof Method || value instanceof IParsedElement) {
                return symbol;
            }
        }
        if (symbol instanceof DynamicPropertySymbol) {
            DynamicPropertySymbol dps = (DynamicPropertySymbol)symbol;
            IPropertyInfo pi = dps.getPropertyInfo();
            while (pi instanceof IPropertyInfoDelegate) {
                pi = ((IPropertyInfoDelegate)pi).getSource();
            }
            return ((ICompileTimeConstantValue)pi).doCompileTimeEvaluation();
        }
        if (symbol instanceof CompileTimeExpressionParser.CompileTimeFieldSymbol) {
            return ((ICompileTimeConstantValue)symbol).doCompileTimeEvaluation();
        }
        return value;
    }

    @Override
    public String toString() {
        return this.getSymbol().getName();
    }

    public boolean isLocalVariable() {
        ISymbol symbol = this.getSymbol();
        while (symbol instanceof CapturedSymbol) {
            symbol = ((CapturedSymbol)symbol).getReferredSymbol();
        }
        return !(symbol instanceof DynamicSymbol) && !(symbol instanceof CapturedSymbol) && symbol.getIndex() >= 0;
    }
}

