/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.expressions.Literal;
import gw.internal.gosu.util.StringPool;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.expressions.IStringLiteralExpression;

public class StringLiteral
extends Literal
implements IStringLiteralExpression {
    protected String _strValue;

    public StringLiteral(String strValue) {
        this._strValue = StringPool.get((String)strValue);
        this.setType(GosuParserTypes.STRING_TYPE());
    }

    public String getValue() {
        return this._strValue;
    }

    @Override
    public boolean isCompileTimeConstant() {
        return true;
    }

    @Override
    public Object evaluate() {
        return this.getValue();
    }

    @Override
    public String toString() {
        return "\"" + this.escapeQuotes() + "\"";
    }

    private String escapeQuotes() {
        String strValue = this.getValue();
        if (strValue != null) {
            strValue = strValue.replace("\"", "\\\"");
        }
        return strValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)o;
        return !(this._strValue == null ? that._strValue != null : !this._strValue.equals(that._strValue));
    }

    public int hashCode() {
        return this._strValue != null ? this._strValue.hashCode() : 0;
    }
}

