/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import gw.internal.gosu.parser.AsmMethodJavaClassMethod;
import gw.internal.gosu.parser.MethodJavaClassMethod;
import gw.internal.gosu.parser.java.classinfo.CompileTimeExpressionParser;
import gw.internal.gosu.parser.java.classinfo.JavaSourceClass;
import gw.internal.gosu.parser.java.classinfo.JavaSourceDefaultValue;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.lang.parser.IExpression;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.ITypeInfoResolver;
import gw.lang.reflect.module.IModule;
import gw.util.Array;
import java.util.List;

public class JavaSourceAnnotationInfo
implements IAnnotationInfo {
    private AnnotationTree _annotationTree;
    private IJavaAnnotatedElement _owner;
    private IModule _gosuModule;
    private String _name;
    private IJavaClassInfo _type;

    public JavaSourceAnnotationInfo(AnnotationTree annotationTree, IJavaAnnotatedElement owner) {
        this._annotationTree = annotationTree;
        this._owner = owner;
        this._gosuModule = this._owner instanceof IJavaClassInfo ? ((IJavaClassInfo)this._owner).getModule() : this._owner.getEnclosingClass().getModule();
    }

    public IType getType() {
        return TypeSystem.getByFullNameIfValid((String)this.getName(), (IModule)this._gosuModule);
    }

    public Object getInstance() {
        throw new RuntimeException("Not supported for source types");
    }

    public Object getFieldValue(String fieldName) {
        this.initNameAndType();
        try {
            IJavaClassMethod method = this._type.getMethod(fieldName, new IJavaClassInfo[0]);
            return this.parseValue(method);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Object parseValue(IJavaClassMethod method) {
        ExpressionTree valueTree = null;
        List<? extends ExpressionTree> arguments = this._annotationTree.getArguments();
        if (!arguments.isEmpty()) {
            for (ExpressionTree expressionTree : arguments) {
                String id;
                if (!(expressionTree instanceof AssignmentTree) || !(id = ((AssignmentTree)expressionTree).getVariable().toString()).equals(method.getName())) continue;
                valueTree = ((AssignmentTree)expressionTree).getExpression();
                break;
            }
            if (valueTree == null && "value".equals(method.getName())) {
                valueTree = arguments.get(0);
            }
        }
        if (valueTree == null) {
            Object defaultValue = method.getDefaultValue();
            if (method instanceof MethodJavaClassMethod || method instanceof AsmMethodJavaClassMethod) {
                if (defaultValue.getClass().isArray()) {
                    String[] stringArray = new String[Array.getLength((Object)defaultValue)];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = Array.get((Object)defaultValue, (int)i).toString();
                    }
                    return stringArray;
                }
                return defaultValue;
            }
            return ((JavaSourceDefaultValue)defaultValue).evaluate();
        }
        return this.evaluate(method.getReturnClassInfo(), valueTree);
    }

    private Object evaluate(IJavaClassInfo type, ExpressionTree valueTree) {
        if (valueTree instanceof AnnotationTree) {
            return new JavaSourceAnnotationInfo((AnnotationTree)valueTree, this._owner);
        }
        if (valueTree instanceof NewArrayTree) {
            List<? extends ExpressionTree> initializers = ((NewArrayTree)valueTree).getInitializers();
            Object[] arrayResult = null;
            int i = 0;
            for (ExpressionTree expressionTree : initializers) {
                Object value = this.evaluate(type.getComponentType(), expressionTree);
                if (arrayResult == null) {
                    arrayResult = (Object[])Array.newInstance(value.getClass(), (int)initializers.size());
                }
                arrayResult[i++] = value;
            }
            return arrayResult;
        }
        String text = valueTree.toString();
        if (type.isEnum()) {
            return this.parseEnum(text, type);
        }
        JavaSourceType enclosingType = this.getEnclosingType(this._owner);
        IExpression pr = CompileTimeExpressionParser.parse(text, (IJavaClassInfo)enclosingType, this.handleSingleElementArrayType(text, type));
        try {
            return pr.evaluate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private IType handleSingleElementArrayType(String text, IJavaClassInfo type) {
        IType javaType = type.getJavaType();
        if (!javaType.isArray()) {
            return javaType;
        }
        if (text.startsWith("{")) {
            return javaType;
        }
        return javaType.getComponentType();
    }

    private JavaSourceType getEnclosingType(IJavaAnnotatedElement owner) {
        if (owner instanceof JavaSourceType) {
            return (JavaSourceType)owner;
        }
        return (JavaSourceType)owner.getEnclosingClass();
    }

    private Object parseEnum(String text, IJavaClassInfo type) {
        IJavaClassField[] fields;
        String enumConstName = text.substring(text.lastIndexOf(46) + 1);
        for (IJavaClassField field : fields = type.getDeclaredFields()) {
            if (!field.isEnumConstant() || !field.getName().equals(enumConstName)) continue;
            return field.getName();
        }
        return null;
    }

    public String getName() {
        this.initNameAndType();
        return this._name;
    }

    private void initNameAndType() {
        if (this._name == null) {
            IJavaClassInfo _containingClass = this._owner instanceof IJavaClassInfo ? (IJavaClassInfo)this._owner : this._owner.getEnclosingClass();
            this._type = (IJavaClassInfo)JavaSourceType.createType((ITypeInfoResolver)_containingClass, JavaSourceClass.getTypeName(this._annotationTree.getAnnotationType()), 0);
            this._name = this._type.getName().replace('$', '.');
        }
    }

    public String getDescription() {
        return this.getName();
    }

    public IType getOwnersType() {
        return this._owner.getEnclosingClass().getJavaType();
    }
}

