/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.template;

import gw.internal.gosu.parser.SourceCodeTokenizer;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.IToken;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.SourceCodeReader;
import gw.util.Stack;

public class TemplateTokenizerInstructor
implements ITokenizerInstructor {
    static final int IGNORE = 0;
    static final int IGNORE_COMMENT = 50;
    static final int COMMENT_END_PENDING = 75;
    static final int COMMENT_END_PENDING2 = 76;
    static final int ANALYZE_START_PENDING = 100;
    static final int ANALYZE_PENDING = 200;
    static final int ANALYZE_SEPARATELY_PENDING = 300;
    static final int ANALYZE_DIRECTIVE_PENDING = 350;
    static final int ANALYZE = 400;
    static final int ANALYZE_SEPARATELY = 500;
    static final int ANALYZE_DIRECTIVE = 550;
    static final int ANALYZE_END_PENDING = 600;
    static final int ANALYZE_SEPARATELY_END_PENDING = 700;
    static final int ANALYZE_DIRECTIVE_END_PENDING = 750;
    static final String[] DELIMITERS = new String[]{"<%", "<%=", "<%@", "<%!", "%>", "${", "}", "<%--", "--%>"};
    ISourceCodeTokenizer _tokenizer;
    int _iState;
    boolean _bAltTag;
    boolean _bTag;
    boolean _bEndTagPending;
    boolean _bStartTagBuffer;
    int _iLines;
    StringBuffer _sbStartTag;
    char _lastC;

    public TemplateTokenizerInstructor(ISourceCodeTokenizer tokenizer) {
        this._tokenizer = tokenizer;
        this._iState = 0;
        this._sbStartTag = new StringBuffer();
    }

    public void reset() {
        this._iState = 0;
        this._sbStartTag = new StringBuffer();
        this._bTag = false;
        this._bEndTagPending = false;
        this._bStartTagBuffer = false;
        this._iLines = 0;
        this._bAltTag = false;
    }

    public ITokenizerInstructor createNewInstance(ISourceCodeTokenizer tokenizer) {
        return new TemplateTokenizerInstructor(tokenizer);
    }

    public boolean isAtIgnoredPos() {
        boolean bStartPending = true;
        switch (this.getState()) {
            case 0: 
            case 50: {
                return true;
            }
            case 75: 
            case 76: 
            case 600: 
            case 700: 
            case 750: {
                bStartPending = false;
            }
            case 100: 
            case 200: 
            case 300: 
            case 350: {
                SourceCodeReader reader = this._tokenizer.getReader();
                String strSource = this._tokenizer.getSource();
                for (String delim : DELIMITERS) {
                    int iLen = delim.length();
                    for (int i = 0; i < iLen; ++i) {
                        int iOffset = reader.getPosition() - i - 1;
                        if (strSource.length() - i < iLen || !reader.getSource().startsWith(delim, iOffset)) continue;
                        return true;
                    }
                }
                return bStartPending;
            }
        }
        return false;
    }

    public boolean isAnalyzingDirective() {
        switch (this.getState()) {
            case 550: 
            case 750: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnalyzingSeparately() {
        switch (this.getState()) {
            case 500: 
            case 700: {
                return true;
            }
        }
        return false;
    }

    public void getInstructionFor(int iC) {
        char c = (char)iC;
        char lastC = this._lastC;
        this._lastC = c;
        this.countLines(c);
        switch (this.getState()) {
            case 0: {
                if (c == '<' && lastC != '\\') {
                    this.setState(100);
                    this.startTagBuffer();
                    break;
                }
                if (c != '$' || lastC == '\\') break;
                this.setState(100);
                this.startTagBuffer();
                this._bAltTag = true;
                break;
            }
            case 100: {
                if (!this._bAltTag && c == '%') {
                    this.setState(200);
                    break;
                }
                if (this._bAltTag && c == '{') {
                    this.setState(300);
                    break;
                }
                this._bAltTag = false;
                this.setState(0);
                break;
            }
            case 200: {
                if (c == '=') {
                    this.setState(300);
                    break;
                }
                if (c == '!') break;
                if (c == '-') {
                    if (lastC == '-') {
                        this.setState(50);
                        break;
                    }
                    this.setState(200);
                    break;
                }
                if (c == '@') {
                    this.setState(350);
                    break;
                }
                this.setState(400);
                break;
            }
            case 300: {
                this.setState(500);
                if (!this._bAltTag && c == '%') {
                    this.setState(700);
                    break;
                }
                if (!this._bAltTag || c != '}' || !this.isAnalyzingSeparatelyWaitingForCloseBrace()) break;
                this.setState(700);
                break;
            }
            case 350: {
                this.setState(550);
                if (c != '%') break;
                this.setState(750);
                break;
            }
            case 50: {
                if (c != '-' || lastC != '-') break;
                this.setState(75);
                break;
            }
            case 75: {
                if (c == '%') {
                    this.setState(76);
                    break;
                }
                this.setState(50);
                break;
            }
            case 76: {
                if (c == '>') {
                    this.setState(0);
                    break;
                }
                this.setState(50);
                break;
            }
            case 400: {
                if (c != '%') break;
                this.setState(600);
                break;
            }
            case 500: {
                if (!this._bAltTag && c == '%') {
                    this.setState(700);
                    break;
                }
                if (!this._bAltTag || c != '}' || !this.isAnalyzingSeparatelyWaitingForCloseBrace()) break;
                this.setState(700);
                break;
            }
            case 550: {
                if (c != '%') break;
                this.setState(750);
                break;
            }
            case 600: {
                if (c == '>') {
                    this.setState(0);
                    break;
                }
                this.setState(400);
                break;
            }
            case 700: {
                if (this._bAltTag) {
                    this._bAltTag = false;
                    if (c == '<') {
                        this.setState(100);
                        this.startTagBuffer();
                        break;
                    }
                    if (c == '$') {
                        this.setState(100);
                        this.startTagBuffer();
                        this._bAltTag = true;
                        break;
                    }
                    this.setState(0);
                    break;
                }
                if (c == '>') {
                    this.setState(0);
                    break;
                }
                this.setState(500);
                break;
            }
            case 750: {
                if (c == '>') {
                    this.setState(0);
                    break;
                }
                this.setState(550);
                break;
            }
            default: {
                throw new RuntimeException("Bad template tokenizer instructor state");
            }
        }
    }

    private boolean isAnalyzingSeparatelyWaitingForCloseBrace() {
        Stack tokens = this._tokenizer.getTokens();
        if (tokens.isEmpty()) {
            return true;
        }
        int iStmtBlock = ((SourceCodeTokenizer)this._tokenizer).getInternal().getType() == 125 ? 1 : 0;
        for (int i = tokens.size() - 1; i >= 0; --i) {
            IToken token = (IToken)tokens.get(i);
            if (token.getType() == 125) {
                ++iStmtBlock;
            }
            if (token.getType() != 123) continue;
            if (iStmtBlock == 0) {
                if (!token.isAnalyzingSeparately()) continue;
                return false;
            }
            --iStmtBlock;
        }
        return true;
    }

    private void setState(int iState) {
        this._iState = iState;
    }

    private int getState() {
        return this._iState;
    }

    private void countLines(char c) {
        if (c == '\n') {
            ++this._iLines;
        }
    }

    private void startTagBuffer() {
        this._bStartTagBuffer = true;
    }

    public void setTokenizer(ISourceCodeTokenizer tokenizer) {
        this._tokenizer = tokenizer;
    }
}

