/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.compiler;

import gw.internal.gosu.parser.IBlockClassInternal;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.ICompilableType;

public class CompilationStatistics {
    long _totalBytes;
    long _blockBytes;
    long _programBytes;
    long _otherBytes;
    long _total;
    long _block;
    long _program;
    long _other;
    long _totalBytesPermanent;
    long _blockBytesPermanent;
    long _programBytesPermanent;
    long _otherBytesPermanent;
    long _totalPermanent;
    long _blockPermanent;
    long _programPermanent;
    long _otherPermanent;
    private static CompilationStatistics INSTANCE = new CompilationStatistics();

    private CompilationStatistics() {
    }

    public static CompilationStatistics instance() {
        return INSTANCE;
    }

    public void collectStats(ICompilableType gsClass, byte[] classBytes, boolean singleServingClassLoader) {
        if (!BytecodeOptions.collectCompilationStatistics()) {
            return;
        }
        long length = classBytes.length;
        if (gsClass instanceof IBlockClassInternal) {
            this._blockBytes += length;
            ++this._block;
            if (!singleServingClassLoader) {
                this._blockBytesPermanent += length;
                ++this._blockPermanent;
            }
        } else if (gsClass.getName().startsWith("program_")) {
            this._programBytes += length;
            ++this._program;
            if (!singleServingClassLoader) {
                this._programBytesPermanent += length;
                ++this._programPermanent;
            }
        } else {
            this._otherBytes += length;
            ++this._other;
            if (!singleServingClassLoader) {
                this._otherBytesPermanent += length;
                ++this._otherPermanent;
            }
        }
        this._totalBytes += length;
        ++this._total;
        if (!singleServingClassLoader) {
            this._totalBytesPermanent += length;
            ++this._totalPermanent;
        }
        System.out.println("    * Class : " + gsClass.getName() + ", size : " + length);
        System.out.println("    * Defined in SingleServingClassLoader : " + singleServingClassLoader);
        System.out.println("      * Bytes = total : " + this._totalBytes + ", blocks : " + this._blockBytes + ", programs : " + this._programBytes + ", other : " + this._otherBytes);
        System.out.println("      * Count = total : " + this._total + ", blocks : " + this._block + ", programs : " + this._program + ", other : " + this._other);
        System.out.println("      * Bytes (Permanent) = total : " + this._totalBytesPermanent + ", blocks : " + this._blockBytesPermanent + ", programs : " + this._programBytesPermanent + ", other : " + this._otherBytesPermanent);
        System.out.println("      * Count (Permanent) = total : " + this._totalPermanent + ", blocks : " + this._blockPermanent + ", programs : " + this._programPermanent + ", other : " + this._otherPermanent);
    }
}

