/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.compiler.NamedLabel;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRCompilerLocalVar;
import gw.internal.gosu.ir.compiler.bytecode.IRCompilerScope;
import gw.internal.gosu.ir.compiler.bytecode.IRFinallyCodePartitioner;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.statement.IRTerminalStatement;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import gw.util.GosuExceptionUtil;
import gw.util.Stack;
import java.util.ArrayList;
import java.util.List;

public class IRBytecodeContext {
    private MethodVisitor _mv;
    private Stack<IRCompilerScope> _scopes;
    private List<IRCompilerLocalVar> _allLocalVars;
    private Stack<IRFinallyCodePartitioner> _finallyStatements;
    private int _tempVarCount;
    private Stack<Label> _breakLabels;
    private Stack<Label> _continueLabels;
    private Label _lastVisitedLabel;
    private int _lastLineNumber;

    public IRBytecodeContext(MethodVisitor mv) {
        this._mv = mv;
        this._scopes = new Stack();
        this.pushScope();
        this._allLocalVars = new ArrayList<IRCompilerLocalVar>();
        this._finallyStatements = new Stack();
        this._breakLabels = new Stack();
        this._continueLabels = new Stack();
        this._lastLineNumber = -1;
    }

    public MethodVisitor getMv() {
        return this._mv;
    }

    public void visitLabel(Label label) {
        this._lastVisitedLabel = label;
        this._mv.visitLabel(label);
        for (IRCompilerLocalVar lv : this._allLocalVars) {
            if (lv.getStartLabel() == null) {
                lv.setStartLabel(label);
            }
            if (!this.isOutOfScope(lv) || lv.getEndLabel() != null) continue;
            lv.setEndLabel(label);
        }
    }

    public int getLocalCount() {
        return this._allLocalVars.size();
    }

    public int getMaxScopeSize() {
        int iMax = 0;
        for (IRCompilerLocalVar local : this._allLocalVars) {
            iMax = Math.max(local.getScope().getLocalVars().size(), iMax);
        }
        return iMax;
    }

    private boolean isOutOfScope(IRCompilerLocalVar lv) {
        return !lv.getScope().isActive();
    }

    public void visitLocalVars() {
        for (IRCompilerLocalVar lv : this._allLocalVars) {
            if (lv.isTemp()) continue;
            try {
                if (lv.getStartLabel().equals(lv.getEndLabel())) continue;
                this._mv.visitLocalVariable(lv.getName(), lv.getType().getDescriptor(), null, lv.getStartLabel(), lv.getEndLabel(), lv.getIndex());
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e, (String)lv.getName());
            }
        }
    }

    public void pushScope() {
        this._scopes.push((Object)new IRCompilerScope(this._scopes.isEmpty() ? null : (IRCompilerScope)this._scopes.peek()));
    }

    public void popScope() {
        IRCompilerScope oldScope = (IRCompilerScope)this._scopes.pop();
        oldScope.scopeRemoved();
    }

    public void indexThis(IRType type) {
        Label label = new Label();
        this.visitLabel(label);
        IRCompilerLocalVar thisVar = this.getLocalVar(new IRSymbol("this", type, false));
        thisVar.setStartLabel(label);
    }

    public void indexSymbols(List<IRSymbol> symbols) {
        for (IRSymbol symbol : symbols) {
            this.getLocalVar(symbol);
        }
    }

    public IRCompilerLocalVar getLocalVar(IRSymbol symbol) {
        IRCompilerLocalVar localVar = ((IRCompilerScope)this._scopes.peek()).findLocalVar(symbol);
        if (localVar == null) {
            localVar = ((IRCompilerScope)this._scopes.peek()).createLocalVar(symbol);
            this._allLocalVars.add(localVar);
        }
        return localVar;
    }

    public IRCompilerLocalVar makeTempVar(IRType type) {
        return this.getLocalVar(new IRSymbol("$$compilertemp$$" + this._tempVarCount++, type, true));
    }

    public IRFinallyCodePartitioner pushFinallyStatement(IRTryCatchFinallyStatement tryCatchFinallyStmt) {
        IRFinallyCodePartitioner partition = new IRFinallyCodePartitioner(this, tryCatchFinallyStmt);
        this._finallyStatements.push((Object)partition);
        return partition;
    }

    public void popFinallyStatement(IRFinallyCodePartitioner partition) {
        IRFinallyCodePartitioner popped = (IRFinallyCodePartitioner)this._finallyStatements.pop();
        if (popped != partition) {
            throw new IllegalStateException("Finally statements out of order. Expected '" + partition + "', but got '" + popped);
        }
    }

    public boolean hasFinallyStatements() {
        return !this._finallyStatements.isEmpty();
    }

    public Stack<IRFinallyCodePartitioner> getFinallyParitioners() {
        return this._finallyStatements;
    }

    public IRFinallyCodePartitioner peekFinallyPartitioner() {
        return (IRFinallyCodePartitioner)this._finallyStatements.peek();
    }

    public void inlineFinallyStatements(IRTerminalStatement stmt) {
        IRFinallyCodePartitioner partition;
        if (!this.hasFinallyStatements()) {
            return;
        }
        Stack<IRFinallyCodePartitioner> partitions = this.getFinallyParitioners();
        ArrayList<IRFinallyCodePartitioner> inlinedFinallys = new ArrayList<IRFinallyCodePartitioner>();
        for (int i = partitions.size() - 1; i >= 0 && (partition = (IRFinallyCodePartitioner)partitions.get(i)).appliesTo(stmt); --i) {
            partition.inlineFinally();
            inlinedFinallys.add(partition);
        }
        NamedLabel endLabel = new NamedLabel("EndFinally");
        this.visitLabel(endLabel);
        for (IRFinallyCodePartitioner inlinedFinally : inlinedFinallys) {
            inlinedFinally.endInlineFinally(endLabel);
        }
    }

    public void compile(IRElement element) {
        IRBytecodeCompiler.compileIRElement(element, this);
    }

    public void pushBreakLabel(Label label) {
        this._breakLabels.push((Object)label);
    }

    public void popBreakLabel() {
        this._breakLabels.pop();
    }

    public void pushContinueLabel(Label label) {
        this._continueLabels.push((Object)label);
    }

    public void popContinueLabel() {
        this._continueLabels.pop();
    }

    public Label getCurrentBreakLabel() {
        return (Label)this._breakLabels.peek();
    }

    public Label getCurrentContinueLabel() {
        return (Label)this._continueLabels.peek();
    }

    public int setLineNumber(int lineNumber) {
        int lastLineNumber = this._lastLineNumber;
        if (lineNumber > 0 && lineNumber != lastLineNumber) {
            MethodVisitor mv = this.getMv();
            Label label = new Label();
            this.visitLabel(label);
            mv.visitLineNumber(lineNumber, label);
            this._lastLineNumber = lineNumber;
        }
        return lastLineNumber;
    }
}

