/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.gosu.ir.compiler.bytecode.IRCompilerLocalVar;
import gw.lang.ir.IRSymbol;
import java.util.Collection;
import java.util.HashMap;

public class IRCompilerScope {
    private IRCompilerScope _parent;
    private HashMap<String, IRCompilerLocalVar> _localVars;
    private int _size;
    private boolean _active = true;

    public IRCompilerScope(IRCompilerScope parent) {
        this._parent = parent;
        this._localVars = new HashMap();
    }

    public IRCompilerLocalVar findLocalVar(IRSymbol symbol) {
        if (this._localVars.containsKey(symbol.getName())) {
            return this._localVars.get(symbol.getName());
        }
        if (this._parent != null) {
            return this._parent.findLocalVar(symbol);
        }
        return null;
    }

    public IRCompilerLocalVar createLocalVar(IRSymbol symbol) {
        IRCompilerLocalVar existingVar = this.findLocalVar(symbol);
        if (existingVar == null) {
            existingVar = new IRCompilerLocalVar(symbol, this.totalWidth(), this);
            this._localVars.put(symbol.getName(), existingVar);
            this._size += existingVar.getWidth();
        }
        return existingVar;
    }

    public Collection<IRCompilerLocalVar> getLocalVars() {
        return this._localVars.values();
    }

    public int totalWidth() {
        return (this._parent == null ? 0 : this._parent.totalWidth()) + this._size;
    }

    public boolean isActive() {
        return this._active;
    }

    public void scopeRemoved() {
        this._active = false;
    }
}

