/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.expression.IRNumericLiteral;

public class IREqualityExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IREqualityExpression expression, IRBytecodeContext context) {
        if (expression.getLhs() instanceof IRNullLiteral || expression.getRhs() instanceof IRNullLiteral) {
            IREqualityExpressionCompiler.compareToNull(expression.isEquals(), expression.getLhs() instanceof IRNullLiteral ? expression.getRhs() : expression.getLhs(), context, (IRExpression)expression);
        } else if (expression.getLhs().getType().isPrimitive()) {
            if (!expression.getLhs().getType().equals(expression.getRhs().getType())) {
                throw new IllegalArgumentException("Equality expression comparing two different primitive types :" + expression.getLhs().getType().getName() + " and " + expression.getRhs().getType().getName());
            }
            IRType lhsType = expression.getLhs().getType();
            if (lhsType.isBoolean() || lhsType.isByte() || lhsType.isChar() || lhsType.isShort() || lhsType.isInt()) {
                IREqualityExpressionCompiler.compareInts(expression.isEquals(), expression.getLhs(), expression.getRhs(), context, (IRExpression)expression);
            } else if (lhsType.isLong()) {
                IREqualityExpressionCompiler.compareLongs(expression.isEquals(), expression.getLhs(), expression.getRhs(), context, (IRExpression)expression);
            } else if (lhsType.isDouble()) {
                IREqualityExpressionCompiler.compareDoubles(expression.isEquals(), expression.getLhs(), expression.getRhs(), context, (IRExpression)expression);
            } else if (lhsType.isFloat()) {
                IREqualityExpressionCompiler.compareFloats(expression.isEquals(), expression.getLhs(), expression.getRhs(), context, (IRExpression)expression);
            } else {
                System.out.println("Unexpected primitive type " + lhsType.getName());
            }
        } else {
            IREqualityExpressionCompiler.compareObjects(expression.isEquals(), expression.getLhs(), expression.getRhs(), context, (IRExpression)expression);
        }
    }

    private static void compareToNull(boolean equals, IRExpression expr, IRBytecodeContext context, IRExpression root) {
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(expr, context);
        IREqualityExpressionCompiler.compare(mv, equals ? 198 : 199, root);
    }

    private static void compareInts(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context, IRExpression root) {
        int opcode;
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(lhs, context);
        IRType rhsType = rhs.getType();
        if (!IREqualityExpressionCompiler.isInteger0(rhs, rhsType)) {
            IRBytecodeCompiler.compileIRExpression(rhs, context);
            opcode = equals ? 159 : 160;
        } else {
            opcode = equals ? 153 : 154;
        }
        IREqualityExpressionCompiler.compare(mv, opcode, root);
    }

    public static boolean isInteger0(IRExpression expr, IRType lhsType) {
        return expr instanceof IRNumericLiteral && lhsType.isPrimitive() && !lhsType.isDouble() && !lhsType.isFloat() && !lhsType.isLong() && ((IRNumericLiteral)expr).getValue().intValue() == 0;
    }

    private static void compareLongs(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context, IRExpression root) {
        IREqualityExpressionCompiler.compareNonIntPrimitives(equals, lhs, rhs, context, 148, root);
    }

    private static void compareDoubles(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context, IRExpression root) {
        IREqualityExpressionCompiler.compareNonIntPrimitives(equals, lhs, rhs, context, 151, root);
    }

    private static void compareFloats(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context, IRExpression root) {
        IREqualityExpressionCompiler.compareNonIntPrimitives(equals, lhs, rhs, context, 149, root);
    }

    private static void compareNonIntPrimitives(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context, int compareOp, IRExpression root) {
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(lhs, context);
        IRBytecodeCompiler.compileIRExpression(rhs, context);
        mv.visitInsn(compareOp);
        IREqualityExpressionCompiler.compare(mv, equals ? 153 : 154, root);
    }

    private static void compareObjects(boolean equals, IRExpression lhs, IRExpression rhs, IRBytecodeContext context, IRExpression root) {
        MethodVisitor mv = context.getMv();
        IRBytecodeCompiler.compileIRExpression(lhs, context);
        IRBytecodeCompiler.compileIRExpression(rhs, context);
        IREqualityExpressionCompiler.compare(mv, equals ? 165 : 166, root);
    }

    private static void compare(MethodVisitor mv, int opcode, IRExpression root) {
        root.getConditionContext().setOperator(opcode);
        if (IREqualityExpressionCompiler.isNotPartOfBooleanExpr(root)) {
            IREqualityExpressionCompiler.compileConditionAssignment(root, mv);
        }
    }
}

