/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.nodes;

import gw.internal.gosu.ir.nodes.GosuClassIRType;
import gw.internal.gosu.ir.nodes.IRFeatureBase;
import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ReducedParameterizedDynamicFunctionSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IReducedSymbol;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaConstructorInfo;
import gw.lang.reflect.java.IJavaType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IRMethodFromConstructorInfo
extends IRFeatureBase
implements IRMethod {
    private IConstructorInfo _constructor;

    public IRMethodFromConstructorInfo(IConstructorInfo constructor) {
        this._constructor = constructor;
    }

    @Override
    public IRType getReturnType() {
        return IRTypeConstants.pVOID();
    }

    @Override
    public List<IRType> getExplicitParameterTypes() {
        return this.getBoundedParameterTypeDescriptors(this._constructor);
    }

    @Override
    public List<IRType> getAllParameterTypes() {
        return this.getMethodDescriptor(this._constructor);
    }

    @Override
    public String getName() {
        return "<init>";
    }

    @Override
    public IRType getOwningIRType() {
        return IRMethodFromConstructorInfo.getTrueOwningType(this._constructor);
    }

    @Override
    public IType getOwningIType() {
        IJavaClassConstructor m;
        IType owningType = this._constructor instanceof IJavaConstructorInfo ? ((m = ((IJavaConstructorInfo)this._constructor).getJavaConstructor()) != null ? TypeSystem.get((IJavaClassInfo)m.getEnclosingClass()) : this._constructor.getOwnersType()) : this._constructor.getOwnersType();
        return owningType;
    }

    @Override
    public IRelativeTypeInfo.Accessibility getAccessibility() {
        return AccessibilityUtil.forFeatureInfo((IAttributedFeatureInfo)this._constructor);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public IRType getTargetRootIRType() {
        IRType owner = this.getOwningIRType();
        if (owner instanceof GosuClassIRType && ((GosuClassIRType)owner).getType() instanceof IGosuEnhancement) {
            return IRTypeResolver.getDescriptor(((IGosuEnhancement)((GosuClassIRType)owner).getType()).getEnhancedType());
        }
        return owner;
    }

    @Override
    public IGenericTypeVariable[] getTypeVariables() {
        if (this._constructor instanceof IGosuConstructorInfo && !IGosuClass.ProxyUtil.isProxy((IType)this._constructor.getOwnersType())) {
            return ((IGosuConstructorInfo)this._constructor).getTypeVariables();
        }
        return null;
    }

    @Override
    public IFunctionType getFunctionType() {
        if (this._constructor instanceof IGosuConstructorInfo && !IGosuClass.ProxyUtil.isProxy((IType)this._constructor.getOwnersType())) {
            return (IFunctionType)((IGosuConstructorInfo)this._constructor).getDfs().getType();
        }
        return null;
    }

    @Override
    public boolean isBytecodeMethod() {
        return this._constructor instanceof IGosuConstructorInfo || this._constructor instanceof IJavaConstructorInfo;
    }

    private static IRType getTrueOwningType(IConstructorInfo mi) {
        IJavaClassConstructor m;
        if (mi instanceof IJavaConstructorInfo && (m = ((IJavaConstructorInfo)mi).getJavaConstructor()) != null) {
            return IRTypeResolver.getDescriptor(m.getEnclosingClass());
        }
        return IRTypeResolver.getDescriptor(mi.getOwnersType());
    }

    @Override
    public boolean couldHaveTypeVariables() {
        return this._constructor instanceof IGosuMethodInfo && !IGosuClass.ProxyUtil.isProxy((IType)this._constructor.getOwnersType());
    }

    public List<IRType> getMethodDescriptor(IConstructorInfo mi) {
        ArrayList<IRType> paramTypes = new ArrayList<IRType>();
        this.addImplicitConstructorParamTypes(this.getOwningIType(), paramTypes);
        paramTypes.addAll(this.getBoundedParameterTypeDescriptors(mi));
        return paramTypes;
    }

    private void addImplicitConstructorParamTypes(IType owningType, List<IRType> paramTypes) {
        this.addImplicitOuterParamType(owningType, paramTypes);
        this.addImplicitCapturedSymbolParamTypes(owningType, paramTypes);
        this.addImplicitTypeVariableParamTypes(owningType, paramTypes);
        this.addImplicitEnumParamTypes(owningType, paramTypes);
    }

    private void addImplicitOuterParamType(IType owningType, List<IRType> paramTypes) {
        if (AbstractElementTransformer.isNonStaticInnerClass(owningType)) {
            paramTypes.add(IRTypeResolver.getDescriptor(AbstractElementTransformer.getRuntimeEnclosingType(owningType)));
        }
    }

    private void addImplicitCapturedSymbolParamTypes(IType owningType, List<IRType> paramTypes) {
        Map<String, ICapturedSymbol> capturedSymbols;
        if (owningType instanceof IGosuClassInternal && owningType.isValid() && (capturedSymbols = ((IGosuClassInternal)owningType).getCapturedSymbols()) != null) {
            for (ICapturedSymbol sym : capturedSymbols.values()) {
                paramTypes.add(IRTypeResolver.getDescriptor(sym.getType().getArrayType()));
            }
        }
        if (AbstractElementTransformer.requiresExternalSymbolCapture(owningType)) {
            paramTypes.add(IRTypeResolver.getDescriptor(IExternalSymbolMap.class));
        }
    }

    private void addImplicitTypeVariableParamTypes(IType owningType, List<IRType> paramTypes) {
        if (owningType instanceof IGosuClassInternal && !IGosuClass.ProxyUtil.isProxy((IType)owningType)) {
            if (owningType.isParameterizedType()) {
                owningType = owningType.getGenericType();
            }
            this.addTypeVariableParameters(paramTypes, owningType.getGenericTypeVariables().length);
            this.addTypeVarsFromEnclosingFunctions((IGosuClassInternal)owningType, paramTypes);
        }
    }

    private void addTypeVarsFromEnclosingFunctions(IGosuClassInternal gsClass, List<IRType> parameters) {
        IDynamicFunctionSymbol dfs;
        while (gsClass.isAnonymous() && (dfs = AbstractElementTransformer.getEnclosingDFS(gsClass)) != null) {
            if (dfs.isReified()) {
                this.addTypeVariableParameters(parameters, AbstractElementTransformer.getTypeVarsForDFS(dfs).size());
            }
            gsClass = (IGosuClassInternal)dfs.getGosuClass();
        }
    }

    private void addImplicitEnumParamTypes(IType owningType, List<IRType> paramTypes) {
        if (owningType.isEnum()) {
            paramTypes.add(IRTypeConstants.STRING());
            paramTypes.add(IRTypeConstants.pINT());
        }
    }

    private List<IRType> getBoundedParameterTypeDescriptors(IConstructorInfo mi) {
        if (mi.getParameters().length == 0) {
            return Collections.emptyList();
        }
        if (mi instanceof IJavaConstructorInfo) {
            return IRTypeResolver.getDescriptors(((IJavaConstructorInfo)mi).getJavaConstructor().getParameterTypes());
        }
        if (mi instanceof IGosuConstructorInfo) {
            IReducedDynamicFunctionSymbol dfs = ((IGosuConstructorInfo)mi).getDfs();
            while (dfs instanceof ReducedParameterizedDynamicFunctionSymbol) {
                ReducedParameterizedDynamicFunctionSymbol pdfs = (ReducedParameterizedDynamicFunctionSymbol)dfs;
                dfs = pdfs.getBackingDfs();
            }
            ArrayList<IRType> boundedTypes = new ArrayList<IRType>(dfs.getArgs().size());
            if (IGosuClass.ProxyUtil.isProxy((IType)dfs.getGosuClass())) {
                return this.getBoundedParamTypesFromProxiedClass(dfs);
            }
            for (int i = 0; i < dfs.getArgs().size(); ++i) {
                boundedTypes.add(IRTypeResolver.getDescriptor(TypeLord.getDefaultParameterizedTypeWithTypeVars(((IReducedSymbol)dfs.getArgs().get(i)).getType())));
            }
            return boundedTypes;
        }
        return this.getTypeDescriptors(mi.getParameters());
    }

    private List<IRType> getBoundedParamTypesFromProxiedClass(IReducedDynamicFunctionSymbol dfs) {
        Constructor m = this.getJavaConstructorFromProxy(dfs);
        return IRTypeResolver.getDescriptors(m.getParameterTypes());
    }

    private Constructor getJavaConstructorFromProxy(IReducedDynamicFunctionSymbol dfs) {
        IGosuClass proxyType = dfs.getGosuClass();
        IJavaType javaType = (IJavaType)IGosuClass.ProxyUtil.getProxiedType((IType)proxyType);
        IType[] boundedDfsParams = new IType[dfs.getArgs().size()];
        for (int i = 0; i < boundedDfsParams.length; ++i) {
            IType param = ((IReducedSymbol)dfs.getArgs().get(i)).getType();
            if (param instanceof ITypeVariableType && param.getEnclosingType() instanceof IGosuClass) {
                param = ((ITypeVariableType)param).getBoundingType();
            }
            boundedDfsParams[i] = param;
        }
        javaType = (IJavaType)TypeLord.getDefaultParameterizedType((IType)javaType);
        IJavaConstructorInfo jmi = (IJavaConstructorInfo)((IRelativeTypeInfo)javaType.getTypeInfo()).getConstructor((IType)javaType, boundedDfsParams);
        return jmi.getRawConstructor();
    }

    @Override
    public boolean isGeneratedEnumMethod() {
        return false;
    }
}

