/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.internal.gosu.ir.transform.DFSFunctionBodyTransformationContext;
import gw.internal.gosu.ir.transform.FunctionBodyTransformationContext;
import gw.internal.gosu.ir.transform.IRScope;
import gw.internal.gosu.ir.transform.StatementTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.InitializerAssignment;
import gw.lang.ir.IRClass;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.IStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.util.Stack;
import java.util.List;

public abstract class TransformationContextBase
implements TopLevelTransformationContext {
    private FunctionBodyTransformationContext _bodyContext;
    private ICompilableTypeInternal _compilingType;
    private IRClass _irClass;
    private int _iLazyMethodCount;

    protected TransformationContextBase(ICompilableTypeInternal compilingType) {
        this._compilingType = compilingType;
    }

    public void initBodyContext(boolean isStatic) {
        this._bodyContext = new FunctionBodyTransformationContext(this, isStatic);
    }

    public void initBodyContext(boolean isStatic, DynamicFunctionSymbol dfs) {
        this._bodyContext = new DFSFunctionBodyTransformationContext(this, isStatic, dfs);
    }

    @Override
    public IRClass getIrClass() {
        return this._irClass;
    }

    @Override
    public void setIrClass(IRClass irClass) {
        this._irClass = irClass;
    }

    @Override
    public IRStatement compile(IStatement stmt) {
        return StatementTransformer.compile(this, stmt);
    }

    @Override
    public IRStatement compileInitializerAssignment(InitializerAssignment stmt, IRExpression root) {
        return StatementTransformer.compileInitializerAssignment(this, stmt, root);
    }

    @Override
    public boolean currentlyCompilingBlock() {
        return false;
    }

    @Override
    public ICompilableTypeInternal getGosuClass() {
        return this._compilingType;
    }

    @Override
    public IType getSuperType() {
        return this._compilingType.getSupertype() == null ? JavaTypes.OBJECT() : this._compilingType.getSupertype();
    }

    @Override
    public ICompilableTypeInternal getEnclosingType() {
        return this._compilingType.getEnclosingType();
    }

    @Override
    public boolean isNonStaticInnerClass() {
        return !this._compilingType.isStatic() && this._compilingType.getEnclosingType() != null;
    }

    @Override
    public boolean compilingEnhancement() {
        return this._compilingType instanceof IGosuEnhancementInternal;
    }

    @Override
    public boolean compilingEnum() {
        return this._compilingType.isEnum();
    }

    @Override
    public boolean compilingBlock() {
        return this._compilingType instanceof IBlockClass;
    }

    @Override
    public boolean compilingProgram() {
        return this._compilingType instanceof IGosuProgram;
    }

    @Override
    public IRSymbol makeAndIndexTempSymbol(IRType type) {
        return this._bodyContext.makeAndIndexTempSymbol(type);
    }

    @Override
    public IRSymbol makeAndIndexTempSymbol(String strNameSuffix, IRType type) {
        return this._bodyContext.makeAndIndexTempSymbol(strNameSuffix, type);
    }

    @Override
    public IRSymbol getTypeParamIndex(TypeVariableType type) {
        return this._bodyContext.getTypeParamIndex(type);
    }

    @Override
    public IRSymbol getSymbol(String symbolName) {
        return this._bodyContext.getSymbol(symbolName);
    }

    @Override
    public boolean hasSymbol(String strSymbol) {
        return this._bodyContext.hasSymbol(strSymbol);
    }

    @Override
    public void pushScope(boolean bInitialInstanceMethodScope) {
        this._bodyContext.pushScope(bInitialInstanceMethodScope);
    }

    @Override
    public void popScope() {
        this._bodyContext.popScope();
    }

    @Override
    public void putSymbol(IRSymbol symbol) {
        this._bodyContext.putSymbol(symbol);
    }

    @Override
    public void putSymbols(List<IRSymbol> symbols) {
        this._bodyContext.putSymbols(symbols);
    }

    @Override
    public String makeTempSymbolName() {
        return this._bodyContext.makeTempSymbolName();
    }

    @Override
    public boolean isBlockInvoke() {
        return this._bodyContext.isBlockInvoke();
    }

    @Override
    public IRSymbol createSymbol(String name, IRType type) {
        return this._bodyContext.createSymbol(name, type);
    }

    @Override
    public boolean hasSuperBeenInvoked() {
        return this._bodyContext.hasSuperBeenInvoked();
    }

    @Override
    public boolean isStatic() {
        return this._bodyContext.isStatic();
    }

    @Override
    public void markSuperInvoked() {
        this._bodyContext.markSuperInvoked();
    }

    @Override
    public void markInvokingSuper() {
        this._bodyContext.markInvokingSuper();
    }

    @Override
    public void updateSuperInvokedAfterLastExpressionCompiles() {
        this._bodyContext.updateSuperInvokedAfterLastExpressionCompiles();
    }

    @Override
    public Stack<IRScope> getScopes() {
        return this._bodyContext.getScopes();
    }

    @Override
    public String getCurrentFunctionName() {
        DynamicFunctionSymbol functionSymbol = this._bodyContext.getCurrentDFS();
        return functionSymbol == null ? null : functionSymbol.getName();
    }

    @Override
    public DynamicFunctionSymbol getCurrentFunction() {
        return this._bodyContext.getCurrentDFS();
    }

    @Override
    public int incrementLazyTypeMethodCount() {
        return this._iLazyMethodCount++;
    }

    @Override
    public boolean isCurrentFunctionStatic() {
        return this._bodyContext.isStatic();
    }

    @Override
    public IType getCurrentFunctionReturnType() {
        DynamicFunctionSymbol functionSymbol = this._bodyContext.getCurrentDFS();
        return functionSymbol == null ? null : functionSymbol.getReturnType();
    }
}

