/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.statement.ForEachStatementTransformer;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRNoOpExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRForEachStatement;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMemberExpansionTransformer<T extends IMemberAccessExpression>
extends AbstractExpressionTransformer<T> {
    protected AbstractMemberExpansionTransformer(TopLevelTransformationContext cc, T expr) {
        super(cc, expr);
    }

    protected abstract IRExpression createIterationExpr(IType var1, String var2, IType var3, IType var4);

    protected abstract IType getPropertyOrMethodType(IType var1, IType var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRExpression compile_impl() {
        boolean bVoid;
        IType arrayType = ((IMemberAccessExpression)this._expr()).getType();
        boolean bl = bVoid = arrayType == JavaTypes.pVOID();
        if (!bVoid && !arrayType.isArray()) {
            throw new IllegalStateException("Expecting an array type. Found: " + arrayType.getName());
        }
        IType compType = bVoid ? arrayType : this.getConcreteType(arrayType.getComponentType());
        IType rootType = ((IMemberAccessExpression)this._expr()).getRootType();
        IType rootComponentType = TypeLord.getExpandableComponentType(rootType, false);
        IType propertyType = this.getPropertyOrMethodType(rootComponentType, compType);
        this._cc().pushScope(false);
        try {
            if (bVoid) {
                IRExpression iRExpression = this.compileExpansionWithNoReturnValue(rootType, rootComponentType, arrayType, compType);
                return iRExpression;
            }
            if (AbstractMemberExpansionTransformer.isBytecodeType(propertyType) && AbstractMemberExpansionTransformer.isArrayOrCollection(rootType) && !AbstractMemberExpansionTransformer.isArrayOrCollection(rootComponentType) && !AbstractMemberExpansionTransformer.isArrayOrCollection(propertyType)) {
                IRExpression iRExpression = this.compileExpansionDirectlyToArray(rootType, rootComponentType, arrayType, compType);
                return iRExpression;
            }
            IRExpression iRExpression = this.compileExpansionUsingArrayList(rootType, rootComponentType, arrayType, compType, propertyType);
            return iRExpression;
        }
        finally {
            this._cc().popScope();
        }
    }

    private static boolean isArrayOrCollection(IType type) {
        return type.isArray() || JavaTypes.COLLECTION().isAssignableFrom(type);
    }

    protected IRExpression compileExpansionWithNoReturnValue(IType rootType, IType rootComponentType, IType resultType, IType resultCompType) {
        IRSymbol tempRoot = this._cc().makeAndIndexTempSymbol(AbstractMemberExpansionTransformer.getDescriptor(rootType));
        IRAssignmentStatement tempRootAssignment = this.buildAssignment(tempRoot, ExpressionTransformer.compile(((IMemberAccessExpression)this._expr()).getRootExpression(), this._cc()));
        IRForEachStatement statement = this.createNoValueLoop(rootType, rootComponentType, resultCompType, tempRoot);
        return this.buildComposite(new IRElement[]{tempRootAssignment, statement, new IRNoOpExpression()});
    }

    private IRForEachStatement createNoValueLoop(IType rootType, IType rootComponentType, IType resultCompType, IRSymbol tempRoot) {
        Symbol loopIdentifier = new Symbol(this._cc().makeTempSymbolName(), rootComponentType, null);
        IRForEachStatement forLoop = ForEachStatementTransformer.makeLoop(this._cc(), (IRExpression)this.identifier(tempRoot), rootType, loopIdentifier, null);
        IRSymbol irLoopIdentifier = this._cc().getSymbol(loopIdentifier.getName());
        forLoop.setBody((IRStatement)new IRStatementList(false, new IRStatement[]{this.buildMethodCall(this.createIterationExpr(rootComponentType, irLoopIdentifier.getName(), rootComponentType, resultCompType))}));
        return forLoop;
    }

    protected IRExpression compileExpansionDirectlyToArray(IType rootType, IType rootComponentType, IType resultType, IType resultCompType) {
        IRSymbol tempRoot = this._cc().makeAndIndexTempSymbol(AbstractMemberExpansionTransformer.getDescriptor(rootType));
        IRAssignmentStatement tempRootAssignment = this.buildAssignment(tempRoot, ExpressionTransformer.compile(((IMemberAccessExpression)this._expr()).getRootExpression(), this._cc()));
        IRSymbol resultArray = this._cc().makeAndIndexTempSymbol(AbstractMemberExpansionTransformer.getDescriptor(resultType));
        IRAssignmentStatement arrayCreation = this.buildAssignment(resultArray, this.makeArray(resultCompType, this.createArrayLengthExpression(rootType, tempRoot)));
        IRForEachStatement forLoop = this.createArrayStoreLoop(rootType, rootComponentType, resultCompType, tempRoot, resultArray);
        IRCompositeExpression expansion = this.buildComposite(new IRElement[]{arrayCreation, forLoop, this.identifier(resultArray)});
        if (!rootComponentType.isPrimitive() && !resultCompType.isPrimitive()) {
            return this.buildComposite(new IRElement[]{tempRootAssignment, this.buildNullCheckTernary((IRExpression)this.identifier(tempRoot), this.checkCast(((IMemberAccessExpression)this._expr()).getType(), this.makeArray(resultCompType, this.numericLiteral(0))), this.checkCast(((IMemberAccessExpression)this._expr()).getType(), (IRExpression)expansion))});
        }
        return this.buildComposite(new IRElement[]{tempRootAssignment, this.checkCast(((IMemberAccessExpression)this._expr()).getType(), (IRExpression)expansion)});
    }

    private IRExpression makeArray(IType componentType, IRExpression lengthExpression) {
        if (componentType.isPrimitive() || componentType instanceof IGosuClass || componentType instanceof IJavaType) {
            return this.newArray(AbstractMemberExpansionTransformer.getDescriptor(componentType), lengthExpression);
        }
        IRExpression array = this.callMethod(IType.class, "makeArrayInstance", new Class[]{Integer.TYPE}, this.pushType(componentType), AbstractMemberExpansionTransformer.exprList(lengthExpression));
        return this.checkCast(componentType.getArrayType(), array);
    }

    private IRExpression createArrayLengthExpression(IType rootType, IRSymbol tempRoot) {
        if (rootType.isArray()) {
            return this.buildArrayLength((IRExpression)this.identifier(tempRoot));
        }
        if (JavaTypes.COLLECTION().isAssignableFrom(rootType)) {
            IRMethod irMethod = IRMethodFactory.createIRMethod(rootType, "size", (IType)JavaTypes.pINT(), new IType[0], IRelativeTypeInfo.Accessibility.PUBLIC, false);
            return this.callMethod(irMethod, (IRExpression)this.identifier(tempRoot), AbstractMemberExpansionTransformer.exprList(new IRExpression[0]));
        }
        throw new IllegalArgumentException("Cannot get the size of type " + rootType);
    }

    private IRForEachStatement createArrayStoreLoop(IType rootType, IType rootComponentType, IType resultCompType, IRSymbol tempRoot, IRSymbol resultArray) {
        Symbol loopIdentifier = new Symbol(this._cc().makeTempSymbolName(), rootComponentType, null);
        Symbol loopIndex = new Symbol(this._cc().makeTempSymbolName(), (IType)JavaTypes.pINT(), null);
        IRForEachStatement forLoop = ForEachStatementTransformer.makeLoop(this._cc(), (IRExpression)this.identifier(tempRoot), rootType, loopIdentifier, loopIndex);
        IRSymbol irLoopIdentifier = this._cc().getSymbol(loopIdentifier.getName());
        IRSymbol irLoopIndex = this._cc().getSymbol(loopIndex.getName());
        forLoop.setBody(this.buildArrayStore((IRExpression)this.identifier(resultArray), (IRExpression)this.identifier(irLoopIndex), this.createIterationExpr(rootComponentType, irLoopIdentifier.getName(), rootComponentType, resultCompType), resultArray.getType().getComponentType()));
        return forLoop;
    }

    protected IRExpression compileExpansionUsingArrayList(IType rootType, IType rootComponentType, IType resultType, IType resultCompType, IType propertyType) {
        IRSymbol tempRoot = this._cc().makeAndIndexTempSymbol(AbstractMemberExpansionTransformer.getDescriptor(rootType));
        IRAssignmentStatement tempRootAssignment = this.buildAssignment(tempRoot, ExpressionTransformer.compile(((IMemberAccessExpression)this._expr()).getRootExpression(), this._cc()));
        IRSymbol resultArrayList = this._cc().makeAndIndexTempSymbol(AbstractMemberExpansionTransformer.getDescriptor((IType)JavaTypes.ARRAY_LIST()));
        IRAssignmentStatement arrayListCreation = this.buildAssignment(resultArrayList, this.buildNewExpression(ArrayList.class, new Class[0], AbstractMemberExpansionTransformer.exprList(new IRExpression[0])));
        IRForEachStatement forLoop = this.createArrayListAddLoop(rootType, rootComponentType, resultCompType, tempRoot, resultArrayList, propertyType);
        IRExpression listToArrayConversion = this.convertListToArray(resultType, resultCompType, resultArrayList);
        return this.buildComposite(new IRElement[]{tempRootAssignment, arrayListCreation, forLoop, listToArrayConversion});
    }

    private IRForEachStatement createArrayListAddLoop(IType rootType, IType rootComponentType, IType resultCompType, IRSymbol tempRoot, IRSymbol resultArrayList, IType propertyType) {
        IRMethodCallStatement loopBody;
        Symbol loopIdentifier = new Symbol(this._cc().makeTempSymbolName(), rootComponentType, null);
        IRForEachStatement forLoop = ForEachStatementTransformer.makeLoop(this._cc(), (IRExpression)this.identifier(tempRoot), rootType, loopIdentifier, null);
        IRSymbol irLoopIdentifier = this._cc().getSymbol(loopIdentifier.getName());
        if (propertyType.isArray()) {
            IRExpression resultAsCollection = this.callStaticMethod(AbstractMemberExpansionTransformer.class, "arrayToCollection", new Class[]{Object.class}, AbstractMemberExpansionTransformer.exprList(this.createIterationExpr(rootComponentType, irLoopIdentifier.getName(), rootComponentType, resultCompType)));
            loopBody = this.buildMethodCall(this.callMethod(ArrayList.class, "addAll", new Class[]{Collection.class}, (IRExpression)this.identifier(resultArrayList), AbstractMemberExpansionTransformer.exprList(resultAsCollection)));
        } else {
            loopBody = this.buildMethodCall(this.callMethod(ArrayList.class, "add", new Class[]{Object.class}, (IRExpression)this.identifier(resultArrayList), AbstractMemberExpansionTransformer.exprList(this.boxValueToType(propertyType, this.createIterationExpr(rootComponentType, irLoopIdentifier.getName(), rootComponentType, resultCompType)))));
        }
        forLoop.setBody((IRStatement)new IRStatementList(false, new IRStatement[]{loopBody}));
        return forLoop;
    }

    private IRExpression convertListToArray(IType resultType, IType resultCompType, IRSymbol resultArrayList) {
        if (resultCompType.isPrimitive()) {
            return this.convertToPrimitiveArray(resultCompType, (IRExpression)this.identifier(resultArrayList));
        }
        IType arrayComponentType = this.getMoreSpecificType(resultCompType, resultType.getComponentType());
        IRExpression listToArrayCall = AbstractMemberExpansionTransformer.isBytecodeType(arrayComponentType) ? this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToArray", new Class[]{List.class, Class.class}, AbstractMemberExpansionTransformer.exprList(new IRExpression[]{this.identifier(resultArrayList), this.classLiteral(AbstractMemberExpansionTransformer.getDescriptor(arrayComponentType))})) : this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToArray", new Class[]{List.class, IType.class}, AbstractMemberExpansionTransformer.exprList(new IRExpression[]{this.identifier(resultArrayList), this.pushType(arrayComponentType)}));
        return this.checkCast(arrayComponentType.getArrayType(), listToArrayCall);
    }

    private IType getMoreSpecificType(IType type1, IType type2) {
        if (type1.isAssignableFrom(type2)) {
            return type2;
        }
        if (type2.isAssignableFrom(type1)) {
            return type1;
        }
        return type1;
    }

    private IRExpression convertToPrimitiveArray(IType compType, IRExpression listToConvert) {
        if (compType == JavaTypes.pBOOLEAN()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_boolean", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        if (compType == JavaTypes.pBYTE()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_byte", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        if (compType == JavaTypes.pCHAR()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_char", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        if (compType == JavaTypes.pDOUBLE()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_double", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        if (compType == JavaTypes.pFLOAT()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_float", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        if (compType == JavaTypes.pINT()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_int", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        if (compType == JavaTypes.pLONG()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_long", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        if (compType == JavaTypes.pSHORT()) {
            return this.callStaticMethod(AbstractMemberExpansionTransformer.class, "listToPrimitiveArray_short", new Class[]{List.class}, AbstractMemberExpansionTransformer.exprList(listToConvert));
        }
        throw new UnsupportedOperationException("Don't know how to handle primitive type: " + compType.getName());
    }

    public static boolean[] listToPrimitiveArray_boolean(List l) {
        int iCount = l.size();
        boolean[] array = new boolean[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = (Boolean)l.get(i);
        }
        return array;
    }

    public static byte[] listToPrimitiveArray_byte(List l) {
        int iCount = l.size();
        byte[] array = new byte[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = (Byte)l.get(i);
        }
        return array;
    }

    public static char[] listToPrimitiveArray_char(List l) {
        int iCount = l.size();
        char[] array = new char[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = ((Character)l.get(i)).charValue();
        }
        return array;
    }

    public static int[] listToPrimitiveArray_int(List l) {
        int iCount = l.size();
        int[] array = new int[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = (Integer)l.get(i);
        }
        return array;
    }

    public static short[] listToPrimitiveArray_short(List l) {
        int iCount = l.size();
        short[] array = new short[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = (Short)l.get(i);
        }
        return array;
    }

    public static long[] listToPrimitiveArray_long(List l) {
        int iCount = l.size();
        long[] array = new long[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = (Long)l.get(i);
        }
        return array;
    }

    public static float[] listToPrimitiveArray_float(List l) {
        int iCount = l.size();
        float[] array = new float[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = ((Float)l.get(i)).floatValue();
        }
        return array;
    }

    public static double[] listToPrimitiveArray_double(List l) {
        int iCount = l.size();
        double[] array = new double[iCount];
        for (int i = 0; i < iCount; ++i) {
            array[i] = (Double)l.get(i);
        }
        return array;
    }

    public static Object listToArray(List l, IType compType) {
        int iCount = l.size();
        Object array = compType.makeArrayInstance(iCount);
        for (int i = 0; i < iCount; ++i) {
            compType.setArrayComponent(array, i, l.get(i));
        }
        return array;
    }

    public static Object listToArray(List l, Class compType) {
        int iCount = l.size();
        Object array = Array.newInstance((Class)compType, (int)iCount);
        for (int i = 0; i < iCount; ++i) {
            Array.set((Object)array, (int)i, l.get(i));
        }
        return array;
    }

    public static Collection arrayToCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof IGosuObject) {
            ArrayList<Object> col = new ArrayList<Object>();
            IType arrayType = ((IGosuObject)value).getIntrinsicType();
            int iLength = arrayType.getArrayLength(value);
            for (int j = 0; j < iLength; ++j) {
                col.add(arrayType.getArrayComponent(value, j));
            }
            return col;
        }
        if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> col = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength((Object)value); ++i) {
                col.add(Array.get((Object)value, (int)i));
            }
            return col;
        }
        throw new IllegalArgumentException("Cannot turn value of type " + value.getClass() + " into an array");
    }
}

