/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.ArithmeticExpressionTransformer;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.expressions.AdditiveExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.IDimension;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.ir.expression.IRStringLiteralExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

public class AdditiveExpressionTransformer
extends ArithmeticExpressionTransformer<AdditiveExpression> {
    private final StringBuilderHandle _stringBuilderFromParent;

    public static IRExpression compile(TopLevelTransformationContext cc, AdditiveExpression expr) {
        return AdditiveExpressionTransformer.compile(cc, expr, null);
    }

    public static IRExpression compile(TopLevelTransformationContext cc, AdditiveExpression expr, StringBuilderHandle stringBuilder) {
        AdditiveExpressionTransformer gen = new AdditiveExpressionTransformer(cc, expr, stringBuilder);
        return gen.compile();
    }

    private AdditiveExpressionTransformer(TopLevelTransformationContext cc, AdditiveExpression expr, StringBuilderHandle stringBuilderFromParent) {
        super(cc, expr);
        this._stringBuilderFromParent = stringBuilderFromParent;
    }

    @Override
    protected IRExpression compile_impl() {
        IRExpression expr = this.compileNumericArithmetic();
        if (expr != null) {
            return expr;
        }
        if (this.isCompileTimeConstantConcatenation()) {
            return this.concatenate();
        }
        if (this.isStringConcatenation()) {
            return this.stringConcatenation();
        }
        IType dimensionType = AdditiveExpressionTransformer.findDimensionType(((AdditiveExpression)this._expr()).getType());
        if (dimensionType != null) {
            return this.dimensionAddition(dimensionType);
        }
        return this.dynamicAddition();
    }

    private IRExpression dimensionAddition(IType type) {
        IRExpression lhs = ExpressionTransformer.compile(((AdditiveExpression)this._expr()).getLHS(), this._cc());
        IRExpression rhs = ExpressionTransformer.compile(((AdditiveExpression)this._expr()).getRHS(), this._cc());
        IRSymbol tempLhsInit = this._cc().makeAndIndexTempSymbol(AdditiveExpressionTransformer.getDescriptor(((AdditiveExpression)this._expr()).getLHS().getType()));
        IRAssignmentStatement tempLhsInitAssn = this.buildAssignment(tempLhsInit, lhs);
        IRSymbol tempRhsInit = this._cc().makeAndIndexTempSymbol(AdditiveExpressionTransformer.getDescriptor(((AdditiveExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsInitAssn = this.buildAssignment(tempRhsInit, rhs);
        if (((AdditiveExpression)this._expr()).isNullSafe()) {
            return this.buildComposite(new IRElement[]{tempLhsInitAssn, tempRhsInitAssn, this.buildCast(AdditiveExpressionTransformer.getDescriptor(((AdditiveExpression)this._expr()).getType()), this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhsInit), this.nullLiteral()), this.nullLiteral(), this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhsInit), this.nullLiteral()), this.nullLiteral(), type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER() ? this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(tempLhsInit), Collections.singletonList(this.callMethod(((IJavaType)type).getBackingClassInfo(), ((AdditiveExpression)this._expr()).isAdditive() ? "add" : "subtract", new Class[]{type == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class}, this.checkCast(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempLhsInit), Collections.emptyList())), Collections.singletonList(this.checkCast(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempRhsInit), Collections.emptyList())))))) : this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(tempLhsInit), Collections.singletonList(this.boxValueToType(type, (IRExpression)new IRArithmeticExpression(AdditiveExpressionTransformer.getDescriptor(TypeSystem.getPrimitiveType((IType)type)), this.unboxValueFromType(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempLhsInit), Collections.emptyList())), this.unboxValueFromType(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempRhsInit), Collections.emptyList())), ((AdditiveExpression)this._expr()).isAdditive() ? IRArithmeticExpression.Operation.Addition : IRArithmeticExpression.Operation.Subtraction)))), AdditiveExpressionTransformer.getDescriptor(((AdditiveExpression)this._expr()).getType())), AdditiveExpressionTransformer.getDescriptor(((AdditiveExpression)this._expr()).getType())))});
        }
        return this.buildComposite(new IRElement[]{tempLhsInitAssn, tempRhsInitAssn, this.buildCast(AdditiveExpressionTransformer.getDescriptor(((AdditiveExpression)this._expr()).getType()), type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER() ? this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(tempLhsInit), Collections.singletonList(this.callMethod(((IJavaType)type).getBackingClassInfo(), ((AdditiveExpression)this._expr()).isAdditive() ? "add" : "subtract", new Class[]{type == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class}, this.checkCast(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempLhsInit), Collections.emptyList())), Collections.singletonList(this.checkCast(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempRhsInit), Collections.emptyList())))))) : this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(tempLhsInit), Collections.singletonList(this.boxValueToType(type, (IRExpression)new IRArithmeticExpression(AdditiveExpressionTransformer.getDescriptor(TypeSystem.getPrimitiveType((IType)type)), this.unboxValueFromType(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempLhsInit), Collections.emptyList())), this.unboxValueFromType(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempRhsInit), Collections.emptyList())), ((AdditiveExpression)this._expr()).isAdditive() ? IRArithmeticExpression.Operation.Addition : IRArithmeticExpression.Operation.Subtraction)))))});
    }

    private IRStringLiteralExpression concatenate() {
        return (IRStringLiteralExpression)this.pushConstant(GosuRuntimeMethods.toString(((AdditiveExpression)this._expr()).getLHS().evaluate()) + GosuRuntimeMethods.toString(((AdditiveExpression)this._expr()).getRHS().evaluate()));
    }

    private IRExpression dynamicAddition() {
        boolean bNumeric = BeanAccess.isNumericType(((AdditiveExpression)this._expr()).getType());
        IRExpression evaluateCall = this.callStaticMethod(AdditiveExpression.class, "evaluate", new Class[]{IType.class, Object.class, Object.class, IType.class, IType.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, AdditiveExpressionTransformer.exprList(this.pushType(((AdditiveExpression)this._expr()).getType()), this.boxValue(((AdditiveExpression)this._expr()).getLHS().getType(), ExpressionTransformer.compile(((AdditiveExpression)this._expr()).getLHS(), this._cc())), this.boxValue(((AdditiveExpression)this._expr()).getRHS().getType(), ExpressionTransformer.compile(((AdditiveExpression)this._expr()).getRHS(), this._cc())), this.pushType(((AdditiveExpression)this._expr()).getLHS().getType()), this.pushType(((AdditiveExpression)this._expr()).getRHS().getType()), this.pushConstant(((AdditiveExpression)this._expr()).isAdditive()), this.pushConstant(((AdditiveExpression)this._expr()).isNullSafe()), this.pushConstant(bNumeric)));
        return this.unboxValueToType(((AdditiveExpression)this._expr()).getType(), evaluateCall);
    }

    private boolean isCompileTimeConstantConcatenation() {
        return ((AdditiveExpression)this._expr()).getType() == JavaTypes.STRING() && ((AdditiveExpression)this._expr()).isCompileTimeConstant() && !this.containsIdentifier((IParsedElement)(((AdditiveExpression)this._expr()).isAssignment() ? ((AdditiveExpression)this._expr()).getParent() : this._expr()));
    }

    private boolean containsIdentifier(IParsedElement expr) {
        if (expr instanceof Identifier && !((Identifier)expr).isStaticFinalInitializedCompileTimeConstant()) {
            return true;
        }
        IParseTree location = expr.getLocation();
        if (location == null) {
            return true;
        }
        for (IParseTree child : location.getChildren()) {
            if (!this.containsIdentifier(child.getParsedElement())) continue;
            return true;
        }
        return false;
    }

    private IRExpression stringConcatenation() {
        StringBuilderHandle sbHandle = this._stringBuilderFromParent;
        if (sbHandle == null) {
            sbHandle = new StringBuilderHandle();
        }
        this.handleConcatOperand(sbHandle, ((AdditiveExpression)this._expr()).getLHS());
        this.handleConcatOperand(sbHandle, ((AdditiveExpression)this._expr()).getRHS());
        if (this._stringBuilderFromParent == null) {
            sbHandle.setStringBuilder(this.callMethod(StringBuilder.class, "toString", new Class[0], sbHandle.getStringBuilder(), Collections.emptyList()));
        }
        sbHandle.setAppendedToStringBuilder(true);
        return sbHandle.getStringBuilder();
    }

    private void handleConcatOperand(StringBuilderHandle sbHandle, Expression operand) {
        IType operandType = operand.getType();
        IRExpression expr = operand instanceof AdditiveExpression ? AdditiveExpressionTransformer.compile(this._cc(), (AdditiveExpression)operand, sbHandle) : ExpressionTransformer.compile(operand, this._cc());
        boolean bHandled = sbHandle.isAppendedToStringBuilder();
        sbHandle.setAppendedToStringBuilder(false);
        if (!bHandled) {
            IRExpression appendExpr;
            if (!operandType.isPrimitive()) {
                if (operandType == JavaTypes.STRING()) {
                    appendExpr = this.callMethod(StringBuilder.class, "append", new Class[]{String.class}, sbHandle.getStringBuilder(), Collections.singletonList(expr));
                } else if (JavaTypes.CHAR_SEQUENCE().isAssignableFrom(operandType)) {
                    appendExpr = this.callMethod(StringBuilder.class, "append", new Class[]{CharSequence.class}, sbHandle.getStringBuilder(), Collections.singletonList(expr));
                } else if (JavaTypes.pCHAR().getArrayType().isAssignableFrom(operandType)) {
                    appendExpr = this.callMethod(StringBuilder.class, "append", new Class[]{char[].class}, sbHandle.getStringBuilder(), Collections.singletonList(expr));
                } else if (ILanguageLevel.Util.STANDARD_GOSU() || !this.isHandledByCustomCoercion(operandType)) {
                    appendExpr = this.callMethod(StringBuilder.class, "append", new Class[]{Object.class}, sbHandle.getStringBuilder(), Collections.singletonList(expr));
                } else {
                    appendExpr = this.callMethod(ICoercionManager.class, "makeStringFrom", new Class[]{Object.class}, this.callStaticMethod(CommonServices.class, "getCoercionManager", new Class[0], Collections.emptyList()), Collections.singletonList(expr));
                    appendExpr = this.callMethod(StringBuilder.class, "append", new Class[]{String.class}, sbHandle.getStringBuilder(), Collections.singletonList(appendExpr));
                }
            } else {
                Class<Object> primitiveClass = AdditiveExpressionTransformer.getDescriptor(operandType).getJavaClass();
                primitiveClass = primitiveClass == Void.TYPE ? Object.class : (primitiveClass == Short.TYPE || primitiveClass == Byte.TYPE ? Integer.TYPE : primitiveClass);
                appendExpr = this.callMethod(StringBuilder.class, "append", new Class[]{primitiveClass}, sbHandle.getStringBuilder(), Collections.singletonList(primitiveClass == Object.class ? this.nullLiteral() : expr));
            }
            sbHandle.setStringBuilder(appendExpr);
        } else {
            sbHandle.setStringBuilder(expr);
        }
    }

    private boolean isStringConcatenation() {
        return ((AdditiveExpression)this._expr()).getType() == JavaTypes.STRING();
    }

    private class StringBuilderHandle {
        private IRExpression _stringBuilder;
        private boolean _bAppendedToStringBuilder;

        private StringBuilderHandle() {
            this._stringBuilder = AdditiveExpressionTransformer.this.buildNewExpression(StringBuilder.class, new Class[0], (List<IRExpression>)Collections.emptyList());
        }

        private IRExpression getStringBuilder() {
            return this._stringBuilder;
        }

        private void setStringBuilder(IRExpression stringBuilder) {
            this._stringBuilder = stringBuilder;
        }

        private boolean isAppendedToStringBuilder() {
            return this._bAppendedToStringBuilder;
        }

        private void setAppendedToStringBuilder(boolean bAppendedToStringBuilder) {
            this._bAppendedToStringBuilder = bAppendedToStringBuilder;
        }
    }
}

