/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.ArrayAccess;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayAccessTransformer
extends AbstractExpressionTransformer<ArrayAccess> {
    public static IRExpression compile(TopLevelTransformationContext cc, ArrayAccess expr) {
        ArrayAccessTransformer compiler = new ArrayAccessTransformer(cc, expr);
        return compiler.compile();
    }

    private ArrayAccessTransformer(TopLevelTransformationContext cc, ArrayAccess expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IRExpression arrayAccess;
        IRExpression index;
        IRExpression root;
        boolean bNullSafe;
        IRExpression originalRoot = ExpressionTransformer.compile(((ArrayAccess)this._expr()).getRootExpression(), this._cc());
        IRSymbol tempRoot = null;
        boolean needsAutoinsert = ArrayAccess.needsAutoinsert((ArrayAccess)this.getParsedElement());
        boolean bStandardGosu = CommonServices.getEntityAccess().getLanguageLevel().isStandard();
        boolean bl = bNullSafe = ((ArrayAccess)this._expr()).isNullSafe() || !bStandardGosu && !((ArrayAccess)this._expr()).getType().isPrimitive() || needsAutoinsert && !((ArrayAccess)this._expr()).getType().isPrimitive();
        if (bNullSafe || needsAutoinsert) {
            tempRoot = this._cc().makeAndIndexTempSymbol(originalRoot.getType());
            root = this.identifier(tempRoot);
        } else {
            root = originalRoot;
        }
        IRExpression originalIndex = ExpressionTransformer.compile(((ArrayAccess)this._expr()).getMemberExpression(), this._cc());
        IRSymbol tempIndex = null;
        if (needsAutoinsert) {
            tempIndex = this._cc().makeAndIndexTempSymbol(originalIndex.getType());
            index = this.identifier(tempIndex);
        } else {
            index = originalIndex;
        }
        IType rootType = ((ArrayAccess)this._expr()).getRootExpression().getType();
        boolean skip = false;
        if (rootType.isArray() && ArrayAccessTransformer.isBytecodeType(rootType)) {
            arrayAccess = this.buildArrayLoad(root, index, ArrayAccessTransformer.getDescriptor(rootType.getComponentType()));
        } else {
            if (JavaTypes.LIST().isAssignableFrom(rootType)) {
                arrayAccess = this.buildMethodCall(List.class, "get", Object.class, new Class[]{Integer.TYPE}, this.buildCast(ArrayAccessTransformer.getDescriptor(List.class), root), Collections.singletonList(index));
            } else if (JavaTypes.COLLECTION().isAssignableFrom(rootType)) {
                IRMethodCallExpression iterExpr = this.buildMethodCall(Collection.class, "iterator", Iterator.class, new Class[0], this.buildCast(ArrayAccessTransformer.getDescriptor(Collection.class), root), Collections.emptyList());
                arrayAccess = this.callStaticMethod(ArrayAccess.class, "getElementFromIterator", new Class[]{Iterator.class, Integer.TYPE}, Arrays.asList(iterExpr, index));
            } else if (JavaTypes.ITERATOR().isAssignableFrom(rootType)) {
                arrayAccess = this.callStaticMethod(ArrayAccess.class, "getElementFromIterator", new Class[]{Iterator.class, Integer.TYPE}, Arrays.asList(this.buildCast(ArrayAccessTransformer.getDescriptor(Iterator.class), root), index));
            } else if (JavaTypes.CHAR_SEQUENCE().isAssignableFrom(rootType)) {
                arrayAccess = this.buildMethodCall(CharSequence.class, "charAt", Character.TYPE, new Class[]{Integer.TYPE}, this.buildCast(ArrayAccessTransformer.getDescriptor(CharSequence.class), root), Collections.singletonList(index));
                skip = true;
            } else {
                arrayAccess = rootType instanceof IPlaceholder && ((IPlaceholder)rootType).isPlaceholder() ? this.callStaticMethod(ArrayAccessTransformer.class, "dynamicAccess", new Class[]{Object.class, Object.class, Boolean.TYPE}, ArrayAccessTransformer.exprList(root, this.boxValue(index.getType(), index), this.pushConstant(bNullSafe))) : this.callStaticMethod(ArrayAccess.class, "getArrayElement", new Class[]{Object.class, Integer.TYPE, Boolean.TYPE}, ArrayAccessTransformer.exprList(root, index, this.pushConstant(bNullSafe)));
            }
            if (!skip) {
                arrayAccess = this.unboxOrCast(arrayAccess);
            }
        }
        if (needsAutoinsert) {
            IType typeToAutoInsert = ArrayAccess.getTypeToAutoInsert(((ArrayAccess)this.getParsedElement()).getRootExpression());
            arrayAccess = this.buildComposite(new IRElement[]{this.buildMethodCall(this.callStaticMethod(ArrayAccessTransformer.class, "maybeAutoInsert", new Class[]{Object.class, Integer.TYPE, IType.class}, Arrays.asList(this.identifier(tempRoot), this.identifier(tempIndex), this.pushType(typeToAutoInsert)))), arrayAccess});
        }
        if (tempRoot != null) {
            IRCompositeExpression composite = new IRCompositeExpression(new IRElement[0]);
            composite.addElement((IRElement)this.buildAssignment(tempRoot, originalRoot));
            if (tempIndex != null) {
                composite.addElement((IRElement)this.buildAssignment(tempIndex, originalIndex));
            }
            if (((ArrayAccess)this._expr()).getType().isPrimitive()) {
                composite.addElement((IRElement)this.buildNullCheckTernary((IRExpression)this.identifier(tempRoot), this.shortCircuitValue(arrayAccess.getType()), arrayAccess));
            } else {
                composite.addElement((IRElement)this.buildNullCheckTernary((IRExpression)this.identifier(tempRoot), this.checkCast(((ArrayAccess)this._expr()).getType(), this.nullLiteral()), this.checkCast(((ArrayAccess)this._expr()).getType(), arrayAccess)));
            }
            return composite;
        }
        return arrayAccess;
    }

    private IRExpression unboxOrCast(IRExpression arrayAccess) {
        arrayAccess = ((ArrayAccess)this._expr()).getType().isPrimitive() ? this.unboxValueToType(((ArrayAccess)this._expr()).getType(), arrayAccess) : this.checkCast(((ArrayAccess)this._expr()).getType(), arrayAccess);
        return arrayAccess;
    }

    public static void maybeAutoInsert(Object obj, int index, IType typeToAutoCreate) {
        List l = (List)obj;
        if (l.size() == index) {
            if (typeToAutoCreate.isAbstract() || typeToAutoCreate.isInterface()) {
                throw new IllegalStateException("Type " + typeToAutoCreate.getName() + " is abstract or an interface and has no default implementation class to use");
            }
            IConstructorInfo constructor = typeToAutoCreate.getTypeInfo().getConstructor(new IType[0]);
            if (constructor == null) {
                throw new IllegalStateException("Type " + typeToAutoCreate.getName() + " has no default constructor");
            }
            l.add(constructor.getConstructor().newInstance(new Object[0]));
        }
    }

    public static Object dynamicAccess(Object obj, Object elem, boolean bNullSafe) {
        if (obj == null || elem == null) {
            if (bNullSafe) {
                return null;
            }
            throw new NullPointerException();
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(elem);
        }
        if (elem instanceof Integer || elem instanceof Short || elem instanceof Byte) {
            return ArrayAccess.getArrayElement(obj, ((Number)elem).intValue(), bNullSafe);
        }
        return GosuRuntimeMethods.getPropertyDynamically(obj, elem.toString());
    }
}

