/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.IRMethodFromMethodInfo;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.BindingExpression;
import gw.lang.ir.IRExpression;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuMethodInfo;
import java.util.Collections;

public class BindingExpressionTransformer
extends AbstractExpressionTransformer<BindingExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, BindingExpression expr) {
        BindingExpressionTransformer compiler = new BindingExpressionTransformer(cc, expr);
        return compiler.compile();
    }

    private BindingExpressionTransformer(TopLevelTransformationContext cc, BindingExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IType rhsExprType;
        String bindMethodName = ((BindingExpression)this._expr()).isPrefix() ? "prefixBind" : "postfixBind";
        Expression rhsExpr = ((BindingExpression)this._expr()).isPrefix() ? ((BindingExpression)this._expr()).getLhsExpr() : ((BindingExpression)this._expr()).getRhsExpr();
        Expression lhsExpr = ((BindingExpression)this._expr()).isPrefix() ? ((BindingExpression)this._expr()).getRhsExpr() : ((BindingExpression)this._expr()).getLhsExpr();
        IType lhsExprType = lhsExpr.getType();
        if (lhsExprType.isPrimitive()) {
            lhsExprType = TypeLord.getBoxedTypeFromPrimitiveType(lhsExprType);
        }
        if ((rhsExprType = rhsExpr.getType()).isPrimitive()) {
            rhsExprType = TypeLord.getBoxedTypeFromPrimitiveType(rhsExprType);
        }
        IGosuMethodInfo bindMethod = (IGosuMethodInfo)rhsExprType.getTypeInfo().getCallableMethod((CharSequence)bindMethodName, new IType[]{lhsExprType});
        IType owner = TypeLord.getPureGenericType(bindMethod.getContainer().getOwnersType());
        bindMethod = (IGosuMethodInfo)owner.getTypeInfo().getCallableMethod((CharSequence)bindMethodName, new IType[]{lhsExprType});
        FunctionType funcType = new FunctionType((IMethodInfo)bindMethod);
        funcType = funcType.getRuntimeType();
        IRExpression irLhs = ExpressionTransformer.compile(lhsExpr, this._cc());
        IRExpression irRhs = ExpressionTransformer.compile(rhsExpr, this._cc());
        IRMethodFromMethodInfo irMethod = IRMethodFactory.createIRMethod((IMethodInfo)bindMethod, (IFunctionType)funcType);
        IRExpression bindCall = this.callMethod(irMethod, this.boxValue(irRhs.getType(), irRhs), Collections.singletonList(this.boxValue(irLhs.getType(), irLhs)));
        return this.buildCast(BindingExpressionTransformer.getDescriptor(((BindingExpression)this._expr()).getType()), bindCall);
    }
}

