/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.fragments.GosuFragment;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRTypeConstants;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import java.util.ArrayList;
import java.util.List;

public abstract class EvalBasedTransformer<T extends IExpression>
extends AbstractExpressionTransformer<T> {
    public EvalBasedTransformer(TopLevelTransformationContext cc, T parsedElem) {
        super(cc, parsedElem);
    }

    protected IRExpression pushEnclosingContext() {
        if (!this._cc().isCurrentFunctionStatic()) {
            return this.pushThisOrOuter((IType)this.getGosuClass());
        }
        return this.pushNull();
    }

    protected IRExpression pushCapturedSymbols(ICompilableTypeInternal enclosingClass, List<ICapturedSymbol> capturedSymbols) {
        ArrayList<IRExpression> values = new ArrayList<IRExpression>();
        if (capturedSymbols != null) {
            for (ICapturedSymbol sym : capturedSymbols) {
                if (enclosingClass.isAnonymous() && enclosingClass.getCapturedSymbols().containsKey(sym.getName())) {
                    values.add(this.getInstanceField((IType)this.getGosuClass(), "val$" + sym.getName(), EvalBasedTransformer.getDescriptor(sym.getType().getArrayType()), AccessibilityUtil.forCapturedVar(), this.pushThis()));
                    continue;
                }
                values.add((IRExpression)this.identifier(this._cc().getSymbol(sym.getName())));
            }
        }
        if (EvalBasedTransformer.requiresExternalSymbolCapture((IType)enclosingClass) || enclosingClass instanceof GosuFragment || enclosingClass instanceof IGosuProgram) {
            values.add(this.pushExternalSymbolsMap());
        }
        if (!values.isEmpty()) {
            return this.buildInitializedArray(IRTypeConstants.OBJECT(), values);
        }
        return this.pushNull();
    }

    protected static void addEnclosingTypeParams(LazyTypeResolver[] immediateFuncTypeParams, List<Object> args) {
        if (immediateFuncTypeParams != null) {
            for (int i = 0; i < immediateFuncTypeParams.length; ++i) {
                args.add(immediateFuncTypeParams[i]);
            }
        }
    }

    protected IRExpression pushEnclosingFunctionTypeParamsInArray(IParsedElement expr) {
        int iCount = this.getFunctionTypeParamsCount(expr);
        if (iCount == 0) {
            return this.pushNull();
        }
        ArrayList<IRExpression> values = new ArrayList<IRExpression>();
        IGosuClassInternal gsClass = null;
        while (expr != null && expr.getLocation() != null) {
            IDynamicFunctionSymbol dfs;
            IFunctionStatement funcStmt = expr.getLocation().getEnclosingFunctionStatement();
            if (funcStmt != null && (dfs = funcStmt.getDynamicFunctionSymbol()).getType().isGenericType() && Modifier.isReified((int)dfs.getModifiers())) {
                IGenericTypeVariable[] genTypeVars = dfs.getType().getGenericTypeVariables();
                for (int i = 0; i < genTypeVars.length; ++i) {
                    if (gsClass == null) {
                        values.add((IRExpression)this.identifier(this._cc().getSymbol(this.getTypeVarParamName(genTypeVars[i]))));
                        continue;
                    }
                    this.pushThisOrOuter((IType)gsClass);
                    values.add(this.getInstanceField((IType)gsClass, "typeparam$" + genTypeVars[i].getName(), EvalBasedTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushThisOrOuter((IType)gsClass)));
                }
                return this.buildInitializedArray(EvalBasedTransformer.getDescriptor(LazyTypeResolver.class), values);
            }
            IType type = funcStmt.getDynamicFunctionSymbol().getScriptPart().getContainingType();
            if (type instanceof IGosuClass && ((IGosuClass)type).isAnonymous()) {
                gsClass = (IGosuClassInternal)type;
                expr = EvalBasedTransformer.isEvalProgram(gsClass) ? ((IGosuProgram)gsClass).getEnclosingEvalExpression() : gsClass.getClassStatement();
                continue;
            }
            expr = null;
        }
        throw new IllegalStateException("Should have found the appropriate enclosing context ");
    }

    protected int getFunctionTypeParamsCount(IParsedElement pe) {
        int iCount = 0;
        while (pe != null && pe.getLocation() != null) {
            IFunctionStatement funcStmt = pe.getLocation().getEnclosingFunctionStatement();
            if (funcStmt != null) {
                IType type;
                IDynamicFunctionSymbol dfs = funcStmt.getDynamicFunctionSymbol();
                if (dfs.getType().isGenericType()) {
                    IGenericTypeVariable[] genTypeVars = dfs.getType().getGenericTypeVariables();
                    iCount += genTypeVars.length;
                }
                if ((type = funcStmt.getDynamicFunctionSymbol().getScriptPart().getContainingType()) instanceof IGosuClass && ((IGosuClass)type).isAnonymous()) {
                    IGosuClassInternal gsClass = (IGosuClassInternal)type;
                    pe = EvalBasedTransformer.isEvalProgram(gsClass) ? ((IGosuProgram)gsClass).getEnclosingEvalExpression() : gsClass.getClassStatement();
                    continue;
                }
                pe = null;
                continue;
            }
            pe = null;
        }
        return iCount;
    }
}

