/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.NumericLiteral;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRTypeConstants;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.Rational;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;

public class NumericLiteralTransformer
extends AbstractExpressionTransformer<NumericLiteral> {
    public static IRExpression compile(TopLevelTransformationContext cc, NumericLiteral expr) {
        NumericLiteralTransformer gen = new NumericLiteralTransformer(cc, expr);
        return gen.compile();
    }

    private NumericLiteralTransformer(TopLevelTransformationContext cc, NumericLiteral expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IType type = ((NumericLiteral)this._expr()).getType();
        if (type == JavaTypes.BIG_INTEGER()) {
            Number value = ((NumericLiteral)this._expr()).getValue();
            if (value.equals(BigInteger.ZERO) || value.equals(BigDecimal.ZERO) || !(value instanceof BigInteger) && !(value instanceof BigDecimal) && !(value instanceof Rational) && value.longValue() == 0L) {
                return this.getStaticField((IType)JavaTypes.BIG_INTEGER(), "ZERO", NumericLiteralTransformer.getDescriptor((IType)JavaTypes.BIG_INTEGER()), IRelativeTypeInfo.Accessibility.PUBLIC);
            }
            if (value.equals(BigInteger.ONE) || value.equals(BigDecimal.ONE) || !(value instanceof BigInteger) && !(value instanceof BigDecimal) && !(value instanceof Rational) && value.longValue() == 1L) {
                return this.getStaticField((IType)JavaTypes.BIG_INTEGER(), "ONE", NumericLiteralTransformer.getDescriptor((IType)JavaTypes.BIG_INTEGER()), IRelativeTypeInfo.Accessibility.PUBLIC);
            }
            return this.buildNewExpression(NumericLiteralTransformer.getDescriptor(type), Arrays.asList(IRTypeConstants.STRING()), Collections.singletonList(this.stringLiteral(((NumericLiteral)this._expr()).getValue().toString())));
        }
        if (type == JavaTypes.BIG_DECIMAL()) {
            Number value = ((NumericLiteral)this._expr()).getValue();
            if (value.equals(BigInteger.ZERO) || value.equals(BigDecimal.ZERO) || !(value instanceof BigInteger) && !(value instanceof BigDecimal) && !(value instanceof Rational) && value.longValue() == 0L) {
                return this.getStaticField((IType)JavaTypes.BIG_DECIMAL(), "ZERO", NumericLiteralTransformer.getDescriptor((IType)JavaTypes.BIG_DECIMAL()), IRelativeTypeInfo.Accessibility.PUBLIC);
            }
            if (value.equals(BigInteger.ONE) || value.equals(BigDecimal.ONE) || !(value instanceof BigInteger) && !(value instanceof BigDecimal) && !(value instanceof Rational) && value.longValue() == 1L) {
                return this.getStaticField((IType)JavaTypes.BIG_DECIMAL(), "ONE", NumericLiteralTransformer.getDescriptor((IType)JavaTypes.BIG_DECIMAL()), IRelativeTypeInfo.Accessibility.PUBLIC);
            }
            return this.buildNewExpression(NumericLiteralTransformer.getDescriptor(type), Arrays.asList(IRTypeConstants.STRING()), Collections.singletonList(this.stringLiteral(((NumericLiteral)this._expr()).getValue().toString())));
        }
        if (type == JavaTypes.RATIONAL()) {
            Number value = ((NumericLiteral)this._expr()).getValue();
            if (value instanceof Rational) {
                if (((Rational)value).compareTo(Rational.ZERO) == 0) {
                    return this.getStaticField((IType)JavaTypes.RATIONAL(), "ZERO", NumericLiteralTransformer.getDescriptor((IType)JavaTypes.RATIONAL()), IRelativeTypeInfo.Accessibility.PUBLIC);
                }
                if (((Rational)value).compareTo(Rational.ONE) == 0) {
                    return this.getStaticField((IType)JavaTypes.RATIONAL(), "ONE", NumericLiteralTransformer.getDescriptor((IType)JavaTypes.RATIONAL()), IRelativeTypeInfo.Accessibility.PUBLIC);
                }
                if (((Rational)value).isInteger()) {
                    BigInteger numerator = ((Rational)value).getNumerator();
                    if (numerator.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && numerator.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0) {
                        return this.buildMethodCall(Rational.class, "get", Rational.class, new Class[]{Long.TYPE}, null, Collections.singletonList(this.pushConstant(numerator.longValue())));
                    }
                    return this.buildMethodCall(Rational.class, "get", Rational.class, new Class[]{BigInteger.class}, null, Collections.singletonList(this.buildNewExpression(BigInteger.class, new Class[]{String.class}, Collections.singletonList(this.pushConstant(((Rational)value).getNumerator().toString())))));
                }
                BigInteger numerator = ((Rational)value).getNumerator();
                BigInteger denominator = ((Rational)value).getDenominator();
                if (numerator.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && numerator.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0 && denominator.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && denominator.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0) {
                    return this.buildMethodCall(Rational.class, "get", Rational.class, new Class[]{Long.TYPE, Long.TYPE}, null, Arrays.asList(this.pushConstant(numerator.longValue()), this.pushConstant(denominator.longValue())));
                }
                return this.buildMethodCall(Rational.class, "get", Rational.class, new Class[]{BigInteger.class, BigInteger.class}, null, Arrays.asList(this.buildNewExpression(BigInteger.class, new Class[]{String.class}, Collections.singletonList(this.pushConstant(numerator.toString()))), this.buildNewExpression(BigInteger.class, new Class[]{String.class}, Collections.singletonList(this.pushConstant(denominator.toString())))));
            }
            return this.buildMethodCall(NumericLiteralTransformer.getDescriptor(type), "get", false, NumericLiteralTransformer.getDescriptor((IType)JavaTypes.RATIONAL()), Collections.singletonList(IRTypeConstants.STRING()), null, Collections.singletonList(this.stringLiteral(((NumericLiteral)this._expr()).getValue().toString())));
        }
        Number value = this.getValueOfProperType(type);
        IRExpression expression = this.pushConstant(value);
        if (!type.isPrimitive()) {
            expression = this.boxValueToType(type, expression);
        }
        return expression;
    }

    private Number getValueOfProperType(IType type) {
        Number value = ((NumericLiteral)this._expr()).getValue();
        if (type == JavaTypes.pDOUBLE() || type == JavaTypes.DOUBLE()) {
            value = new Double(value.doubleValue());
        }
        if (type == JavaTypes.pLONG() || type == JavaTypes.LONG()) {
            value = new Long(value.longValue());
        }
        return value;
    }
}

