/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.config.CommonServices;
import gw.internal.gosu.coercer.FunctionToInterfaceClassGenerator;
import gw.internal.gosu.ir.nodes.IRTypeFactory;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.CompoundType;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.IDimension;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRConditionalOrExpression;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRInstanceOfExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.ICoercer;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.coercers.BasePrimitiveCoercer;
import gw.lang.parser.coercers.BlockCoercer;
import gw.lang.parser.coercers.FeatureReferenceToBlockCoercer;
import gw.lang.parser.coercers.FunctionFromInterfaceCoercer;
import gw.lang.parser.coercers.IdentityCoercer;
import gw.lang.parser.coercers.MetaTypeToClassCoercer;
import gw.lang.parser.coercers.MethodReferenceCoercer;
import gw.lang.parser.coercers.RuntimeCoercer;
import gw.lang.parser.coercers.StringCoercer;
import gw.lang.parser.expressions.ITypeAsExpression;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableArrayType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.features.BlockWrapper;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IMethodReference;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.GosuTypes;
import gw.lang.reflect.java.JavaTypes;
import gw.util.concurrent.LockingLazyVar;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;

public class TypeAsTransformer
extends AbstractExpressionTransformer<ITypeAsExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, ITypeAsExpression expr) {
        TypeAsTransformer gen = new TypeAsTransformer(cc, expr);
        return gen.compile();
    }

    private TypeAsTransformer(TopLevelTransformationContext cc, ITypeAsExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IRExpression root = ExpressionTransformer.compile(((ITypeAsExpression)this._expr()).getLHS(), this._cc());
        IType asType = ((ITypeAsExpression)this._expr()).getType();
        IType lhsType = ((ITypeAsExpression)this._expr()).getLHS().getType();
        IType concreteType = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(lhsType, lhsType.getEnclosingType());
        if (asType.getName().equals(GosuTypes.IMONITORLOCK().getName())) {
            return root;
        }
        if (lhsType == asType || concreteType == asType) {
            return root;
        }
        lhsType = concreteType;
        if (lhsType == JavaTypes.pVOID()) {
            if (!ILanguageLevel.Util.STANDARD_GOSU() && asType.isPrimitive()) {
                if (TypeAsTransformer.isNumberType(asType)) {
                    return this.convertNullToPrimitive(asType);
                }
                if (asType == JavaTypes.pBOOLEAN()) {
                    return this.booleanLiteral(false);
                }
                return root;
            }
            return this.checkCast(asType, root);
        }
        if (asType == JavaTypes.pVOID()) {
            return root;
        }
        if (this.isPrimitiveNumberType(asType) && this.isPrimitiveNumberType(lhsType)) {
            return this.numberConvert(lhsType, asType, root);
        }
        if (asType == JavaTypes.pBOOLEAN()) {
            if (lhsType == JavaTypes.BOOLEAN()) {
                IRSymbol tempRoot = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsType));
                IRAssignmentStatement tempRootAssn = this.buildAssignment(tempRoot, root);
                return this.buildComposite(new IRElement[]{tempRootAssn, this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRoot), this.nullLiteral()), this.booleanLiteral(false), this.callMethod(Boolean.class, "booleanValue", new Class[0], (IRExpression)this.identifier(tempRoot), Collections.emptyList()), TypeAsTransformer.getDescriptor(Boolean.TYPE))});
            }
            if (TypeAsTransformer.isNumberType(lhsType)) {
                IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(((ITypeAsExpression)this._expr()).getLHS().getType()));
                IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
                IRSymbol tempLhsRet = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(Integer.TYPE));
                IRAssignmentStatement lhsConversionAssn = this.convertOperandToPrimitive((IType)JavaTypes.pINT(), ((ITypeAsExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhs), tempLhsRet);
                IRCompositeExpression compareExpr = this.buildComposite(new IRElement[]{lhsConversionAssn, this.buildNotEquals((IRExpression)this.identifier(tempLhsRet), this.numericLiteral(0))});
                IRCompositeExpression expr = ((ITypeAsExpression)this._expr()).getLHS().getType().isPrimitive() ? compareExpr : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.booleanLiteral(false), (IRExpression)compareExpr, TypeAsTransformer.getDescriptor(Boolean.TYPE));
                return this.buildComposite(new IRElement[]{tempLhsAssn, expr});
            }
        }
        if (asType == JavaTypes.BOOLEAN()) {
            if (lhsType == JavaTypes.pBOOLEAN()) {
                return this.callStaticMethod(Boolean.class, "valueOf", new Class[]{Boolean.TYPE}, Collections.singletonList(root));
            }
            if (TypeAsTransformer.isNumberType(lhsType)) {
                IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(((ITypeAsExpression)this._expr()).getLHS().getType()));
                IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
                IRSymbol tempLhsRet = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(Integer.TYPE));
                IRAssignmentStatement lhsConversionAssn = this.convertOperandToPrimitive((IType)JavaTypes.pINT(), ((ITypeAsExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhs), tempLhsRet);
                IRCompositeExpression compareExpr = this.buildComposite(new IRElement[]{lhsConversionAssn, this.buildNotEquals((IRExpression)this.identifier(tempLhsRet), this.numericLiteral(0))});
                IRExpression expr = ((ITypeAsExpression)this._expr()).getLHS().getType().isPrimitive() ? this.boxValue(TypeAsTransformer.getDescriptor(Boolean.TYPE), (IRExpression)compareExpr) : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.nullLiteral(), this.boxValue(TypeAsTransformer.getDescriptor(Boolean.TYPE), (IRExpression)compareExpr), TypeAsTransformer.getDescriptor(Boolean.class));
                return this.buildComposite(new IRElement[]{tempLhsAssn, expr});
            }
        }
        IRType asTypeDesc = TypeAsTransformer.getDescriptor(asType);
        if (TypeAsTransformer.isBigType(asType) && (TypeAsTransformer.isNumberType(lhsType) || TypeAsTransformer.isBigType(lhsType) || lhsType == JavaTypes.RATIONAL())) {
            IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsType));
            IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
            IRSymbol tempRet = this._cc().makeAndIndexTempSymbol(asTypeDesc);
            return this.buildComposite(new IRElement[]{tempLhsAssn, lhsType.isPrimitive() ? this.buildComposite(new IRElement[]{this.convertOperandToBig(asType, asType == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class, lhsType, (IRExpression)this.identifier(tempLhs), tempRet), this.identifier(tempRet)}) : this.checkCast(asType, this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.nullLiteral(), (IRExpression)this.buildComposite(new IRElement[]{this.convertOperandToBig(asType, asType == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class, lhsType, (IRExpression)this.identifier(tempLhs), tempRet), this.identifier(tempRet)}), asTypeDesc))});
        }
        if (TypeAsTransformer.isNumberType(asType)) {
            if (TypeAsTransformer.isNumberType(lhsType)) {
                if (StandardCoercionManager.isBoxed((IType)lhsType)) {
                    IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsType));
                    IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
                    root = this.unboxValueFromType(lhsType, (IRExpression)this.identifier(tempLhs));
                    IType primitiveTypeAsType = asType.isPrimitive() ? asType : TypeSystem.getPrimitiveType((IType)asType);
                    root = this.numberConvert(TypeSystem.getPrimitiveType((IType)lhsType), primitiveTypeAsType, root);
                    if (StandardCoercionManager.isBoxed((IType)asType)) {
                        root = this.boxValueToType(asType, root);
                    }
                    IRElement[] iRElementArray = new IRElement[2];
                    iRElementArray[0] = tempLhsAssn;
                    iRElementArray[1] = this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), (IRExpression)(asType.isPrimitive() ? (ILanguageLevel.Util.STANDARD_GOSU() ? this.buildComposite(new IRElement[]{this.buildThrow(this.buildNewExpression(TypeAsTransformer.getDescriptor(NullPointerException.class), Collections.emptyList(), Collections.emptyList()))}) : this.convertBoxedNullToPrimitive(TypeLord.getBoxedTypeFromPrimitiveType(asType))) : this.nullLiteral()), root, asTypeDesc);
                    return this.buildComposite(iRElementArray);
                }
                IType primitiveTypeAsType = asType.isPrimitive() ? asType : TypeSystem.getPrimitiveType((IType)asType);
                root = this.numberConvert(lhsType, primitiveTypeAsType, root);
                if (StandardCoercionManager.isBoxed((IType)asType)) {
                    root = this.boxValueToType(asType, root);
                }
                return root;
            }
            if (TypeAsTransformer.isBigType(lhsType)) {
                return this.convertBigToPrimitiveOrBoxed(root, asType, lhsType, asTypeDesc, lhsType == JavaTypes.BIG_DECIMAL());
            }
            if (lhsType == JavaTypes.RATIONAL()) {
                return this.convertBigToPrimitiveOrBoxed(root, asType, lhsType, asTypeDesc, true);
            }
        }
        if (asType == JavaTypes.OBJECT() && lhsType.isPrimitive()) {
            return this.boxValue(lhsType, root);
        }
        if (asType.isPrimitive() && lhsType == JavaTypes.OBJECT()) {
            IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsType));
            IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
            IRExpression expr = this.buildTernary((IRExpression)new IRInstanceOfExpression((IRExpression)this.identifier(tempLhs), IRTypeFactory.get(TypeLord.getBoxedTypeFromPrimitiveType(asType))), this.unboxValueToType(asType, (IRExpression)this.identifier(tempLhs)), this.callStaticMethod(TypeAsTransformer.class, "convertToPrimitiveFromBoxOrString_" + asTypeDesc.getName(), new Class[]{Object.class}, Collections.singletonList(this.identifier(tempLhs))), asTypeDesc);
            return this.buildComposite(new IRElement[]{tempLhsAssn, expr});
        }
        if (asType.isInterface() && lhsType instanceof IBlockType) {
            IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsType));
            IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
            IGosuClass gsClass = FunctionToInterfaceClassGenerator.getBlockToInterfaceConversionClass(asType, (IType)this._cc().getGosuClass());
            return this.buildComposite(new IRElement[]{tempLhsAssn, this.buildNullCheckTernary((IRExpression)this.identifier(tempLhs), this.nullLiteral(), this.buildNewExpression(IRTypeFactory.get((IType)gsClass), Collections.singletonList(IRTypeFactory.get(JavaTypes.IBLOCK())), Collections.singletonList(this.identifier(tempLhs))))});
        }
        IType lhsDimensionNumberType = TypeAsTransformer.findDimensionType(lhsType);
        if (lhsDimensionNumberType != null && (TypeAsTransformer.isNumberType(asType) || TypeAsTransformer.isBigType(asType))) {
            lhsType = lhsDimensionNumberType;
            IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(root.getType());
            IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
            IRSymbol tempNumber = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsDimensionNumberType));
            IRStatementList tempNumberAssn = new IRStatementList(false, new IRStatement[]{tempLhsAssn, this.buildAssignment(tempNumber, this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.nullLiteral(), this.checkCast(lhsDimensionNumberType, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempLhs), Collections.emptyList())), TypeAsTransformer.getDescriptor(lhsDimensionNumberType)))});
            if (TypeAsTransformer.isNumberType(asType)) {
                if (TypeAsTransformer.isBigType(lhsType)) {
                    root = this.convertBigToPrimitiveOrBoxed((IRExpression)this.identifier(tempNumber), asType, lhsType, TypeAsTransformer.getDescriptor(lhsType), lhsType == JavaTypes.BIG_DECIMAL());
                } else if (lhsType == JavaTypes.RATIONAL()) {
                    root = this.convertBigToPrimitiveOrBoxed((IRExpression)this.identifier(tempNumber), asType, lhsType, TypeAsTransformer.getDescriptor(lhsType), true);
                } else {
                    root = this.unboxValueFromType(lhsType, (IRExpression)this.identifier(tempNumber));
                    IType primitiveTypeAsType = asType.isPrimitive() ? asType : TypeSystem.getPrimitiveType((IType)asType);
                    root = this.numberConvert(TypeSystem.getPrimitiveType((IType)lhsType), primitiveTypeAsType, root);
                    if (StandardCoercionManager.isBoxed((IType)asType)) {
                        root = this.boxValueToType(asType, root);
                    }
                }
                IRElement[] iRElementArray = new IRElement[2];
                iRElementArray[0] = tempNumberAssn;
                iRElementArray[1] = this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempNumber), this.nullLiteral()), (IRExpression)(asType.isPrimitive() ? (ILanguageLevel.Util.STANDARD_GOSU() ? this.buildComposite(new IRElement[]{this.buildThrow(this.buildNewExpression(TypeAsTransformer.getDescriptor(NullPointerException.class), Collections.emptyList(), Collections.emptyList()))}) : this.convertBoxedNullToPrimitive(TypeLord.getBoxedTypeFromPrimitiveType(asType))) : this.nullLiteral()), root, asTypeDesc);
                return this.buildComposite(iRElementArray);
            }
            if (TypeAsTransformer.isBigType(asType)) {
                IRSymbol tempRet = this._cc().makeAndIndexTempSymbol(asTypeDesc);
                return this.buildComposite(new IRElement[]{tempNumberAssn, lhsType.isPrimitive() ? this.buildComposite(new IRElement[]{this.convertOperandToBig(asType, asType == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class, lhsType, (IRExpression)this.identifier(tempNumber), tempRet), this.identifier(tempRet)}) : this.checkCast(asType, this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempNumber), this.nullLiteral()), this.nullLiteral(), (IRExpression)this.buildComposite(new IRElement[]{this.convertOperandToBig(asType, asType == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class, lhsType, (IRExpression)this.identifier(tempNumber), tempRet), this.identifier(tempRet)}), asTypeDesc))});
            }
            throw new IllegalStateException("Expecting only number or big type");
        }
        IRExpression asPrimitive = this.maybeMakePrimitive(root);
        if (asPrimitive != null) {
            return asPrimitive;
        }
        if (asType instanceof IMetaType && lhsType instanceof IMetaType) {
            return root;
        }
        if (asType instanceof IMetaType && TypeLord.getPureGenericType(lhsType) == JavaTypes.CLASS()) {
            return this.callStaticMethod(TypeSystem.class, "get", new Class[]{Class.class}, Collections.singletonList(root));
        }
        if (lhsType.isDynamic() && !TypeAsTransformer.isNumberType(asType) && (ILanguageLevel.Util.STANDARD_GOSU() || asType != JavaTypes.STRING())) {
            return this.checkCast(asType, root);
        }
        IRExpression result = this.callCoercer(root, lhsType);
        if (asType.isPrimitive()) {
            result = this.unboxValueToType(asType, result);
        }
        return result;
    }

    private IRExpression convertBigToPrimitiveOrBoxed(IRExpression root, IType asType, IType lhsType, IRType asTypeDesc, boolean bDecimal) {
        IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsType));
        IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, root);
        root = this.callMethod(Number.class, bDecimal ? "doubleValue" : "longValue", new Class[0], (IRExpression)this.identifier(tempLhs), Collections.emptyList());
        IType primitiveTypeAsType = asType.isPrimitive() ? asType : TypeSystem.getPrimitiveType((IType)asType);
        root = this.numberConvert((IType)(bDecimal ? JavaTypes.pDOUBLE() : JavaTypes.pLONG()), primitiveTypeAsType, root);
        if (StandardCoercionManager.isBoxed((IType)asType)) {
            root = this.boxValueToType(asType, root);
        }
        IRElement[] iRElementArray = new IRElement[2];
        iRElementArray[0] = tempLhsAssn;
        iRElementArray[1] = this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), (IRExpression)(asType.isPrimitive() ? (ILanguageLevel.Util.STANDARD_GOSU() ? this.buildComposite(new IRElement[]{this.buildThrow(this.buildNewExpression(TypeAsTransformer.getDescriptor(NullPointerException.class), Collections.emptyList(), Collections.emptyList()))}) : this.convertBoxedNullToPrimitive(TypeLord.getBoxedTypeFromPrimitiveType(asType))) : this.nullLiteral()), root, asTypeDesc);
        return this.buildComposite(iRElementArray);
    }

    private IRExpression callCoercer(IRExpression root, IType lhsType) {
        ICoercer coercer = ((ITypeAsExpression)this._expr()).getCoercer();
        if (coercer == MetaTypeToClassCoercer.instance() && ((IMetaType)lhsType).getType() instanceof IHasJavaClass) {
            IType lhsDeclaredType;
            if (((ITypeAsExpression)this._expr()).getLHS() instanceof ITypeLiteralExpression && !((lhsDeclaredType = ((IMetaType)((ITypeAsExpression)this._expr()).getLHS().getType()).getType()) instanceof ITypeVariableType) && !(lhsDeclaredType instanceof ITypeVariableArrayType)) {
                return this.pushConstant(TypeAsTransformer.getDescriptor(((IMetaType)lhsType).getType()));
            }
            IRSymbol rootValue = this._cc().makeAndIndexTempSymbol(root.getType());
            return this.buildComposite(new IRElement[]{this.buildAssignment(rootValue, root), this.buildNullCheckTernary((IRExpression)this.identifier(rootValue), this.pushNull(), this.callMethod(IHasJavaClass.class, "getBackingClass", new Class[0], this.checkCast(IHasJavaClass.class, (IRExpression)this.identifier(rootValue)), Collections.emptyList()))});
        }
        if (coercer == BlockCoercer.instance()) {
            IBlockType type = (IBlockType)((ITypeAsExpression)this._expr()).getType();
            if (type.getReturnType() == JavaTypes.pVOID() && type.areParamsCompatible((IFunctionType)((IBlockType)lhsType))) {
                Class<?> procedureIface;
                IRSymbol rootValue = this._cc().makeAndIndexTempSymbol(root.getType());
                try {
                    procedureIface = Class.forName("gw.lang.function.IProcedure" + ((IBlockType)lhsType).getParameterTypes().length);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return this.buildComposite(new IRElement[]{this.buildAssignment(rootValue, root), this.checkCast(procedureIface, this.callStaticMethod(BlockWrapper.class, "wrapFunctionAsProcedure", new Class[]{Object.class, Class.class}, Arrays.asList(this.identifier(rootValue), this.pushConstant(procedureIface))))});
            }
        } else {
            if (coercer == MethodReferenceCoercer.instance()) {
                IRSymbol rootValue = this._cc().makeAndIndexTempSymbol(root.getType());
                return this.buildComposite(new IRElement[]{this.buildAssignment(rootValue, root), this.callMethod(IMethodReference.class, "copyWithVoidReturn", new Class[0], (IRExpression)this.identifier(rootValue), Collections.emptyList())});
            }
            if (coercer == FeatureReferenceToBlockCoercer.instance()) {
                IRSymbol rootValue = this._cc().makeAndIndexTempSymbol(root.getType());
                return this.buildComposite(new IRElement[]{this.buildAssignment(rootValue, root), this.checkCast(((ITypeAsExpression)this._expr()).getType(), this.callStaticMethod(BlockWrapper.class, "toBlock", new Class[]{FeatureReference.class, Boolean.TYPE}, Arrays.asList(this.identifier(rootValue), this.pushConstant(((IFunctionType)((ITypeAsExpression)this._expr()).getType()).getReturnType() != JavaTypes.pVOID()))))});
            }
        }
        IType exprType = ((ITypeAsExpression)this._expr()).getType();
        if (coercer == IdentityCoercer.instance() && !exprType.isPrimitive() || exprType instanceof CompoundType || this.areAssignableBytecodeTypes(coercer, exprType, lhsType)) {
            if (!lhsType.isPrimitive() && lhsType != exprType) {
                if ((lhsType == JavaTypes.OBJECT() || lhsType.isInterface()) && TypeAsTransformer.isBytecodeType(exprType) && !this.isStructureType(exprType)) {
                    IRType asType = TypeAsTransformer.getDescriptor(exprType);
                    IRSymbol rootValue = this._cc().makeAndIndexTempSymbol(root.getType());
                    root = this.buildComposite(new IRElement[]{this.buildAssignment(rootValue, root), this.buildTernary((IRExpression)new IRConditionalOrExpression((IRExpression)new IRInstanceOfExpression((IRExpression)this.identifier(rootValue), asType), (IRExpression)this.buildEquals((IRExpression)this.identifier(rootValue), this.nullLiteral())), this.checkCast(exprType, (IRExpression)this.identifier(rootValue)), exprType == JavaTypes.STRING() ? this.fastStringCoercion((IRExpression)this.identifier(rootValue), lhsType) : this.coerce((IRExpression)this.identifier(rootValue), (ICoercer)RuntimeCoercer.instance()), asType)});
                } else {
                    root = this.checkCast(exprType, root);
                }
            }
            return this.boxValue(lhsType, root);
        }
        if (coercer instanceof StringCoercer || exprType == JavaTypes.STRING()) {
            if (lhsType.isPrimitive()) {
                return this.fastStringCoercion(root, lhsType);
            }
            IRType asType = TypeAsTransformer.getDescriptor(exprType);
            IRSymbol rootValue = this._cc().makeAndIndexTempSymbol(root.getType());
            return this.buildComposite(new IRElement[]{this.buildAssignment(rootValue, root), this.buildTernary((IRExpression)new IRConditionalOrExpression((IRExpression)new IRInstanceOfExpression((IRExpression)this.identifier(rootValue), asType), (IRExpression)this.buildEquals((IRExpression)this.identifier(rootValue), this.nullLiteral())), this.checkCast(exprType, (IRExpression)this.identifier(rootValue)), this.fastStringCoercion((IRExpression)this.identifier(rootValue), lhsType), asType)});
        }
        return this.coerce(this.boxValue(lhsType, root), coercer);
    }

    private boolean areAssignableBytecodeTypes(ICoercer coercer, IType asType, IType lhsType) {
        return !(!(coercer instanceof IdentityCoercer) && coercer != null || !asType.isAssignableFrom(lhsType) && !lhsType.isAssignableFrom(asType) || !TypeSystem.isBytecodeType((IType)lhsType) || !TypeSystem.isBytecodeType((IType)asType));
    }

    private boolean isStructureType(IType exprType) {
        return exprType instanceof IGosuClass && ((IGosuClass)exprType).isStructure();
    }

    private IRExpression coerce(IRExpression root, ICoercer coercer) {
        IRExpression result;
        if (coercer instanceof FunctionFromInterfaceCoercer) {
            IFunctionType returnType = (IFunctionType)((ITypeAsExpression)this._expr()).getReturnType();
            int length = returnType.getParameterTypes().length;
            String functionTypeName = returnType.getReturnType() == JavaTypes.pVOID() ? "gw.lang.function.IProcedure" + length : "gw.lang.function.IFunction" + length;
            IType functionType = TypeSystem.getByFullName((String)functionTypeName);
            result = this.callStaticMethod(FunctionFromInterfaceCoercer.class, "doCoercion", new Class[]{Class.class, Class.class, Object.class}, TypeAsTransformer.exprList(this.classLiteral(IRTypeFactory.get(functionType)), this.classLiteral(IRTypeFactory.get(((ITypeAsExpression)this._expr()).getLHS().getType())), root));
        } else {
            IRExpression coercerExpression = null;
            if (coercer != null) {
                if (coercer instanceof BasePrimitiveCoercer) {
                    for (Field f : BasePrimitiveCoercer.class.getDeclaredFields()) {
                        try {
                            Object value;
                            LockingLazyVar lv;
                            if (!Modifier.isPublic((int)f.getModifiers()) || !LockingLazyVar.class.isAssignableFrom(f.getType()) || (lv = (LockingLazyVar)(value = f.get(null))).get() != coercer) continue;
                            IRExpression coercerField = this.getStaticField(TypeSystem.get(BasePrimitiveCoercer.class), f.getName(), JavaClassIRType.get(LockingLazyVar.class), IRelativeTypeInfo.Accessibility.PUBLIC);
                            IRSymbol coercerSym = new IRSymbol(this._cc().makeTempSymbolName(), JavaClassIRType.get(LockingLazyVar.class), true);
                            this._cc().putSymbol(coercerSym);
                            IRAssignmentStatement tempAssignStmt = this.buildAssignment(coercerSym, coercerField);
                            IRMethodCallExpression getCoercerCall = this.buildMethodCall(LockingLazyVar.class, "get", Object.class, new Class[0], (IRExpression)new IRIdentifier(coercerSym), Collections.emptyList());
                            coercerExpression = new IRCompositeExpression(new IRElement[]{tempAssignStmt, getCoercerCall});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else {
                    coercerExpression = this.callStaticMethod(coercer.getClass(), "instance", new Class[0], TypeAsTransformer.exprList(new IRExpression[0]));
                }
            } else {
                coercerExpression = this.pushNull();
            }
            IType type = ((ITypeAsExpression)this._expr()).getType();
            result = this.callStaticMethod(TypeAsTransformer.class, "coerceValue", new Class[]{Object.class, IType.class, ICoercer.class}, TypeAsTransformer.exprList(root, this.pushType(type), coercerExpression));
        }
        if (!((ITypeAsExpression)this._expr()).getType().isPrimitive()) {
            result = this.checkCast(((ITypeAsExpression)this._expr()).getType(), result);
        }
        return result;
    }

    private IRExpression maybeMakePrimitive(IRExpression lhsExpression) {
        IType asType = ((ITypeAsExpression)this._expr()).getType();
        if (!asType.isPrimitive()) {
            return null;
        }
        IType lhsType = ((ITypeAsExpression)this._expr()).getLHS().getType();
        if (lhsType.isPrimitive()) {
            return null;
        }
        if (lhsType == JavaTypes.BOOLEAN() && asType == JavaTypes.pBOOLEAN()) {
            return this.convertBoxedToPrimitive(lhsType, Boolean.class, "booleanValue", lhsExpression);
        }
        if (lhsType == JavaTypes.BYTE() && asType == JavaTypes.pBYTE()) {
            return this.convertBoxedToPrimitive(lhsType, Byte.class, "byteValue", lhsExpression);
        }
        if (lhsType == JavaTypes.CHARACTER() && asType == JavaTypes.pCHAR()) {
            return this.convertBoxedToPrimitive(lhsType, Character.class, "charValue", lhsExpression);
        }
        if (lhsType == JavaTypes.SHORT() && asType == JavaTypes.pSHORT()) {
            return this.convertBoxedToPrimitive(lhsType, Short.class, "shortValue", lhsExpression);
        }
        if (lhsType == JavaTypes.INTEGER() && asType == JavaTypes.pINT()) {
            return this.convertBoxedToPrimitive(lhsType, Integer.class, "intValue", lhsExpression);
        }
        if (lhsType == JavaTypes.LONG() && asType == JavaTypes.pLONG()) {
            return this.convertBoxedToPrimitive(lhsType, Long.class, "longValue", lhsExpression);
        }
        if (lhsType == JavaTypes.FLOAT() && asType == JavaTypes.pFLOAT()) {
            return this.convertBoxedToPrimitive(lhsType, Float.class, "floatValue", lhsExpression);
        }
        if (lhsType == JavaTypes.DOUBLE() && asType == JavaTypes.pDOUBLE()) {
            return this.convertBoxedToPrimitive(lhsType, Double.class, "doubleValue", lhsExpression);
        }
        return null;
    }

    public static Object coerceValue(Object value, IType type, ICoercer coercer) {
        Object retValue = value;
        if (type == GosuParserTypes.NUMBER_TYPE()) {
            retValue = CommonServices.getCoercionManager().makeDoubleFrom(value);
        } else if (type == GosuParserTypes.STRING_TYPE()) {
            retValue = CommonServices.getCoercionManager().makeStringFrom(value);
        } else if (type == GosuParserTypes.DATETIME_TYPE()) {
            retValue = CommonServices.getCoercionManager().makeDateFrom(value);
        } else if (coercer != null && (value != null || coercer.handlesNull())) {
            retValue = coercer.coerceValue(type, value);
        }
        if (retValue == StandardCoercionManager.NO_DICE) {
            throw new ClassCastException(value + " cannot be cast to " + type.getDisplayName());
        }
        return retValue;
    }

    private IRExpression convertBoxedToPrimitive(IType lhsType, Class cls, String methodName, IRExpression lhsExpression) {
        IRSymbol tempRootSymbol = this._cc().makeAndIndexTempSymbol(TypeAsTransformer.getDescriptor(lhsType));
        return this.buildComposite(new IRElement[]{this.buildAssignment(tempRootSymbol, lhsExpression), this.buildNullCheckTernary((IRExpression)this.identifier(tempRootSymbol), this.convertBoxedNullToPrimitive(lhsType), this.callMethod(cls, methodName, new Class[0], (IRExpression)this.identifier(tempRootSymbol), TypeAsTransformer.exprList(new IRExpression[0])))});
    }

    public static boolean convertToPrimitiveFromBoxOrString_boolean(Object value) {
        return CommonServices.getCoercionManager().makePrimitiveBooleanFrom(value);
    }

    public static byte convertToPrimitiveFromBoxOrString_byte(Object value) {
        return (byte)CommonServices.getCoercionManager().makePrimitiveIntegerFrom(value);
    }

    public static char convertToPrimitiveFromBoxOrString_char(Object value) {
        return (char)CommonServices.getCoercionManager().makePrimitiveIntegerFrom(value);
    }

    public static short convertToPrimitiveFromBoxOrString_short(Object value) {
        return (short)CommonServices.getCoercionManager().makePrimitiveIntegerFrom(value);
    }

    public static int convertToPrimitiveFromBoxOrString_int(Object value) {
        return CommonServices.getCoercionManager().makePrimitiveIntegerFrom(value);
    }

    public static long convertToPrimitiveFromBoxOrString_long(Object value) {
        return CommonServices.getCoercionManager().makePrimitiveLongFrom(value);
    }

    public static float convertToPrimitiveFromBoxOrString_float(Object value) {
        return CommonServices.getCoercionManager().makePrimitiveFloatFrom(value);
    }

    public static double convertToPrimitiveFromBoxOrString_double(Object value) {
        return CommonServices.getCoercionManager().makePrimitiveDoubleFrom(value);
    }
}

