/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.lang.ir.IRStatement;
import gw.lang.parser.IStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.util.GosuStringUtil;

public abstract class AbstractStatementTransformer<T extends IStatement>
extends AbstractElementTransformer<T> {
    public AbstractStatementTransformer(TopLevelTransformationContext cc, T parsedElem) {
        super(cc, parsedElem);
    }

    public T _stmt() {
        return (T)((IStatement)this.getParsedElement());
    }

    protected final IRStatement compile() {
        IRStatement irStmt = this.compile_impl();
        this.visitStatementLineNumber(irStmt);
        return irStmt;
    }

    protected abstract IRStatement compile_impl();

    protected void visitStatementLineNumber(IRStatement irStatement) {
        this.visitStatementLineNumber(irStatement, (IStatement)this._stmt());
    }

    protected void visitStatementLineNumber(IRStatement irStatement, IStatement stmt) {
        if (irStatement != null) {
            int lineNumber = stmt.getLineNum();
            lineNumber = this.maybeGetTemplateLineNumber(stmt, lineNumber);
            irStatement.setLineNumber(lineNumber);
            if (lineNumber > 0) {
                irStatement.setOriginalSourceStatement(this._cc().getSourceFileRef() + ":" + lineNumber + " " + this._cc().getSourceLine(lineNumber));
            }
        }
    }

    private int maybeGetTemplateLineNumber(IStatement stmt, int lineNumber) {
        IType contextType;
        if (lineNumber <= 0) {
            return lineNumber;
        }
        IGosuClass gsClass = stmt.getGosuClass();
        if (gsClass instanceof IGosuProgram && (contextType = ((IGosuProgram)gsClass).getContextType()) != null) {
            try {
                String source = gsClass.getSource();
                int iIndex = GosuStringUtil.getIndexForLineNumber((String)source, (int)lineNumber);
                int iTemplateLineIndex = source.indexOf("//#LN#", iIndex);
                if (iTemplateLineIndex > 0) {
                    String strLine = source.substring(iTemplateLineIndex + "//#LN#".length() + 1, source.indexOf(13, iTemplateLineIndex));
                    lineNumber = Integer.parseInt(strLine);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lineNumber;
    }
}

