/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.statements.MapAssignmentStatement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.reflect.java.JavaTypes;
import java.util.AbstractMap;
import java.util.Map;

public class MapAssignmentStatementTransformer
extends AbstractStatementTransformer<MapAssignmentStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, MapAssignmentStatement stmt) {
        MapAssignmentStatementTransformer gen = new MapAssignmentStatementTransformer(cc, stmt);
        return gen.compile();
    }

    private MapAssignmentStatementTransformer(TopLevelTransformationContext cc, MapAssignmentStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        IRExpression root;
        Expression rootExpression = ((MapAssignmentStatement)this._stmt()).getMapAccessExpression().getRootExpression();
        IRExpression originalRoot = ExpressionTransformer.compile(rootExpression, this._cc());
        IRSymbol tempRoot = null;
        if (((MapAssignmentStatement)this._stmt()).isCompoundStatement()) {
            tempRoot = this._cc().makeAndIndexTempSymbol(originalRoot.getType());
            root = this.identifier(tempRoot);
            ExpressionTransformer.addTempSymbolForCompoundAssignment(rootExpression, tempRoot);
        } else {
            root = originalRoot;
        }
        Class clsMap = this.getMapType();
        IRExpression key = ExpressionTransformer.compile(((MapAssignmentStatement)this._stmt()).getMapAccessExpression().getKeyExpression(), this._cc());
        IRExpression value = ExpressionTransformer.compile(((MapAssignmentStatement)this._stmt()).getExpression(), this._cc());
        IRExpression putCall = this.callMethod(clsMap, "put", new Class[]{Object.class, Object.class}, root, MapAssignmentStatementTransformer.exprList(key, value));
        if (((MapAssignmentStatement)this._stmt()).isCompoundStatement()) {
            ExpressionTransformer.clearTempSymbolForCompoundAssignment();
            return new IRStatementList(false, new IRStatement[]{this.buildAssignment(tempRoot, originalRoot), this.buildMethodCall(putCall)});
        }
        return this.buildMethodCall(putCall);
    }

    private Class getMapType() {
        Class clsMap = JavaTypes.getJreType(AbstractMap.class).isAssignableFrom(((MapAssignmentStatement)this._stmt()).getMapAccessExpression().getRootExpression().getType()) ? AbstractMap.class : Map.class;
        return clsMap;
    }
}

